/*******************************************************************************
 * Copyright (c) 2012, 2020 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *   https://www.eclipse.org/legal/epl-2.0/
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial contribution
 *******************************************************************************/

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "com_api.h"
#include "kk_product.h"
#include "kk_findccu_handle.h"
#include "kk_login_handle.h"
#include "kk_data_handle.h"

//#include "kk_lan_queue.h"
#include "kk_lan_node_db.h"
#include "kk_lan_voice_panel.h"
#include "kk_data_mng.h"
#include "kk_lan_debug.h"


static char s_ccuid[DEVICE_CODE_LEN] = {0};
int kk_lan_get_ccuid(_OU_ char *device_code)
{
	strncpy(device_code, s_ccuid, strlen(s_ccuid));
	printf("kk_lan_get_ccuid:%s\n",s_ccuid);
	return strlen(s_ccuid);
}
static int _setDevice_Code(_IN_ char *device_code,int len)
{
	memset(s_ccuid, 0x0, DEVICE_CODE_LEN);
	printf("_setDevice_Code:%s\n",device_code);
	strncpy(s_ccuid, device_code, len);
	return len;
}
extern int HAL_Execel_cmd(char * cmd,char * buf,int buf_len,int* ret_len);
static void kk_lan_ccuid_init(void)
{
    uint8_t ccuid[DEVICE_CODE_LEN] = {0};
	uint8_t ccuidTmp[DEVICE_CODE_LEN] = {0};
    int ccuid_len = 0;
    HAL_Execel_cmd(GET_CCUID_CMD,(char *)ccuid,sizeof(ccuid),&ccuid_len);
    printf("GET_CCUID_CMD:%s\n",ccuid);
    if(ccuid_len > 0 && ccuid_len <= DEVICE_CODE_LEN){
		sprintf(ccuidTmp,"CCU_%s",ccuid);
        _setDevice_Code(ccuidTmp,strlen(ccuidTmp)-1);
    }else{
        _setDevice_Code(KK_CCU_ID,strlen(KK_CCU_ID));
    }
}

int prg_run_singleton(const char *prg)
{
	int fd;
	int ret;
	char pid_file[256] = {0};
	char pid_data[32] = {0};
	struct flock fl;
	
	if(prg==NULL){
		return -1;
	}
	
	memset(pid_file,0,sizeof(pid_file));
	snprintf(pid_file, sizeof(pid_file), "/var/run/%s.pid",prg);

	fd = open(pid_file, O_CREAT|O_WRONLY|O_TRUNC, 0644);
	if(fd<0){
		return -1;
	}
	
	fl.l_type = F_WRLCK;
	fl.l_start = 0;
	fl.l_whence = SEEK_SET;
	fl.l_len = 0;
	ret = fcntl(fd,F_SETLK,&fl);
	
	if(ret < 0){
		return -1;
	}
	
	memset(pid_data,0,sizeof(pid_data));
	snprintf(pid_data, sizeof(pid_data), "%d",getpid());
	
	return write(fd,pid_data,strlen(pid_data));
}



int main(int argc, char* argv[])
{
	int ret = 0;

	open("kk_lan",LOG_PID,LOG_USER);

	//if(prg_run_singleton(argv[0])<0){
		//debug_log(LOG_CRITICAL_LEVEL,"[%s]run singleton fail!\n",argv[0]);
		//return -1;
	//}

	kk_lan_ccuid_init();

	/*set the callback to get the device date to cloud*/
	kk_ipc_init(IPC_APP2MID,(ipc_cb*)KK_Data_FromMid,NULL,NULL);
	kk_findccu_handle_init();
	kk_map_dev_init();
	kk_login_init();
	//kk_voice_panel_init(argc,argv);

	//lan_queue_init();
	kk_lan_db_node_init();
	//kk_handle_sync_info();

	while(1){
		sleep(1);
	}
	return 0;
}

