#ifndef _LOG_DEBUG_H
#define _LOG_DEBUG_H

#include <stdio.h>
#include <time.h>

#define syslog_en 1
#define LOG_LEVEL				LOG_NORMAL_LEVEL


#define LOG_NORMAL_LEVEL		1 //亮白色
#define LOG_DEBUG_LEVEL			2 //绿色
#define LOG_INFO_LEVEL			3 //蓝色
#define LOG_FOCUS_LEVEL			4 //黄色
#define LOG_WARNING_LEVEL		5 //蓝绿色
#define LOG_ERROR_LEVEL			6 //紫色
#define LOG_CRITICAL_LEVEL		7 //红色





#define LOG_LEVEL_(x)			LOG_LEVEL_##x

#define LOG_LEVEL_1				LOG_NORMAL_ACT
#define LOG_LEVEL_2				LOG_DEBUG_ACT
#define LOG_LEVEL_3				LOG_INFO_ACT
#define LOG_LEVEL_4				LOG_FOCUS_ACT
#define LOG_LEVEL_5				LOG_WARNING_ACT
#define LOG_LEVEL_6				LOG_ERROR_ACT
#define LOG_LEVEL_7				LOG_CRITICAL_ACT

#define LOG_NORMAL_ACT			"\033[0;1;37m"
#define LOG_DEBUG_ACT			"\033[0;1;32m"
#define LOG_INFO_ACT			"\033[0;1;34m"
#define LOG_FOCUS_ACT			"\033[0;1;33m"
#define LOG_WARNING_ACT			"\033[0;1;36m"
#define LOG_ERROR_ACT			"\033[0;1;35m"
#define LOG_CRITICAL_ACT		"\033[0;1;31m"


#if (syslog_en)
	#define debug_log(level,format,...)	do { \
		if( level >= LOG_LEVEL && level <= LOG_CRITICAL_LEVEL) { \
			char buff[64] = {0};\
			time_t curTime = time(NULL); \
			struct tm *c = gmtime(&curTime);\
			snprintf(buff,sizeof(buff),"%d-%d-%d %d:%d:%d",(c->tm_year+1900),(c->tm_mon+1),c->tm_mday,c->tm_hour,c->tm_min,c->tm_sec);\
			printf("%s%s [%s:%d(%s)] "format"\033[m", LOG_LEVEL_(level),buff,__FILE__,__LINE__,__func__,##__VA_ARGS__); \
		} \
	}while(0)
#else
	#define debug_log(level,format,...)
#endif









#endif

