#include "kk_tsl_zigbee_map.h"
#include "kk_test.h"


kk_tsl_zigbee_map_t g_tsl_zigbee_map [] = {
	{
		ZIGBEE_COO_PRODUCT_CODE,
		1,
		{
			{KK_TSL_DATA_TYPE_TEXT,"NetChannelState",KK_DUMMY_EP,rpc_nwkPermitJoin,0,0,NULL},
		}
	},	
	{
		TEST_PRODUCT_CODE,
		3,
		{
			{KK_TSL_DATA_TYPE_TEXT,"OperationMode",KK_PRIMARY_EP,kk_zcl_windowCovering_OperationMode_set,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID,kk_report_global_onoff_attribute},//开
			{KK_TSL_DATA_TYPE_TEXT,"WorkMode",KK_PRIMARY_EP,kk_zcl_windowCovering_mode_set,ZCL_WINDOW_COVERING_CLUSTER_ID,ZCL_MODE_ATTRIBUTE_ID,kk_report_windowCovering_mode_attribute},
			{KK_TSL_DATA_TYPE_TEXT,"Position",KK_PRIMARY_EP,kk_zcl_windowCovering_position_set,ZCL_WINDOW_COVERING_CLUSTER_ID,ZCL_CURRENT_LIFT_PERCENTAGE_ATTRIBUTE_ID,kk_report_windowCovering_position_attribute},
		}
	},
};

int kk_find_ctrl_obj(const char *productCode)
{
	int map_num = sizeof(g_tsl_zigbee_map) / sizeof(kk_tsl_zigbee_map_t);
	int index = 0;
	for(index = 0;index < map_num; index++)
	{
		if(!strcmp(productCode,g_tsl_zigbee_map[index].productCode))
		{
			return index;
		}
	}
	return -1;
}

int kk_get_Identity_Num(int index)
{
	return g_tsl_zigbee_map[index].num;
}
int kk_get_map_Num(void)
{
	return sizeof(g_tsl_zigbee_map) / sizeof(kk_tsl_zigbee_map_t);
}



