#ifndef _KK_TEST_H
#define _KK_TEST_H
#include "rpc_network_operate.h"
#include "network-creator.h"
#include "network-creator-security.h"
#include "RPC_API.h"
#include "com_api.h"
#include "zb_device_id.h"
#include "kk_device_manager.h"

#define KK_REPORT_DEVICE_JOINED_TYPE						"/thing/topo/add"
#define KK_REPORT_DEVICE_LEFT_TYPE						"/thing/topo/delete"
#define KK_REPORT_ATTRIBUTE_TYPE						    "/thing/event/property/post"

#define KK_IPC_VERSION										"1.0"
#define KK_REPORT_DEVICE_JOINED_METHOD						"thing.topo.add"
#define KK_REPORT_DEVICE_LEAVE_METHOD						"thing.topo.delete"
#define KK_REPORT_ATTRIBUTE_METHOD							"thing.event.property.post"
#define KK_READ_ATTRIBUTE_METHOD							"thing.service.property.get"

#define ZIGBEE_COO_PRODUCT_CODE "2"

#define TEST_PRODUCT_CODE "24"
#define GW2CCU_PROTOCOL "tcp"
#define GW_DEVICE_CODE "1122334455667788"


#define KK_EP(x)						(x)


#define KK_DUMMY_EP						KK_EP(0)
#define KK_PRIMARY_EP					KK_EP(1)


#define KK_DUMMY_CLUSTER_ID				0xffff
#define KK_DUMMY_ATTRIBUTE_ID			0xffff


cJSON *rpc_Control(jrpc_context * ctx, cJSON * params, cJSON *id,cJSON *mac);
cJSON *rpc_read_attribue(jrpc_context * ctx, cJSON * params, cJSON *id,cJSON *mac);
int kk_zcl_onoff_set(jrpc_context * ctx,const char *mac,unsigned char ep,void* data);

int kk_zcl_windowCovering_OperationMode_set(jrpc_context * ctx,const char *mac,unsigned char ep,void* data);
int kk_zcl_windowCovering_mode_set(jrpc_context * ctx,const char *mac,unsigned char ep,void* data);
int kk_zcl_windowCovering_position_set(jrpc_context * ctx,const char *mac,unsigned char ep,void* data);

int kk_report_global_onoff_attribute(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data);
int kk_report_windowCovering_mode_attribute(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data);
int kk_report_windowCovering_position_attribute(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data);




int kk_sendData2CCU(char* data, int len);

int rpc_nwkPermitJoin(jrpc_context * ctx,const char *mac,unsigned char ep,void* data);


void kk_dispatch_report_attribute(EmberEUI64 eui64,
									uint8_t EP,
									EmberAfClusterId clusterId,
									EmberAfAttributeId attributeId,
									uint8_t dataType,
									uint8_t len,
									uint8_t *data);
									

#define RPC_KK_TEST_FUNCTION_TABLE	\
	{(rpc_function*)rpc_Control,"/thing/service/property/set"},\
	{(rpc_function*)rpc_Control,KK_READ_ATTRIBUTE_METHOD}

	





enum {
	WC_normal_dir								= 0,//"正转"
	WC_reversed_dir 							= 1,//"反转"
	WC_calibration_mode 						= 2,//"校验"
}windowCoveringMode;
















#endif
