#ifndef __KK_PRODUCT_CODE_H
#define __KK_PRODUCT_CODE_H
/****************** ******************************************************************
* File Name			: kk_product_code.h
* Author			: yjq
* data				: 2020/09/01
*************************************************************************************/

#define KK_PRODUCT_CODE_STRING_ENABLE

typedef struct{
	char *code;
	char *modelId;
	#ifdef KK_PRODUCT_CODE_STRING_ENABLE
	char *name;
	#endif
}kk_product_code_s;

#define _2EP_ZERO_FIRE_LIGHTING_MODULE_CODE			"11"
#define DOOYA_CURTAIN_MOTOR_CODE					"24"
#define _1EP_ZERO_FIRE_PANEL_CODE					"83"
#define _2EP_ZERO_FIRE_PANEL_CODE					"84"
#define _3EP_ZERO_FIRE_PANEL_CODE					"85"
#define ADJUSTABLE_LIGHT_KNOB_PANEL_CODE			"89"
#define CHOPIN_WALL_OUTLET_10A_CODE					"90"
#define CHOPIN_WALL_OUTLET_16A_CODE					"91"
#define _1EP_STARS_ZERO_FIRE_PANEL_CODE				"96"
#define _2EP_STARS_ZERO_FIRE_PANEL_CODE				"97"
#define _3EP_STARS_ZERO_FIRE_PANEL_CODE				"98"
#define _1EP_CHOPIN_ZERO_FIRE_PANEL_CODE			"102"
#define _2EP_CHOPIN_ZERO_FIRE_PANEL_CODE			"103"
#define _3EP_CHOPIN_ZERO_FIRE_PANEL_CODE			"104"
#define _1EP_CHOPIN_CURTAIN_MOTOR_CODE				"105"
#define _2EP_CHOPIN_CURTAIN_MOTOR_CODE				"106"
#define _1EP_PLATINUM_SWITCH_CODE					"1002"
#define _2EP_PLATINUM_SWITCH_CODE					"1003"
#define _3EP_PLATINUM_SWITCH_CODE					"1004"
#define PLATINUM_ACTUATOR_PANEL_CODE				"1007"
#define RGB_LIGHT_CODE								"1022"



#define DOOYA_CURTAIN_MOTOR_MODEL_ID				"02020000"

#define CHOPIN_WALL_OUTLET_10A_CODE_NAME_MODEL_ID	"00518620"
#define CHOPIN_WALL_OUTLET_16A_CODE_NAME_MODEL_ID	"00518626"

#define _1EP_STARS_ZERO_FIRE_PANEL_MODEL_ID			"00068611"
#define _2EP_STARS_ZERO_FIRE_PANEL_MODEL_ID			"00068612"
#define _3EP_STARS_ZERO_FIRE_PANEL_MODEL_ID			"00068613"
#define _1EP_PLATINUM_SWITCH_MODEL_ID				"00068601"
#define _2EP_PLATINUM_SWITCH_MODEL_ID				"00068602"
#define _3EP_PLATINUM_SWITCH_MODEL_ID				"00068603"
#define PLATINUM_ACTUATOR_PANEL_NAME_MODEL_ID		"00038603"
#define RGB_LIGHT_NAME_MODEL_ID						"01020001"
#define _1EP_CHOPIN_ZERO_FIRE_PANEL_MODEL_ID		"00068621"
#define _2EP_CHOPIN_ZERO_FIRE_PANEL_MODEL_ID		"00068622"
#define _3EP_CHOPIN_ZERO_FIRE_PANEL_MODEL_ID		"00068623"
#define _1EP_CHOPIN_CURTAIN_MOTOR_MODEL_ID			"00038621"
#define _2EP_CHOPIN_CURTAIN_MOTOR_MODEL_ID			"00038622"









#ifdef KK_PRODUCT_CODE_STRING_ENABLE
#define _2EP_ZERO_FIRE_LIGHTING_MODULE_NAME			"两路零火灯光模块"
#define DOOYA_CURTAIN_MOTOR_NAME					"智能窗帘电机（杜亚）"
#define _1EP_ZERO_FIRE_PANEL_NAME					"一路零火面板（肖邦系列）"
#define _2EP_ZERO_FIRE_PANEL_NAME					"两路零火面板（肖邦系列）"
#define _3EP_ZERO_FIRE_PANE_NAME					"三路零火面板（肖邦系列）"
#define ADJUSTABLE_LIGHT_KNOB_PANEL_NAME			"可调光旋钮面板（肖邦系列）"
#define CHOPIN_WALL_OUTLET_10A_CODE_NAME			"入墙插座10A（肖邦系列）"
#define CHOPIN_WALL_OUTLET_16A_CODE_NAME			"入墙插座16A（肖邦系列）"
#define _1EP_STARS_ZERO_FIRE_PANEL_NAME				"星辰一路零火面板"
#define _2EP_STARS_ZERO_FIRE_PANEL_NAME				"星辰两路零火面板"
#define _3EP_STARS_ZERO_FIRE_PANEL_NAME				"星辰三路零火面板"
#define _1EP_CHOPIN_ZERO_FIRE_PANEL_NAME			"一路零火面板（肖邦系列）定制版"
#define _2EP_CHOPIN_ZERO_FIRE_PANEL_NAME			"两路零火面板（肖邦系列）定制版"
#define _3EP_CHOPIN_ZERO_FIRE_PANEL_NAME			"三路零火面板（肖邦系列）定制版"
#define _1EP_CHOPIN_CURTAIN_MOTOR_NAME				"一路窗帘面板（肖邦系列）定制版"
#define _2EP_CHOPIN_CURTAIN_MOTOR_NAME				"两路窗帘面板（肖邦系列）定制版"
#define _1EP_PLATINUM_SWITCH_NAME					"铂金系列一路灯控"
#define _2EP_PLATINUM_SWITCH_NAME					"铂金系列两路灯控"
#define _3EP_PLATINUM_SWITCH_NAME					"铂金系列三路灯控"
#define PLATINUM_ACTUATOR_PANEL_NAME				"铂金系列推窗面板"
#define RGB_LIGHT_NAME								"RGBW灯带"
#endif

/*
	Z3D_IASZONE = 0x04020000,				// IAS Zone 设备ID，不表示具体设备
	Z3D_IASWD = 0x04030000, 				// IAS WD 设备ID，不表示具体设备

	// 高级别状态指示类设备，APP客户端中显示状态需要和设备实际状态保持高度一致！状态上报不允许丢失，所以需要尝试多次上报！
	Z3D_SMARTPLUG = 0x00510000, 			// 智能插座插座
	Z3D_IAS_CONTACT_SWITCH = 0x04020015,	// 门磁: IAS Zone device id + device type
	Z3D_IAS_FIRE_SENSOR = 0x04020028,		// 烟雾传感器: IAS Zone device id + device type
	Z3D_IAS_WATER_SENSOR = 0x0402002A,		// 水浸传感器: IAS Zone device id + device type
	Z3D_IAS_GAS_SENSOR = 0x0402002B,		// 气体传感器: IAS Zone device id + device type
	Z3D_IAS_WD = 0x04030225,				// 标准报警器（声光报警等）: IAS WD device id + device type[in IAS Zone]
	Z3D_WINDOW_COVERING = 0x02020000,		// 窗帘电机（杜亚）
	
	// Serial - 铂金
	Z3D_BJSP_S1G	= 0x00068601,			// 铂金开关面板1路
	Z3D_BJSP_S2G	= 0x00068602,			// 铂金开关面板2路
	Z3D_BJSP_S3G	= 0x00068603,			// 铂金开关面板3路
	Z3D_BJPP_C20	= 0x00518610,			// 铂金墙插面板10A
	Z3D_BJPP_C26	= 0x00518616,			// 铂金墙插面板16A
	Z3D_BJCP_S1G	= 0x00038601,			// 铂金窗帘面板1路
	Z3D_BJOWP_S1G	= 0x00038603,			// 铂金一路推窗器面板
	Z3D_BJDLP_S1G	= 0x01018601,			// 铂金调光面板
	Z3D_BJSCP_S3G	= 0x00048601,			// 铂金情景面板(3路)
	Z3D_BJQKP_S3G	= 0x00048602,			// 铂金快捷面板(3路)
	Z3D_BJSOS_PANEL = 0X0402802C,			// 铂金SOS面板(零火线)
	Z3D_BJSOS_BUTTON= 0X0402812C,			// 铂金SOS按钮(电池)

	// Serial - 星辰
	Z3D_XCSP_S1G	= 0x00068611,			// 星辰开关面板1路
	Z3D_XCSP_S2G	= 0x00068612,			// 星辰开关面板2路
	Z3D_XCSP_S3G	= 0x00068613,			// 星辰开关面板3路
	Z3D_XCCP_S1G	= 0x00038611,			// 星辰窗帘面板1路
	Z3D_XCCP_S2G	= 0x00038612,			// 星辰窗帘面板2路
	Z3D_XCSCP_S4G	= 0x00048611,			// 星辰情景面板(4路)

	// Serial - 肖邦
	Z3D_XBSP_S1G	= 0x00068621,			// 肖邦开关面板1路
	Z3D_XBSP_S2G	= 0x00068622,			// 肖邦开关面板2路
	Z3D_XBSP_S3G	= 0x00068623,			// 肖邦开关面板3路
	Z3D_XBPP_D20	= 0x00518620,			// 肖邦墙插面板10A
	Z3D_XBPP_D26	= 0x00518626,			// 肖邦墙插面板16A
	Z3D_XBCP_S1G	= 0x00038621,			// 肖邦窗帘面板1路
	Z3D_XBCP_S2G	= 0x00038622,			// 肖邦窗帘面板2路
	Z3D_XBSCP_S4G	= 0x00048621,			// 肖邦情景面板(4路)
	Z3D_LMCW_LOCK0	= 0x01018000,			// 创维门锁不带指纹
	Z3D_LMCW_LOCK1	= 0x01018001,			// 创维门锁带指纹
	// 低等级状态指示类设备，APP客户端中仅记录历史状态，状态上报允许存在丢失
	Z3D_ENVI_SENSOR = 0x03020000,			// 温度传感器: Temperature device id + model id，注意控客环境同时存在温度和湿度，为了兼容其他厂家仅有温度的传感，这里设备类型仅使用温度device_id+model_id来确定！

	// 动作触发类设备，APP客户端中仅记录历史操作，动作触发上报为实时，且允许存在丢失
	Z3D_SWITCH = 0x00510001,				// 快捷按钮
	Z3D_IAS_MOTION_SENSOR = 0x0402000D, 	// 移动传感器: IAS Zone device id + device type

	Z3D_UNKNOW = 0xFFFFFFFF,				// 未知类型
*/


extern kk_product_code_s kk_product_code[];


























#endif

