#include "kk_device_manager.h"
/****************** ******************************************************************
* File Name			: kk_device_manager.c
* Author			: yjq
* data				: 2020/09/01
*************************************************************************************/
#define KK_GP_EP									242

static int kk_get_device_ep_number(EmberEUI64 mac,uint8_t *buffer,uint8_t maxLen,bool *over);


kk_device_table_s *kk_zb_device_table=NULL;



void kk_print_device_table(void)
{
	int i,cnt = 0;
	kk_device_table_s *ptr = kk_zb_device_table;
	emberAfCorePrintln("\n-----------kk device table-----------\n");

	while(ptr!=NULL){
		emberAfAppPrint("\n%d:",++cnt);
		emberAfAppPrint("\nMAC = " );
		emberAfPrintBigEndianEui64(ptr->mac);
		emberAfAppPrint("\nproductCode = %s",(ptr->productCode!=NULL)?ptr->productCode:"unknow");
		emberAfAppPrint("\nEP Number = %d",ptr->epNumber);
		for(i=0;i<ptr->epNumber;i++){
			if(i==0) emberAfAppPrint("\nEP=" );
			emberAfAppPrint("%d ",ptr->epValue[i]);
		}
		ptr = ptr->next;
	}

}
static kk_device_table_s *kk_device_table_create()
{
	emberAfCorePrintln("[KK device table] create!");
	
	kk_device_table_s *node = (kk_device_table_s *)malloc(sizeof(kk_device_table_s));

	if(node==NULL){
		emberAfCorePrintln("[KK device table] malloc fail!!!%s",__LINE__);
		return node;
	}

	MEMSET(node, 0, sizeof(kk_device_table_s));

	return node;
}

static kk_device_table_s *kk_device_table_find_next_empty()
{
	kk_device_table_s *ptr = kk_zb_device_table;

	if(ptr==NULL) return ptr;
	
	while(ptr!=NULL){
		if(ptr->next==NULL) return ptr;
		ptr = ptr->next;
	}
}

static void kk_device_fill(kk_device_table_s *ptr,EmberEUI64 mac,uint8_t epNum,uint8_t* epVal,char *productCode)
{
	emberAfPrintBigEndianEui64(mac);
	memcpy(ptr->mac,mac,sizeof(EmberEUI64));
	ptr->epNumber = epNum;
	ptr->epValue = (uint8_t *)malloc(epNum);
	memcpy(ptr->epValue,epVal,epNum);
	ptr->productCode = productCode;

}

kk_device_table_s * kk_device_find_by_mac(EmberEUI64 mac)
{
	kk_device_table_s *ptr = kk_zb_device_table;
	
	while(ptr!=NULL){
		if(MEMCOMPARE(ptr->mac,mac,sizeof(EmberEUI64))==0){
			return ptr;
		}
		ptr = ptr->next;
	}
	return NULL;
}
bool kk_device_find_by_mac11111(EmberEUI64 mac)
{
	kk_device_table_s *ptr = kk_zb_device_table;
	
	while(ptr!=NULL){
		if(MEMCOMPARE(ptr->mac,mac,sizeof(EmberEUI64))==0){
			return true;
		}
		ptr = ptr->next;
	}
	return false;
}

void kk_device_table_add(EmberEUI64 mac,uint8_t epNum,uint8_t* epVal,char *productCode)
{
	kk_device_table_s *ptr = kk_zb_device_table;
	kk_device_table_s *newNode;

	if(ptr==NULL){
		kk_zb_device_table = kk_device_table_create();
		ptr = kk_zb_device_table;		
		
		kk_device_fill(ptr,mac,epNum,epVal,productCode);
		
		return;
	}

	ptr = kk_device_table_find_next_empty();
	if(ptr!=NULL){
		newNode = kk_device_table_create();
		
		if(newNode!=NULL){
			ptr->next = newNode;
			kk_device_fill(newNode,mac,epNum,epVal,productCode);
		}
	}else{
		emberAfCorePrintln("[KK device table] fatal!!!%s",__LINE__);
	}
}

void kk_device_table_delete(EmberEUI64 mac)
{
	kk_device_table_s *ptr = kk_zb_device_table;
	kk_device_table_s *ptr_temp = kk_zb_device_table;
	if(ptr==NULL){
		emberAfCorePrintln("[KK device table] is empty!!!");
		return ;
	}
	while(ptr!=NULL){
		if(MEMCOMPARE(ptr->mac,mac,sizeof(EmberEUI64))==0){
			if(ptr->next==NULL){
				free(ptr->epValue);
				free(ptr);
				kk_zb_device_table = NULL;
				emberAfCorePrintln("[KK device table]delete,now is empty !!!");
				return ;
			}else{
				if(ptr==kk_zb_device_table){
					kk_zb_device_table = ptr->next;
					emberAfCorePrintln("[KK device table] delete list header");
					free(ptr->epValue);
					free(ptr);
					return ;
				}else{
					ptr_temp->next = ptr->next;
					free(ptr->epValue);
					free(ptr);
					emberAfCorePrintln("[KK device table] delete ");
					return ;
				}
			}
		}
		ptr_temp = ptr;
		ptr = ptr->next;
	}
}

static void kk_device_table_load(void)
{
	int i,flag;
	uint8_t epNum = 0;
	kk_device_table_s *p;
	EmberAfPluginDeviceTableEntry*ptr = emberAfDeviceTablePointer();
	uint8_t EP[KK_MAX_SUPPORT_ENDPOINT_NUMBER] = {0};

	emberAfCorePrintln("\n-------------kk device table load.-------------\n");
	for (i = 0; i < EMBER_AF_PLUGIN_DEVICE_TABLE_DEVICE_TABLE_SIZE; i++) {
		if(ptr[i].state!=EMBER_AF_PLUGIN_DEVICE_TABLE_STATE_NULL &&
			ptr[i].nodeId!=EMBER_AF_PLUGIN_DEVICE_TABLE_NULL_NODE_ID){
			p = kk_device_find_by_mac(ptr[i].eui64);//todo
			if(p==NULL){
				epNum = kk_get_device_ep_number(ptr[i].eui64,EP,KK_MAX_SUPPORT_ENDPOINT_NUMBER,NULL);
				kk_device_table_add(ptr[i].eui64,epNum,EP,TEST_PRODUCT_CODE);
			}
		}
	}
	kk_print_device_table();
}

////////////////////////////////////////////////////

void emberAfPluginDeviceTableInitialized(void)
{
	kk_device_table_load();
}


static int kk_match_device_id(uint16_t deviceId)
{
	int i;

	if(deviceId==0xffff) return -1;
	for(i=0;zb_device_id[i].deviceId!=0xffff;i++){
		if(zb_device_id[i].deviceId==deviceId){
			#ifdef ZIGBEE_DEVICE_ID_STRING_ENABLE
				emberAfDebugPrintln("[device]%s",zb_device_id[i].deviceIdString);
			#endif
		}
	}
	return -2;
}

static int kk_match_product_code(uint16_t deviceId,uint8_t num,uint8_t *ep)
{

}

static int kk_get_device_ep_number(EmberEUI64 mac,uint8_t *buffer,uint8_t maxLen,bool *over)
{
	uint16_t i;
	uint8_t num = 0;
	EmberAfPluginDeviceTableEntry*ptr = emberAfDeviceTablePointer();
	
	for (i = 0; i < EMBER_AF_PLUGIN_DEVICE_TABLE_DEVICE_TABLE_SIZE; i++) {
		if(MEMCOMPARE(ptr[i].eui64,mac,sizeof(EmberEUI64))==0 &&
			ptr[i].state != EMBER_AF_PLUGIN_DEVICE_TABLE_STATE_NULL &&
			ptr[i].nodeId!=EMBER_AF_PLUGIN_DEVICE_TABLE_NULL_NODE_ID){
			if(ptr[i].endpoint!=KK_GP_EP){
				buffer[num] = ptr[i].endpoint;
				++num;
				if(num>maxLen){
					return;
				}
			}
		}
	}
	
	return num;
}

void kk_dispatch_productCode(EmberEUI64 mac)
{
	uint16_t deviceTableIndex = emberAfDeviceTableGetFirstIndexFromEui64(mac);
	EmberAfPluginDeviceTableEntry*deviceTable = emberAfDeviceTablePointer();
	uint16_t deviceId = 0xffff;
	bool flag = 0;
	uint8_t epNum = 0;
	uint8_t EP[KK_MAX_SUPPORT_ENDPOINT_NUMBER] = {0};
	if(deviceTableIndex!=EMBER_AF_PLUGIN_DEVICE_TABLE_NULL_INDEX){
		deviceId = deviceTable[deviceTableIndex].deviceId;
	}

	if(kk_match_device_id(deviceId)==0){
		epNum = kk_get_device_ep_number(mac,EP,KK_MAX_SUPPORT_ENDPOINT_NUMBER,&flag);
		if(flag==true){
			emberAfCorePrintln("[Warring]device ep num= %d,max=%d",epNum,KK_MAX_SUPPORT_ENDPOINT_NUMBER);
		}
		kk_device_table_add(mac,epNum,EP,TEST_PRODUCT_CODE);
	}
}




























