#ifndef __KK_MSG_REPORT_H
#define __KK_MSG_REPORT_H

#include <stdio.h>
#include "app/framework/include/af.h"
#include ".././jsonrpc/jsonrpc-c.h"
#include ".././jsonrpc/rpccJSON.h"
#include "com_api.h"
#include "kk_zb_com.h"


#define KK_IPC_VERSION										"1.0"
#define KK_REPORT_DEVICE_BATCH_JOINED_METHOD				"thing.topo.batchAdd"
#define KK_REPORT_DEVICE_JOINED_METHOD						"thing.topo.add"
#define KK_REPORT_DEVICE_LEAVE_METHOD						"thing.topo.delete"
#define KK_REPORT_DEVICE_BATCH_LEAVE_METHOD					"thing.topo.batchDelete"
#define KK_REPORT_ADDWHITELIST_NOTIFY_METHOD				"thing.event.whiteListAddedNotification.post"
#define KK_REPORT_DELWHITELIST_NOTIFY_METHOD				"thing.event.whiteListDeletedNotification.post"



#define KK_REPORT_PROPERTY_MSG_TYPE						"/thing/event/property/post"
#define KK_SET_PROPERTY_REPLY_MSG_TYPE					"/thing/service/property/set_reply"
#define KK_GET_PROPERTY_REPLY_MSG_TYPE					"/thing/service/property/get_reply"
#define KK_GET_PROPERTY_MSG_TYPE						"/thing/service/property/get"


#define KK_GET_PROPERTY_REPLY_METHOD					"thing.service.property.get"






#define KK_REPORT_ALARM_METHOD								"thing.event.alarm.post"
#define KK_REPORT_ATTRIBUTE_METHOD							"thing.event.property.post"
#define KK_READ_ATTRIBUTE_METHOD							"thing.service.property.get"


#define KK_REPORT_ATTRIBUTE_TYPE						    "/thing/event/property/post"






#define KK_REPORT_DEVICE_BATCH_JOINED_TYPE					"/thing/topo/batch_add"
#define KK_REPORT_DEVICE_JOINED_TYPE						"/thing/topo/add"
#define KK_REPORT_DEVICE_LEFT_TYPE						    "/thing/topo/delete"
#define KK_REPORT_DEVICE_BATCH_LEFT_TYPE				    "/thing/topo/batch_delete"

#define KK_REPORT_ALARM_TYPE						    	"/thing/event/alarm/post"
#define KK_REPORT_ADDWHITELIST_NOTIFY_TYPE				    "/thing/event/whiteListAddedNotification/post"
#define KK_REPORT_DELWHITELIST_NOTIFY_TYPE				    "/thing/event/whiteListDeletedNotification/post"

#define GW2CCU_PROTOCOL "tcp"

//#define GATEWAY_TYPE_NCP

#ifdef GATEWAY_TYPE_NCP
    #undef GW2CCU_PROTOCOL
    #define GW2CCU_PROTOCOL "nanomsg"
#endif






int kk_sendData2CCU(char* data, int len);

void kk_msg_report_dev_leave(EmberEUI64 mac);
void kk_msg_report_dev_joined(EmberEUI64 mac,const char* productCode);
void kk_msg_report_property(cJSON *data,EmberEUI64 mac);
void kk_msg_report_alarm(cJSON *data,EmberEUI64 mac);













#endif

