/*
 * Copyright (C) 2020-2020 ikonke
 */

#ifndef _KK_COM_API_H_
#define _KK_COM_API_H_

#if defined(__cplusplus)
extern "C" {
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "ev.h"
#include "nn.h"
#include "pair.h"
#include "pubsub.h"
#include "pipeline.h"


//=====kk======================
typedef enum {
    IPC_APP2MID = 0,
    IPC_MID2APP,
    IPC_MID2PLAT,
    IPC_PLAT2MID,
    IPC_UNDEF
} ipc_type;
	
#define MSG_TYPE_STR              					"msgtype"
#define MSG_PRODUCT_TYPE_STR      					"productType"
#define MSG_PRODUCT_CODE_STR      					"productCode"
#define MSG_DEVICE_CODE_STR       					"deviceCode"
#define MSG_PAYLOAD_STR           					"payload"
#define MSG_INFO_STR              					"info"
#define MSG_INDENTIFIER_STR       					"identifier"
#define MSG_PARAMS_STR            					"params"
#define MSG_IOTClOUDSTATE_STR     					"IOTCloudState"
#define MSG_TOPO_CHANGE_TYPE_STR  					"changeType"
#define MSG_TOPO_CHANGE_DEVICES_STR  				"devices"
#define MSG_DEVICE_MAC    	      					"mac"
#define MSG_DEVICE_PARENTCODE     					"parentCode"
#define MSG_AREA_ADDROOM_ROOMNAME     	  			"roomName"
#define MSG_AREA_ROOM_ROOMID     	  				"roomId"
#define MSG_AREA_ROOM_EPNUM     	  				"epNum"
#define MSG_AREA_ROOM_ACTION     	  				"action"
#define MSG_AREA_ADDROOM_NOTIFICATION         		"addRoomNotification"
#define MSG_AREA_ADDROOM_NOTIFICATION_ROOMID        "addRoomNotification.roomId"
#define MSG_TIMER_SETLOCALTIMER_LOCALTIMER          "LocalTimer"
#define MSG_TIMER_SETLOCALTIMER_TIMER               "Timer"
#define MSG_TIMER_SETLOCALTIMER_ENABLE              "Enable"
#define MSG_TIMER_SETLOCALTIMER_ISVALID             "IsValid"
#define MSG_TIMER_SETLOCALTIMER_ZONEOFFSET          "TimezoneOffset"
#define MSG_TIMER_SETLOCALTIMER_TARGETS             "Targets"
#define MSG_TIMER_GETLOCALTIMER_GETLOCALTIMER       "getLocalTimer"
#define MSG_REBOOT_REBOOTNOTIFICATION               "rebootNotification"
#define MSG_TIMER_SETCOUNTDOWN_COUNTDOWN            "CountDown"
#define MSG_TIMER_SETCOUNTDOWN_DELAYTIME            "DelayTime"
#define MSG_TIMER_SETCOUNTDOWN_CURRENTTIME          "CurrentTime"
#define MSG_TIMER_SETCOUNTDOWN_GETCOUNTDOWN         "getCountDown"
#define MSG_PROPERTY_STR                            "property"

/************************LOCK KEY*************************/
#define MSG_KEYDELETE_NOTIFICATION_KEYID            "KeyDeletedNotification.KeyID"
#define MSG_KEYDELETE_NOTIFICATION_KEYTYPE          "KeyDeletedNotification.KeyType"
#define MSG_KEYDELETE_NOTIFICATION_KEYROLE          "KeyDeletedNotification.KeyRole"
#define MSG_KEYADD_NOTIFICATION_KEYID               "KeyAddNotification.KeyID"
#define MSG_KEYADD_NOTIFICATION_KEYTYPE             "KeyAddNotification.KeyType"
#define MSG_KEYADD_NOTIFICATION_KEYROLE             "KeyAddNotification.KeyRole"
#define MSG_KEYADD_NOTIFICATION_KEYISVALID          "KeyAddNotification.IsValid"
#define MSG_KEYADD_NOTIFICATION_KEYNAME             "KeyAddNotification.KeyName"
#define MSG_KEYADD_NOTIFICATION_KEYEFFECTIVE        "KeyAddNotification.KeyEffectiveTime"
#define MSG_KEYADD_NOTIFICATION_KEYEXPIRE           "KeyAddNotification.KeyExpiryTime"

#define MSG_KEYMODIFY_NOTIFICATION_KEYID            "KeyModifyNotification.KeyID"
#define MSG_KEYMODIFY_NOTIFICATION_KEYTYPE          "KeyModifyNotification.KeyType"
#define MSG_KEYMODIFY_NOTIFICATION_KEYROLE          "KeyModifyNotification.KeyRole"
#define MSG_KEYMODIFY_NOTIFICATION_KEYISVALID       "KeyModifyNotification.IsValid"
#define MSG_KEYMODIFY_NOTIFICATION_KEYNAME          "KeyModifyNotification.KeyName"
#define MSG_KEYMODIFY_NOTIFICATION_KEYEFFECTIVE     "KeyModifyNotification.KeyEffectiveTime"
#define MSG_KEYMODIFY_NOTIFICATION_KEYEXPIRE        "KeyModifyNotification.KeyExpiryTime"

#define MSG_KEYADD_KEYID               				"KeyID"
#define MSG_KEYADD_KEYTYPE             				"KeyType"
#define MSG_KEYADD_KEYROLE             				"KeyRole"
#define MSG_KEYADD_KEYISVALID          				"IsValid"
#define MSG_KEYADD_KEYNAME             				"KeyName"
#define MSG_KEYADD_KEYEFFECTIVE        				"KeyEffectiveTime"
#define MSG_KEYADD_KEYEXPIRE           				"KeyExpiryTime"
#define MSG_KEYADD_NOTIFICATION               		"KeyAddNotification"
#define MSG_KEYDELETE_NOTIFICATION                  "KeyDeletedNotification"
#define MSG_KEYMODIFY_NOTIFICATION                  "KeyModifyNotification"

/************************SCENE RELATION*************************/
#define MSG_SCENE_ARGS               				"args"
#define MSG_SCENE_NAME               				"name"
#define MSG_SCENE_SCENCTYPE              		    "sceneType"
#define MSG_SCENE_ENABLE              		    	"enable"
#define MSG_SCENE_TRIGGERS              		    "triggers"
#define MSG_SCENE_ITEMS              		    	"items"
#define MSG_SCENE_TYPE              		    	"type"
#define MSG_SCENE_EPNUM              		    	"epNum"
#define MSG_SCENE_PROPERTYNAME 						"propertyName"
#define MSG_SCENE_COMPARETYPE						"compareType"
#define MSG_SCENE_COMPAREVALUE						"compareValue"
#define MSG_SCENE_CONDITIONS              		    "conditions"
#define MSG_SCENE_STARTTIME              		    "startTime"
#define MSG_SCENE_ENDTIME              		    	"endTime"
#define MSG_SCENE_CROSSDAY              		    "crossDay"
#define MSG_SCENE_REPEATDAYS              		    "repeat_days"
#define MSG_SCENE_ACTIONS              		    	"actions"
#define MSG_SCENE_PROPERTYVALUE              		"propertyValue"
#define MSG_SCENE_DELAY              				"delay"
#define MSG_SCENE_SCENEID           				"sceneId"
#define MSG_SCENE_ADDNOTIFICATION_SCENEID           "addSceneNotification.sceneId"
#define MSG_SCENE_ADDNOTIFICATION          			"addSceneNotification"
#define MSG_SCENE_UPDATENOTIFICATION_SCENEID        "updateSceneNotification.sceneId"
#define MSG_SCENE_UPDATENOTIFICATION          		"updateSceneNotification"
#define MSG_SCENE_DELETENOTIFICATION_SCENEID        "deleteSceneNotification.sceneId"
#define MSG_SCENE_DELETENOTIFICATION          		"deleteSceneNotification"







typedef void ipc_cb(void* data, int len, char* chalMark);
int kk_ipc_init(ipc_type type, ipc_cb cb, char* chalMark, char* ip);
int kk_ipc_deinit(ipc_type type);
int kk_ipc_send(ipc_type type, void* data, int len);
int kk_ipc_send_ex(ipc_type type, void* data, int len, char* chalMark);

#if defined(__cplusplus)
}
#endif
#endif
