#!/bin/sh
nanomsg_File="/home/kk/lib/libnanomsg.so.5"
ev_File="/home/kk/lib/libev.so.4"
sqlite_File="/home/kk/lib/libsqlite3.so.0"

run_Dir="/usr/kk"
tsl_Dir="${run_Dir}/tsl"
dev_cfg_Dir="${run_Dir}/dev_config_table"

cd /sbin/
insmod /sbin/ssd1306-revision.ko
/sbin/oled >/dev/null 2>&1 &
sleep 1

if [ ! -d "$run_Dir" ]; then
	mkdir ${run_Dir}
fi


if [ ! -d "$tsl_Dir" ]; then
	cp -rf /home/kk/tsl ${run_Dir}/
fi


if [ ! -d "$dev_cfg_Dir" ]; then
	cp -rf /home/kk/dev_config_table ${run_Dir}
	sleep 1
fi

export LD_LIBRARY_PATH=/home/kk/lib
cd /home/kk/lib
if [ ! -f "$nanomsg_File" ]; then
	ln -sf /home/kk/lib/libnanomsg.so /lib/libnanomsg.so.5
fi
if [ ! -f "$ev_File" ]; then
	ln -sf /home/kk/lib/libev.so /lib/libev.so.4
fi

if [ ! -f "$sqlite_File" ]; then
	ln -sf /home/kk/lib/libsqlite3.so /lib/libsqlite3.so.0
fi


CCU_ID=`cat /etc/dropbear/accessory/hj/hj_ccuid`
/sbin/logread -f -r 120.55.149.201 514 -p /var/run/logread.cloud_log.pid -u -h $CCU_ID >/dev/null 2>&1 &
/sbin/logread -f -e "ccu_err_info" -F /etc/dropbear/accessory/hj/err.log -p /var/run/logread.err_log.pid -S 512 >/dev/null 2>&1 &
sleep 1

export LD_LIBRARY_PATH=/home/kk/lib
cd ${run_Dir}

/home/kk/kk_midware >/dev/null 2>&1 &
sleep 1
/home/kk/kcloud >/dev/null 2>&1 &
/home/kk/Z3GatewayHost -f x -p /dev/ttyS0 >/dev/null 2>&1 &

/home/kk/process_check.sh >/dev/null 2>&1 &

cd /sbin
/sbin/logd-check.sh >/dev/null 2>&1 &
sleep 1

ntpd -n -q -d -p stdtime.gov.hk &
exit 0