#include "rpc_global_cmd.h"
#include <stdio.h>

/*
void emAfCliSendCommand(uint16_t destination,uint8_t srcEndpoint,uint8_t dstEndpoint)
{
	EmberStatus status;
	
	// check that cmd is built
	if (zclCmdIsBuilt == false) {
		emberAfCorePrintln("no cmd");
		return;
	}

	emAfApsFrameEndpointSetup(srcEndpoint, dstEndpoint);

	status = emberAfSendUnicast(EMBER_OUTGOING_DIRECT,
								destination,
								&globalApsFrame,
								appZclBufferLen,
								appZclBuffer);


	if (status != EMBER_SUCCESS) {
		emberAfCorePrintln("Error: CLI Send failed, status: 0x%X", status);
	}

	emberAfDebugPrintln("T%4x:TX (%p) %ccast 0x%x%p",
						emberAfGetCurrentTime(),
						"CLI",
						label,
						status,
						((globalApsFrame.options & EMBER_APS_OPTION_ENCRYPTION)
						? " w/ link key" : ""));
	emberAfDebugPrint("TX buffer: [");
	emberAfDebugFlush();
	emberAfDebugPrintBuffer(appZclBuffer, appZclBufferLen, true);
	emberAfDebugPrintln("]");
	emberAfDebugFlush();

	zclCmdIsBuilt = false;
	mfgSpecificId = EMBER_AF_NULL_MANUFACTURER_CODE;
	disableDefaultResponse = 0;
	useNextSequence = false;
}*/






EmberStatus zclGRead(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				bool svr)
{
	EmberStatus status;

	zclBufferSetup(ZCL_GLOBAL_COMMAND | ((svr==true)?
											ZCL_FRAME_CONTROL_CLIENT_TO_SERVER
											:ZCL_FRAME_CONTROL_SERVER_TO_CLIENT),
					clusterId,
					ZCL_READ_ATTRIBUTES_COMMAND_ID);
	
	zclBufferAddByte(LOW_BYTE(attrId));
	zclBufferAddByte(HIGH_BYTE(attrId));

	rpcBufferPrint();
	status = rpcSendCommand(node,srcEP,dstEP,multicast);
	return status;
}




cJSON *rpc_zclGRead(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_srcEP;
	cJSON *item_dstEP;
	cJSON *item_multicast;
	cJSON *item_clu;
	cJSON *item_attr;
	cJSON *item_svr;
	EmberStatus status;
	
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_srcEP = cJSON_GetObjectItem(params, "srcEP");
		item_dstEP = cJSON_GetObjectItem(params, "dstEP");
		item_multicast = cJSON_GetObjectItem(params, "multicast");
		item_clu = cJSON_GetObjectItem(params, "clu");
		item_attr = cJSON_GetObjectItem(params, "attr");
		item_svr = cJSON_GetObjectItem(params, "svr");
	}
	if(item_node==NULL ||
		item_srcEP==NULL ||
		item_dstEP==NULL ||
		item_multicast==NULL ||
		item_clu == NULL || 
		item_attr == NULL ||
		item_svr == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_srcEP->type!=cJSON_String ||
		item_dstEP->type!=cJSON_String ||
		item_clu->type!=cJSON_String ||
		item_attr->type!=cJSON_String ||
		(item_multicast->type!=cJSON_True &&
			item_multicast->type!=cJSON_False)||
		(item_svr->type!=cJSON_True &&
			item_svr->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
			
	if(strlen(item_node->valuestring)!=4 ||
		strlen(item_srcEP->valuestring)!=2 ||
		strlen(item_dstEP->valuestring)!=2 ||
		strlen(item_clu->valuestring)!=4 || 
		strlen(item_attr->valuestring)!=4){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("3[%d,%d,%d,%d,%d]\n",strlen(item_node->valuestring),strlen(item_srcEP->valuestring),strlen(item_dstEP->valuestring),strlen(item_clu->valuestring),strlen(item_attr->valuestring));
		goto error_return;
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("srcEP=%s\n",item_srcEP->valuestring);
	kk_print_debug("dstEP=%s\n",item_dstEP->valuestring);
	kk_print_debug("%s multicast\n",(item_multicast->type==cJSON_True)?"":"not ");
	kk_print_debug("clu=%s\n",item_clu->valuestring);
	kk_print_debug("attr=%s\n",item_attr->valuestring);
	kk_print_debug("dir:%s\n",(item_svr->type==cJSON_True)?"client->server":"server->client");

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t srcEP = rpc_get_u8(item_srcEP->valuestring);
	uint8_t dstEP = rpc_get_u8(item_dstEP->valuestring);
	bool multicast = (item_multicast->type==cJSON_True)?true:false;
	uint16_t clu = rpc_get_u16(item_clu->valuestring);
	uint16_t attr = rpc_get_u16(item_attr->valuestring);
	bool svr = (item_svr->type==cJSON_True)?true:false;
	
	kk_print_debug("read clu:0x%04X,attr:0x%04X,type:%s\n",clu,attr,(svr==true)?"client->server":"server->client");
	kk_print_debug("target:0x%04X,srcEP=%d,dstEP=%d,type:%s\n",node,srcEP,dstEP,(multicast==true)?"multicast":"not multicast");
	status = zclGRead(node,srcEP,dstEP,multicast,clu,attr,svr);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send read command suc.");
	}else{
		kk_print_debug("send read command fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);

error_return:
	return rpc_cJSON_CreateNull();		
}




































