#ifndef __NETWORK_OPERATE_H
#define __NETWORK_OPERATE_H
#include "RPC_API.h"

typedef struct{
	EmberNetworkStatus status;
	EmberEUI64 eui64;
	EmberNodeId nodeid;
	EmberPanId panid;
	uint8_t ch;
	EmberKeyStruct nwkKey;
}rpc_nwk_info_s;


EmberStatus nwkLeave(void);
EmberStatus nwkLeaveRequest(EmberNodeId target,bool removeChildren,bool rejoin);

void nwkGetInfo(rpc_nwk_info_s *info);
EmberStatus nwkFormCMD(bool centralized,uint16_t panId,int8_t txPower,uint8_t channel);
void nwkStartCMD(bool centralized);
void nwkaddChMaskCMD(bool channelMaskIsPrimary,uint32_t channelOrNewMask);
void nwksubChMaskCMD(bool channelMaskIsPrimary,uint32_t channelOrNewMask);
void nwksetChMaskCMD(bool channelMaskIsPrimary,uint32_t channelOrNewMask);
void nwkgetChMaskCMD(void);
EmberStatus nwkPermitJoinCMD(bool open);
void nwkPermitJoinWithKeyCMD(EmberEUI64 eui64,EmberKeyData keyData);
void nwkSetJoiningLinkKeyCMD(EmberEUI64 eui64,EmberKeyData keyData);
void nwkClearJoiningLinkKeyCMD(void);




cJSON *rpc_nwkGetInfo(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_nwkFormCMD(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_nwkStar(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_nwkPermitJoin(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_nwkLeave(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_nwkLeaveRequest(jrpc_context * ctx, cJSON * params, cJSON *id);



#define RPC_NETWORK_FUNCTION_TABLE	\
	{(rpc_function*)rpc_nwkLeave,"nwkLeave"},\
	{(rpc_function*)rpc_nwkLeaveRequest,"nwkLeaveRequest"},\
	{(rpc_function*)rpc_nwkGetInfo,"nwkGetInfo"},\
	{(rpc_function*)rpc_nwkFormCMD,"thing.topo.property.set"},\
	{(rpc_function*)rpc_nwkStar,"nwkStar"}\

	

	

















#endif

