#include "kk_sub_tsl.h"


typedef unsigned char EmberEUI64[8];

typedef struct {
    void *mutex;
	int sub_devid;
    struct list_head dev_list;	
} kk_sub_dev_ctx_t;

static kk_sub_dev_ctx_t g_sub_dev_mgr = {0};
static kk_sub_dev_ctx_t * _sub_dev_get_ctx(void)
{
    return &g_sub_dev_mgr;
}
static void *_sub_MutexCreate(void)
{
    int err_num;
    pthread_mutex_t *mutex = (pthread_mutex_t *)malloc(sizeof(pthread_mutex_t));
    if (NULL == mutex) 
	{
        return NULL;
    }

    if (0 != (err_num = pthread_mutex_init(mutex, NULL))) 
	{
        printf("create mutex failed\n");
        free(mutex);
        return NULL;
    }

    return mutex;
}
static void _sub_MutexLock(void *mutex)
{
    int err_num;
    if (0 != (err_num = pthread_mutex_lock((pthread_mutex_t *)mutex))) 
	{
        printf("lock mutex failed: - '%s' (%d)\n", strerror(err_num), err_num);
    }
}

static void _sub_MutexUnLock(void *mutex)
{
    int err_num;
    if (0 != (err_num = pthread_mutex_unlock((pthread_mutex_t *)mutex))) 
	{
        printf("unlock mutex failed - '%s' (%d)\n", strerror(err_num), err_num);
    }
}

static void _sub_MutexDestroy(void *mutex)
{
    int err_num;

    if (!mutex) 
	{
        printf("mutex want to destroy is NULL!\n");
        return;
    }
    if (0 != (err_num = pthread_mutex_destroy((pthread_mutex_t *)mutex))) 
	{
        printf("destroy mutex failed\n");
    }

    free(mutex);
}

static int _sub_tsl_next_devid(void)
{
    kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();

    return ctx->sub_devid++;
}

static void _sub_dev_mutex_lock(void)
{
    kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
    if (ctx->mutex) {
        _sub_MutexLock(ctx->mutex);
    }
}

static void _sub_dev_mutex_unlock(void)
{
    kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
    if (ctx->mutex) {
        _sub_MutexUnLock(ctx->mutex);
    }
}

int kk_tsl_init(void)
{
	int res = 0;
	kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
    ctx->mutex = _sub_MutexCreate();
    if (ctx->mutex == NULL) {
        return FAIL_RETURN;
    }	
    ctx->sub_devid = 1;
    INIT_LIST_HEAD(&ctx->dev_list);	
	//kk_sub_tsl_add("112233445566","a1h88DsZIaY");
	//usleep(1000000);
	//kk_test();
	return SUCCESS_RETURN;
}
int kk_sub_tsl_add(EmberEUI64 device_mac,const char *product_type)
{
    sub_dev_node_t *node = NULL;
	kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
	char name[TSL_PATH_MAXLEN] = {0};
	char *tsl_str = NULL;
	int res = 0;
	char macString[19] = {0};
	if(product_type == NULL)
	{
		return INVALID_PARAMETER;
	}
	
	rpc_eui64ToString(device_mac,macString);

    node = malloc(sizeof(sub_dev_node_t));
    if (node == NULL) {
        return MEMORY_NOT_ENOUGH;
    }

	_sub_dev_mutex_lock();
	memset(node,0,sizeof(sub_dev_node_t) );
	memcpy(node->device_mac, macString, strlen(macString));
	memcpy(node->product_type, product_type, strlen(product_type));	
	node->devid = _sub_tsl_next_devid();

    INIT_LIST_HEAD(&node->linked_list);
    list_add_tail(&node->linked_list, &ctx->dev_list);
	_sub_dev_mutex_unlock();	
	return SUCCESS_RETURN;
}
int kk_sub_tsl_get_device_by_mac(_IN_ char device_mac[DEVICE_MAC_MAXLEN], _OU_ sub_dev_node_t **node)
{
    kk_sub_dev_ctx_t *ctx = _sub_dev_get_ctx();
    sub_dev_node_t *search_node = NULL;
	_sub_dev_mutex_lock();

    list_for_each_entry(search_node, &ctx->dev_list, linked_list, sub_dev_node_t) {
        if ((strlen(search_node->device_mac) == strlen(device_mac)) &&
            (memcmp(search_node->device_mac, device_mac, strlen(device_mac)) == 0)) {
            if (node) {
                *node = search_node;
            }
			_sub_dev_mutex_unlock();
            return SUCCESS_RETURN;
        }
    }
	_sub_dev_mutex_unlock();

    printf("Device Not Found, device_mac: %s\n", device_mac);
    return FAIL_RETURN;
}

const char DM_MSG_REQUEST[] = "{\"LightStatus\":\"1\"}";
int kk_test(void)
{
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	kk_test_fuc("112233445566",DM_MSG_REQUEST);
	//kk_get_Identity_Num(0);

	return 0;
}

