// This file is generated by Simplicity Studio.  Please do not edit manually.
//
//

// Enclosing macro to prevent multiple inclusion
#ifndef SILABS_EMBER_AF_CLI
#define SILABS_EMBER_AF_CLI


/**
 * @addtogroup cli Application Framework V2 CLI Command Reference
 * This header provides cli command function prototypes for the Application
 * Framework's core ZigBee Cluster Library implementation.
 * @{
 */



/** @addtogroup attribute Attribute Management
 * @ingroup cli
 * Commands related to reading and writing attributes locally on a device.
 * 
 * @{
 */

/** @brief <b>read [endpoint:1] [cluster:2] [attribute:2] [mask:1] </b>
 *   - <i>Read an attribute from the local attribute table. The attribute is displayed on the command line.</i>
 *     - endpoint - INT8U - endpoint of the attribute to read
 *     - cluster - INT16U - cluster id of the attribute to read
 *     - attribute - INT16U - attribute id of the attribute to read
 *     - mask - INT8U - direction mask of the attribute to read (client=0 or server=1)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ATTRIBUTE_READ

/** @brief <b>write [endpoint:1] [cluster:2] [attribute:2] [mask:1] [dataType:1] [dataBytes:-1] </b>
 *   - <i>Write an attribute value into the local attribute table</i>
 *     - endpoint - INT8U - endpoint of the attribute to write
 *     - cluster - INT16U - cluster id of the attribute to write
 *     - attribute - INT16U - attribute id of the attribute to write
 *     - mask - INT8U - direction mask of the attribute to write (client=0 or server=1)
 *     - dataType - INT8U - the attribute type as listed in the generated file attribute-type.h
 *     - dataBytes - OCTET_STRING - string of bytes you wish to write into the attribute table.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ATTRIBUTE_WRITE

/** @} */ // end group attribute

/** @addtogroup build-send-msg Building and Sending Messages
 * @ingroup cli
 * Commands for building and sending messages out onto the network.
 * 
 * @{
 */

/** @brief <b>bsend [srcEndpoint:1] </b>
 *   - <i>Send using a binding based on the clusterId in the globalApsFrame and the srcEndpoint specified (if the src endpoint is zero it only sends based on the clusterId)</i>
 *     - srcEndpoint - INT8U - Source endpoint to send a binding based message from
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_BSEND

/** @brief <b>interpan group [groupId:2] [destPan:2] [destprofileID:2] </b>
 *   - <i>send an interpan message to a group id.</i>
 *     - groupId - INT16U - group id to send to
 *     - destPan - INT16U - destination pan id
 *     - destprofileID - INT16U - destination profile ID
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_INTERPAN_GROUP

/** @brief <b>interpan long [longId:8] [destPAN:2] [destProfileID:2] [options:2] </b>
 *   - <i>Send an interpan message to a long address (8 byte eui64)</i>
 *     - longId - IEEE_ADDRESS - long ieee address to send the interpan message to
 *     - destPAN - INT16U - two byte destination PA ID
 *     - destProfileID - INT16U - two byte destination profile ID
 *     - options - INT16U - two byte options
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_INTERPAN_LONG

/** @brief <b>interpan short [shortId:2] [destPan:2] [destprofileID:2] </b>
 *   - <i>Send an interpan message to a short id.</i>
 *     - shortId - INT16U - group id to send to
 *     - destPan - INT16U - destination pan id
 *     - destprofileID - INT16U - destination profile ID
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_INTERPAN_SHORT

/** @brief <b>raw [clusterId:2] [data:-1] </b>
 *   - <i>Creates a message by specifying the raw bytes. Use "send" to send the message once it has been created. Ex: raw 0x000F {00 0A 00 11 22 33 44 55} sends a message to cluster 15 (0x000F) of length 8 which includes the ZCL header.</i>
 *     - clusterId - INT16U - two byte cluster id
 *     - data - OCTET_STRING - ZCL message, including ZCL header and payload
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_RAW

/** @brief <b>send [id:2] [src-endpoint:1] [dst-endpoint:1] </b>
 *   - <i>Send a pre-buffered message from a given endpoint to an endpoint on a device with a given short address.</i>
 *     - id - INT16U - short id of the device to send the message to
 *     - src-endpoint - INT8U - The endpoint to send the message from
 *     - dst-endpoint - INT8U - The endpoint to send the message to
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_SEND

/** @brief <b>send-using-multicast-binding [useMulticastBinding:1] </b>
 *   - <i>When sending using a binding, specify whether a multicast binding should be used.</i>
 *     - useMulticastBinding - BOOLEAN - Whether to send via a multicast binding
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_SEND_USING_MULTICAST_BINDING

/** @brief <b>send_multicast [groupId:2] [src-endpoint:1] </b>
 *   - <i>Send a pre-buffered multicast message to a given group id from a given endpoint.</i>
 *     - groupId - INT16U - group id of the multicast group to send the message to
 *     - src-endpoint - INT8U - The endpoint to send the message from
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_SEND_MULTICAST

/** @brief <b>timesync [id:2] [srcEndpoint:1] [destEndpoint:1] </b>
 *   - <i>This sends a read attr for the time of the device specified. It sets a flag so when it gets the response it writes the time to its own time attr</i>
 *     - id - INT16U - two byte short id of the time server
 *     - srcEndpoint - INT8U - source endpoint to send time sync from
 *     - destEndpoint - INT8U - destination endpoint to expect response on
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BUILD_SEND_MSG_TIMESYNC

/** @} */ // end group build-send-msg

/** @addtogroup endpoint Endpoint Manipulation
 * @ingroup cli
 * Commands related to the manipulation of endpoints.
 * 
 * @{
 */

/** @brief <b>endpoint disable [endpoint:1] </b>
 *   - <i>Disable the endpoint for processing ZCL messages.</i>
 *     - endpoint - INT8U - Endpoint in question.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ENDPOINT_ENDPOINT_DISABLE

/** @brief <b>endpoint enable [endpoint:1] </b>
 *   - <i>Enable the endpoint for processing ZCL messages.</i>
 *     - endpoint - INT8U - Endpoint in question.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ENDPOINT_ENDPOINT_ENABLE

/** @brief <b>endpoint print </b>
 *   - <i>Print the status of all the endpoints.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ENDPOINT_ENDPOINT_PRINT

/** @} */ // end group endpoint

/** @addtogroup general General
 * @ingroup cli
 * General commands that are applicable to the node regardless of clusters or
 * plugins.
 * 
 * @{
 */

/** @brief <b>echo [echoOn:1] </b>
 *   - <i>Turns echo on the command line on or off depending on the argument</i>
 *     - echoOn - INT8U - bool indicating whether to turn echo on (1) or off (0)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GENERAL_ECHO

/** @brief <b>events </b>
 *   - <i>Print the list of timer events.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GENERAL_EVENTS

/** @brief <b>reset </b>
 *   - <i>resets the device</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GENERAL_RESET

/** @brief <b>zcl mfg-code [mfgSpecificId:2] </b>
 *   - <i>Sets the two byte manufacturer specific identifier to use for the next command if the command is not already built.</i>
 *     - mfgSpecificId - INT16U - Manufacturer Specific Id
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GENERAL_ZCL_MFG_CODE

/** @brief <b>zcl time [utcTime:4] </b>
 *   - <i>Cli command to call emberAfSetTime function documented in af.h</i>
 *     - utcTime - INT32U - ZigBee UTC time, number of seconds since the year 2000
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GENERAL_ZCL_TIME

/** @brief <b>zcl use-next-sequence [useNextSequence:1] </b>
 *   - <i>Sets the flag to use the incremented sequence number from the framework for the next raw command.</i>
 *     - useNextSequence - BOOLEAN - bool value indicating whether raw command will use the incremented seq number from framework, set(1) or not(0).
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GENERAL_ZCL_USE_NEXT_SEQUENCE

/** @brief <b>zcl x-default-resp [disableDefaultResponse:1] </b>
 *   - <i>Sets the Disable Default Response Frame Control bit to use for the next command if the command is not already built.</i>
 *     - disableDefaultResponse - BOOLEAN - bool value indicating whether the disable default response bit is set(1) or not (0).
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GENERAL_ZCL_X_DEFAULT_RESP

/** @} */ // end group general

/** @addtogroup zcl-global Global ZCL
 * @ingroup cli
 * All the ZCL global commands defined in the ZigBee Cluster Library
 * Specification. These command line commands can be used to send messages over
 * the air to, for instance, read and write attributes to devices on the
 * network.
 * 
 * @{
 */

/** @brief <b>zcl global direction [direction:1] </b>
 *   - <i>Sets the direction for global commands, either client to server or server to client.</i>
 *     - direction - INT8U - The direction for global commands, 0 = client to server, 1 = server to client.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_DIRECTION

/** @brief <b>zcl global disc-com-gen [clusterId:2] [startCommandId:1] [maxCommandId:1] </b>
 *   - <i>Create a Discover Commands Generated command with associated values.</i>
 *     - clusterId - INT16U - The cluster to find commands on.
 *     - startCommandId - INT8U - The command id to start the command search on.
 *     - maxCommandId - INT8U - Max command ids to search for.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_DISC_COM_GEN

/** @brief <b>zcl global disc-com-rec [clusterId:2] [startCommandId:1] [maxCommandId:1] </b>
 *   - <i>Create a Discover Commands Received command with associated values.</i>
 *     - clusterId - INT16U - The cluster to find commands on.
 *     - startCommandId - INT8U - The command id to start the command search on.
 *     - maxCommandId - INT8U - Max command ids to search for.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_DISC_COM_REC

/** @brief <b>zcl global discover [cluster:2] [attributeId:2] [max:1] </b>
 *   - <i>Creates discovery message for devices with the associated cluster and attribute specified.</i>
 *     - cluster - INT16U - The cluster id of the cluster to discover.
 *     - attributeId - INT16U - The attribute id of the attribute to read during discovery.
 *     - max - INT8U - Max number of discovery responses.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_DISCOVER

/** @brief <b>zcl global expect-report-from-me [cluster:2] [attributeId:2] [timeout:2] </b>
 *   - <i>Create a expect-report-from-me message with associated values.</i>
 *     - cluster - INT16U - The cluster id for the requested report.
 *     - attributeId - INT16U - The attribute id for the requested report.
 *     - timeout - INT16U - Maximum amount of time between reports.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_EXPECT_REPORT_FROM_ME

/** @brief <b>zcl global nwrite [cluster:2] [attributeId:2] [type:1] [data:-1] </b>
 *   - <i>Creates a global write command message to write to the cluster and attribute specified</i>
 *     - cluster - INT16U - The cluster id of the cluster to read from.
 *     - attributeId - INT16U - The attribute id of the attribute to read.
 *     - type - INT8U - The type of the attribute to write.
 *     - data - OCTET_STRING - The data to be written.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_NWRITE

/** @brief <b>zcl global read [cluster:2] [attributeId:2] </b>
 *   - <i>Creates a global read command message to read from the cluster and attribute specified</i>
 *     - cluster - INT16U - The cluster id of the cluster to read from.
 *     - attributeId - INT16U - The attribute id of the attribute to read.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_READ

/** @brief <b>zcl global report [endpoint:1] [clusterId:2] [attributeId:2] [mask:1] </b>
 *   - <i></i>
 *     - endpoint - INT8U - The desired endpoint.
 *     - clusterId - INT16U - The cluster id.
 *     - attributeId - INT16U - The attribute id.
 *     - mask - INT8U - The mask.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_REPORT

/** @brief <b>zcl global report-read [cluster:2] [attributeId:2] [direction:1] </b>
 *   - <i>Creates a global read reporting command for the associated cluster, attribute and server/client direction.</i>
 *     - cluster - INT16U - The cluster id to read from.
 *     - attributeId - INT16U - The attribute id to read from.
 *     - direction - INT8U - 0 for client-to-server, 1 for server-to-client.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_REPORT_READ

/** @brief <b>zcl global send-me-a-report [cluster:2] [attributeId:2] [dataType:1] [minReportTime:2] [maxReportTime:2] [reportableChange:-1] </b>
 *   - <i>Creates a global send me a report command for the associated values.</i>
 *     - cluster - INT16U - The cluster id of the requested report.
 *     - attributeId - INT16U - The attribute id for requested report.
 *     - dataType - INT8U - The two byte ZigBee type value for the requested report.
 *     - minReportTime - INT16U - Minimum number of seconds between reports.
 *     - maxReportTime - INT16U - Maximum number of seconds between reports.
 *     - reportableChange - OCTET_STRING - Amount of change to trigger a report.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_SEND_ME_A_REPORT

/** @brief <b>zcl global uwrite [cluster:2] [attributeId:2] [type:1] [data:-1] </b>
 *   - <i>Creates a global write undivided command message to write to the cluster and attribute specified</i>
 *     - cluster - INT16U - The cluster id of the cluster to write to.
 *     - attributeId - INT16U - The attribute id of the attribute to write.
 *     - type - INT8U - The type of the attribute to write.
 *     - data - OCTET_STRING - The data to be written.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_UWRITE

/** @brief <b>zcl global write [cluster:2] [attributeId:2] [type:4] [data:-1] </b>
 *   - <i>Creates a global write command message to write to the cluster and attribute specified</i>
 *     - cluster - INT16U - The cluster id of the cluster to write to.
 *     - attributeId - INT16U - The attribute id of the attribute to write.
 *     - type - INT32U - The type of the attribute to write.
 *     - data - OCTET_STRING - The data to be written.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZCL_GLOBAL_ZCL_GLOBAL_WRITE

/** @} */ // end group zcl-global

/** @addtogroup info Informational
 * @ingroup cli
 * The Informational command set provides commands for displaying information
 * about the device. These commands include things like printing out the
 * attribute tablerr
 * 
 * @{
 */

/** @brief <b>debugprint all_off </b>
 *   - <i>Turns off all debug printing</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_DEBUGPRINT_ALL_OFF

/** @brief <b>debugprint all_on </b>
 *   - <i>Turns on all compiled in debug printing</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_DEBUGPRINT_ALL_ON

/** @brief <b>debugprint off [area:1] </b>
 *   - <i>Turns off compiled in debug printing for a specific debug printing area. Debug print areas are defined in the generated <application>.h header file.</i>
 *     - area - INT8U - The debug area mask listed in the <application>.h file
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_DEBUGPRINT_OFF

/** @brief <b>debugprint on [area:1] </b>
 *   - <i>Turns on compiled in debug printing for a specific debug printing area. Debug print areas are defined in the generated <application>.h header file.</i>
 *     - area - INT8U - The debug area mask listed in the <application>.h file
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_DEBUGPRINT_ON

/** @brief <b>debugprint status </b>
 *   - <i>Prints out the current settings for debug printing on the device</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_DEBUGPRINT_STATUS

/** @brief <b>help </b>
 *   - <i>Prints out the cli command options for the device</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_HELP

/** @brief <b>info </b>
 *   - <i>Gives information about the local node</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_INFO

/** @brief <b>libs </b>
 *   - <i>Lists which optional libraries of the stack are implemented on this device</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_LIBS

/** @brief <b>option binding-table print </b>
 *   - <i>Prints out the binding table to the command line.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_OPTION_BINDING_TABLE_PRINT

/** @brief <b>option print-rx-msgs disable </b>
 *   - <i>Disable the printing of received messages.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_OPTION_PRINT_RX_MSGS_DISABLE

/** @brief <b>option print-rx-msgs enable </b>
 *   - <i>Enable the printing of received messages.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_OPTION_PRINT_RX_MSGS_ENABLE

/** @brief <b>print attr </b>
 *   - <i>Print the attribute table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_PRINT_ATTR

/** @brief <b>print time </b>
 *   - <i>Print out the time information</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_PRINT_TIME

/** @brief <b>version </b>
 *   - <i>Shows the version of the software</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_INFO_VERSION

/** @} */ // end group info

/** @addtogroup network Network
 * @ingroup cli
 * The Network command set provides commands for interacting with the network.
 * This includes building as well as sending ZigBee commands out on to the
 * network.
 * 
 * @{
 */

/** @brief <b>network broad-pjoin [seconds:1] </b>
 *   - <i>Permit joining on the network for a given number of seconds AND broadcast a ZDO Mgmt Permit Joining request to all routers.</i>
 *     - seconds - INT8U - Number of seconds during which devices will be allowed to join the network. A value of 0xff turns permit joining on permanently
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_BROAD_PJOIN

/** @brief <b>network change-channel [channel:1] </b>
 *   - <i>Attempts to change device over to a different channel given in the channel argument.</i>
 *     - channel - INT8U - The channel to change to.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_CHANGE_CHANNEL

/** @brief <b>network extpanid [extPanId:-1] </b>
 *   - <i>Write the extended pan id for the device.</i>
 *     - extPanId - OCTET_STRING - The bytes for the extended pan id
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_EXTPANID

/** @brief <b>network find joinable </b>
 *   - <i>Begin a search for a joinable network. Will automatically attempt to join the first network that it finds.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_FIND_JOINABLE

/** @brief <b>network find unused </b>
 *   - <i>Begin a search for an unused Channel and Pan Id. Will automatically form a network on the first unused Channel and Pan Id it finds.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_FIND_UNUSED

/** @brief <b>network form [channel:1] [power:1] [panId:2] </b>
 *   - <i>Create a network on the given channel, power and panId.</i>
 *     - channel - INT8U - The channel on which to form the network
 *     - power - INT8S - One byte signed value indicating the TX power that the radio should be set to
 *     - panId - INT16U - Two byte pan id for the network
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_FORM

/** @brief <b>network id </b>
 *   - <i>Prints the current Node ID, EUI64, and Pan ID.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_ID

/** @brief <b>network init </b>
 *   - <i>Initialize a network; this is a test command used for tc-swap-out testing.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_INIT

/** @brief <b>network join [channel:1] [power:1] [panId:2] </b>
 *   - <i>Join an existing network on the given channel, power and panId.</i>
 *     - channel - INT8U - The channel on which to form the network
 *     - power - INT8S - One byte signed value indicating the TX power that the radio should be set to
 *     - panId - INT16U - Two byte pan id for the network
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_JOIN

/** @brief <b>network leave </b>
 *   - <i>Leave the current network.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_LEAVE

/** @brief <b>network multi-phy-start [page:1] [channel:1] [power:1] </b>
 *   - <i>To start multi phy interface other than native and form the network. The stack uses same PanId as native radio network.</i>
 *     - page - INT8U - The page on which to form the network.
 *     - channel - INT8U - The channel on which to form the network.
 *     - power - INT8S - One byte signed value indicating the TX power that the radio should be set to
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_MULTI_PHY_START

/** @brief <b>network multi-phy-stop </b>
 *   - <i>Terminates the multi phy interface</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_MULTI_PHY_STOP

/** @brief <b>network pjoin [seconds:1] </b>
 *   - <i>Permit joining on the network for a given number of seconds</i>
 *     - seconds - INT8U - Number of seconds during which devices will be allowed to join the network. A value of 0xff turns permit joining on permanently
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_PJOIN

/** @brief <b>network rejoin [haveCurrentNetworkKey:1] [channelMask:4] </b>
 *   - <i>Rejoin an existing network in a secure or insecure manner.</i>
 *     - haveCurrentNetworkKey - INT8U - Boolean indicating whether the device can rejoin secure or not. 1=rejoin with encryption, 0=rejoin without encryption
 *     - channelMask - INT32U - 4 byte channel mask which should be used to search for the network to rejoin.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_REJOIN

/** @brief <b>network rejoin-diff-device-type [haveCurrentNetworkKey:1] [channelMask:4] [nodeType:1] </b>
 *   - <i>Rejoin an existing network in a secure or insecure manner with a different device type.</i>
 *     - haveCurrentNetworkKey - INT8U - Boolean indicating whether the device can rejoin secure or not. 1=rejoin with encryption, 0=rejoin without encryption
 *     - channelMask - INT32U - 4 byte channel mask which should be used to search for the network to rejoin.
 *     - nodeType - INT8U - An enumeration indicating the device type to rejoin as.The stack only accepts EMBER_END_DEVICE and EMBER_SLEEPY_END_DEVICE.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_REJOIN_DIFF_DEVICE_TYPE

/** @brief <b>network set [networkIndex:1] </b>
 *   - <i>Set the network index used by all future CLI commands.  Before executing a CLI command, the framework will switch to this network.  After the command finishes executing, the framework will switch back to the previous network.  The CLI uses the same network index until the device resets or it is changed through this command.</i>
 *     - networkIndex - INT8U - The network index to use for CLI commands
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_NETWORK_SET

/** @brief <b>option apsretry default </b>
 *   - <i>Forces the AppFramework to set/clear the APS Retry option (in APS Frame options mask) for all subsequent outgoing messages; a value of "default" allows the AppFramework to use its own default logic to determine when the APS Retry option should be used.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_OPTION_APSRETRY_DEFAULT

/** @brief <b>option apsretry off </b>
 *   - <i>Forces the AppFramework to set/clear the APS Retry option (in APS Frame options mask) for all subsequent outgoing messages; Turns APS retry off</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_OPTION_APSRETRY_OFF

/** @brief <b>option apsretry on </b>
 *   - <i>Forces the AppFramework to set/clear the APS Retry option (in APS Frame options mask) for all subsequent outgoing messages; Turns APS retry on.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_OPTION_APSRETRY_ON

/** @brief <b>option binding-table clear </b>
 *   - <i>Clear the binding table</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_OPTION_BINDING_TABLE_CLEAR

/** @brief <b>option binding-table set [bindingTableIndex:1] [clusterId:2] [localEndpoint:1] [remoteEndpoint:1] [ieeeAddress:8] </b>
 *   - <i>Set a binding table entry for the arguments specified.</i>
 *     - bindingTableIndex - INT8U - one byte index into the binding table
 *     - clusterId - INT16U - cluster id to send with the discovery message
 *     - localEndpoint - INT8U - local endpoint to bind
 *     - remoteEndpoint - INT8U - remote endpoint to bind
 *     - ieeeAddress - IEEE_ADDRESS - 8 byte IEEE address provided big endian
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_OPTION_BINDING_TABLE_SET

/** @brief <b>option disc [profileId:2] [clusterId:2] </b>
 *   - <i>Sends a ZDO Match Descriptor Request for the server side of the specified cluster from the specified application profile. Match Descriptor Responses received are printed to the serial output.</i>
 *     - profileId - INT16U - the profile id to send with the discovery message
 *     - clusterId - INT16U - cluster id to send with the discovery message
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_OPTION_DISC

/** @brief <b>option edb [endpoint:1] </b>
 *   - <i>Sends a ZDO End Device Bind Request using the given local endpoint.</i>
 *     - endpoint - INT8U - The local endpoint whose simple descriptor will be used to create the request
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_NETWORK_OPTION_EDB

/** @} */ // end group network

/** @addtogroup security Security
 * @ingroup cli
 * The Security command set includes all of the commands related to security
 * configuration on the device.
 * 
 * @{
 */

/** @brief <b>changekey link [key:-1] </b>
 *   - <i>Change the link key to the one provided in the 16 byte array argument for this command.</i>
 *     - key - OCTET_STRING - The link key provided as a 16 byte array
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_CHANGEKEY_LINK

/** @brief <b>changekey network [key:-1] </b>
 *   - <i>Change the network key to the 16 byte array provided as an argument to this command.</i>
 *     - key - OCTET_STRING - The network key provided as a 16 byte array
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_CHANGEKEY_NETWORK

/** @brief <b>keys clear </b>
 *   - <i>Clear all security keys</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_KEYS_CLEAR

/** @brief <b>keys delete [index:1] </b>
 *   - <i>Delete a security key from a given index</i>
 *     - index - INT8U - index into the security key table
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_KEYS_DELETE

/** @brief <b>keys print </b>
 *   - <i>Print all security keys out to the command line.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_KEYS_PRINT

/** @brief <b>option install-code [keyTableIndex:1] [ieeeAddress:8] [installCode:-1] </b>
 *   - <i>Derives a link key from an install code and sets it in the link key table.</i>
 *     - keyTableIndex - INT8U - index into the link key table
 *     - ieeeAddress - IEEE_ADDRESS - IEEE address to enter into the link key table
 *     - installCode - OCTET_STRING - install code including two-byte, little-endian CRC
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_OPTION_INSTALL_CODE

/** @brief <b>option link [keyTableIndex:1] [ieeeAddress:8] [linkKey:-1] </b>
 *   - <i>Sets a link key in the link key table. Example: option link 0x00 { 06 00 ab 41 64 30 00 0a } {aa bb cc dd ee ff aa bb cc dd ee ff aa bb cc dd}</i>
 *     - keyTableIndex - INT8U - index into the link key table
 *     - ieeeAddress - IEEE_ADDRESS - IEEE address to enter into the link key table
 *     - linkKey - OCTET_STRING - link key to enter into the table
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_OPTION_LINK

/** @brief <b>option register </b>
 *   - <i>Initiates Smart Energy Registration including Key Establishment. This command expects that the device has already joined a smart energy network.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_OPTION_REGISTER

/** @brief <b>option security aps off </b>
 *   - <i>Turns aps security off</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_OPTION_SECURITY_APS_OFF

/** @brief <b>option security aps on </b>
 *   - <i>Turns aps security on</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_OPTION_SECURITY_APS_ON

/** @brief <b>option security set-allow-trust-center-rejoin-using-well-known-key [allowTrustCenterRejoinUsingWellKnownKey:1] </b>
 *   - <i>Set whether or not a Trust Center application will allow trust center rejoins for devices using the well-known key.</i>
 *     - allowTrustCenterRejoinUsingWellKnownKey - BOOLEAN - Whether or not the Trust Center should allow trust center rejoins for devices using the well-known key.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_OPTION_SECURITY_SET_ALLOW_TRUST_CENTER_REJOIN_USING_WELL_KNOWN_KEY

/** @brief <b>option security set-allow-trust-center-rejoin-using-well-known-key-timeout [trustCenterRejoinUsingWellKnownKeyTimeout:2] </b>
 *   - <i>Sets the number of seconds to allow trust center rejoins for devices using the well-known key. A value of 0 means the policy should not be changed after a timeout. This must be called prior to forming or joining a network.</i>
 *     - trustCenterRejoinUsingWellKnownKeyTimeout - INT16U - The number of seconds that trust center rejoins will be responded to using the well-known link key.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_OPTION_SECURITY_SET_ALLOW_TRUST_CENTER_REJOIN_USING_WELL_KNOWN_KEY_TIMEOUT

/** @brief <b>security mfg-token get </b>
 *   - <i></i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_SECURITY_MFG_TOKEN_GET

/** @brief <b>security mfg-token set [magicNumber:4] [value:2] </b>
 *   - <i></i>
 *     - magicNumber - INT32U
 *     - value - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SECURITY_SECURITY_MFG_TOKEN_SET

/** @} */ // end group security

/** @addtogroup test Test Harness
 * @ingroup cli
 * All commands related to the testing of a device.
 * 
 * @{
 */

/** @brief <b>zcl test response off </b>
 *   - <i>Sets a flag so that the application framework WILL NOT respond to the next ZCL message that comes in over the air.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_TEST_ZCL_TEST_RESPONSE_OFF

/** @brief <b>zcl test response on </b>
 *   - <i>Sets a flag so that the application framework WILL respond to the next ZCL message that comes in over the air.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_TEST_ZCL_TEST_RESPONSE_ON

/** @} */ // end group test

/** @addtogroup zdo ZigBee Device Object Commands (ZDO)
 * @ingroup cli
 * Commands related to the management of a ZigBee device including device
 * discovery and commissioning.
 * 
 * @{
 */

/** @brief <b>zdo active [nodeId:2] </b>
 *   - <i>Send an active endpoint request to the device with the given short id.</i>
 *     - nodeId - INT16U - Two byte short id, destination for the active endpoint request
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_ACTIVE

/** @brief <b>zdo bind [destination:2] [source Endpoint:1] [destEndpoint:1] [cluster:2] [remoteEUI64:8] [destEUI64:8] </b>
 *   - <i>Send a ZDO Bind command to a device specified in the command arguments.</i>
 *     - destination - INT16U - Two byte destination node id
 *     - source Endpoint - INT8U - Remote device's source endpoint to bind
 *     - destEndpoint - INT8U - Remote endpoint to bind
 *     - cluster - INT16U - Cluster on which to bind
 *     - remoteEUI64 - IEEE_ADDRESS - Remote node EUI64
 *     - destEUI64 - IEEE_ADDRESS - Binding's dest EUI64.  Usually the local node's EUI64
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_BIND

/** @brief <b>zdo ieee [nodeId:2] </b>
 *   - <i>Request an ieee address based on a given node id.</i>
 *     - nodeId - INT16U - Short address of the device for which a long address is requested
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_IEEE

/** @brief <b>zdo in-cl-list add [clusterId:2] </b>
 *   - <i>Add clusters to the known server (in) clusters on this device.</i>
 *     - clusterId - INT16U - Server cluster id
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_IN_CL_LIST_ADD

/** @brief <b>zdo in-cl-list clear </b>
 *   - <i>Clear the ZDO list of server (in) clusters.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_IN_CL_LIST_CLEAR

/** @brief <b>zdo leave [target:2] [removeChildren:1] [rejoin:1] </b>
 *   - <i>Send a ZDO Management Leave command to the target device.</i>
 *     - target - INT16U - Target node ID
 *     - removeChildren - BOOLEAN - Remove children
 *     - rejoin - BOOLEAN - Rejoin after leave
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_LEAVE

/** @brief <b>zdo match [nodeId:2] [profile:2] </b>
 *   - <i>Sends a matchDescriptorsRequest to the given destination with the given profile.</i>
 *     - nodeId - INT16U - Two byte node id indicating wher
 *     - profile - INT16U - Two byte profile id for the match descriptor request
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_MATCH

/** @brief <b>zdo mgmt-bind [target:2] [startIndex:1] </b>
 *   - <i>Send a ZDO MGMT-Bind (Binding Table) Request to the target device.</i>
 *     - target - INT16U - Target node ID
 *     - startIndex - INT8U - Starting index into table query
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_MGMT_BIND

/** @brief <b>zdo mgmt-lqi [target:2] [startIndex:1] </b>
 *   - <i>Send a ZDO MGMT-LQI (LQI Table) Request to the target device.</i>
 *     - target - INT16U - Target node ID
 *     - startIndex - INT8U - Starting index into table query
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_MGMT_LQI

/** @brief <b>zdo node [target:2] </b>
 *   - <i>Sends a node descriptor request to a given target device</i>
 *     - target - INT16U - Two byte address for the target device.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_NODE

/** @brief <b>zdo nwk [ieee:8] </b>
 *   - <i>Sends a network address request for the given IEEE address.</i>
 *     - ieee - IEEE_ADDRESS - IEEE address for which a short address is being requested
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_NWK

/** @brief <b>zdo nwk-upd chan [channel:1] </b>
 *   - <i>Sends an update channel request.</i>
 *     - channel - INT8U - One byte channel to change to.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_NWK_UPD_CHAN

/** @brief <b>zdo nwk-upd chanPg [channel:1] [page:1] </b>
 *   - <i>Sends an update channel page request. The stack shall send network enhanced update request if page is non-zero.</i>
 *     - channel - INT8U - One byte channel to change to.
 *     - page - INT8U - One byte page to change to.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_NWK_UPD_CHAN_PG

/** @brief <b>zdo nwk-upd scan [targetNodeId:2] [scanDuration:1] [scanCount:2] </b>
 *   - <i>Performs an energy scan.</i>
 *     - targetNodeId - INT16U - Two byte short id of the target device
 *     - scanDuration - INT8U - One byte scan duration. Must be in range 0 - 5
 *     - scanCount - INT16U - Number of scans to perform. Must be in range 1 - 8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_NWK_UPD_SCAN

/** @brief <b>zdo nwk-upd scan-chan-mask [targetNodeId:2] [scanDuration:1] [scanCount:2] [channelMask:4] </b>
 *   - <i>Performs an energy scan on given channel mask. This can be used to perform scanning with page number embedded in channel mask, it mainly used for subghz network. The stack shall send network enhanced update request if page is non-zero.</i>
 *     - targetNodeId - INT16U - Two byte short id of the target device
 *     - scanDuration - INT8U - One byte scan duration. Must be in range 0 - 5
 *     - scanCount - INT16U - Number of scans to perform. Must be in range 1 - 8
 *     - channelMask - INT32U - Four byte channel mask
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_NWK_UPD_SCAN_CHAN_MASK

/** @brief <b>zdo nwk-upd set [nwkMgrId:2] [channelMask:4] </b>
 *   - <i>Broadcasts the ID of the new network manager and active channels.</i>
 *     - nwkMgrId - INT16U - Two byte network manager id
 *     - channelMask - INT32U - Four byte channel mask
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_NWK_UPD_SET

/** @brief <b>zdo out-cl-list add [clusterId:2] </b>
 *   - <i>Add clusters to the known client (out) clusters on this device.</i>
 *     - clusterId - INT16U - Client cluster ids
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_OUT_CL_LIST_ADD

/** @brief <b>zdo out-cl-list clear </b>
 *   - <i>Clear the ZDO list of client (out) clusters.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_OUT_CL_LIST_CLEAR

/** @brief <b>zdo power [target:2] </b>
 *   - <i>Send a ZDO Power Descriptor Request to the target device.</i>
 *     - target - INT16U - Target node ID
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_POWER

/** @brief <b>zdo route [target:2] [index:1] </b>
 *   - <i>Send a ZDO route request command to the target.</i>
 *     - target - INT16U - Target node ID
 *     - index - INT8U - The index of the remote node's routing table to request.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_ROUTE

/** @brief <b>zdo simple [dest:2] [targetEndpoint:1] </b>
 *   - <i>Sends out a simple descriptor request for the short address and endpoint specified.</i>
 *     - dest - INT16U - Short address of the device where the simple descriptor request should be sent
 *     - targetEndpoint - INT8U - The endpoint on the target device where the simple descriptor request will be sent
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_SIMPLE

/** @brief <b>zdo unbind group [target:2] [source eui64:8] [source endpoint:1] [clusterID:2] [groupAddress:2] </b>
 *   - <i>Sends an unbind request for a multicast binding to the target device.</i>
 *     - target - INT16U - Target node ID
 *     - source eui64 - IEEE_ADDRESS - The source EUI64 of the binding (the remote device's EUI64)
 *     - source endpoint - INT8U - The source endpoint of the binding.
 *     - clusterID - INT16U - The cluster ID to unbind.
 *     - groupAddress - INT16U - The group address in the binding
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_UNBIND_GROUP

/** @brief <b>zdo unbind unicast [target:2] [source eui64:8] [source endpoint:1] [clusterID:2] [destinationEUI64:8] [destEndpoint:1] </b>
 *   - <i>Sends an unbind request for a unicast binding to the target device.</i>
 *     - target - INT16U - Target node ID
 *     - source eui64 - IEEE_ADDRESS - The source EUI64 of the binding (the remote device's EUI64)
 *     - source endpoint - INT8U - The source endpoint of the binding.
 *     - clusterID - INT16U - The cluster ID to unbind.
 *     - destinationEUI64 - IEEE_ADDRESS - The destination EUI64 in the binding (usually the local node's EUI64
 *     - destEndpoint - INT8U - The destination endpoint of the binding
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ZDO_ZDO_UNBIND_UNICAST

/** @} */ // end group zdo

/** @addtogroup basic Cluster Commands: Basic
 * @ingroup cli
 * This group describes the CLI commands for the Basic cluster. Listed below is
 * a description of the cluster:<br><br><i> Attributes for determining basic
 * information about a device, setting user device information such as location,
 * and enabling a device.</i>
 * 
 * @{
 */

/** @} */ // end group basic

/** @addtogroup color-control Cluster Commands: Color Control
 * @ingroup cli
 * This group describes the CLI commands for the Color Control cluster. Listed
 * below is a description of the cluster:<br><br><i> Attributes and commands for
 * controlling the color properties of a color-capable light.</i>
 * 
 * @{
 */

/** @} */ // end group color-control

/** @addtogroup configuration-cluster Cluster Commands: Configuration Cluster
 * @ingroup cli
 * This group describes the CLI commands for the Configuration Cluster cluster.
 * Listed below is a description of the cluster:<br><br><i> This cluster allows
 * for the OTA configuration of firmware
	  parameters.</i>
 * 
 * @{
 */

/** @} */ // end group configuration-cluster

/** @addtogroup groups Cluster Commands: Groups
 * @ingroup cli
 * This group describes the CLI commands for the Groups cluster. Listed below is
 * a description of the cluster:<br><br><i> Attributes and commands for group
 * configuration and manipulation.</i>
 * 
 * @{
 */

/** @} */ // end group groups

/** @addtogroup ias-zone Cluster Commands: IAS Zone
 * @ingroup cli
 * This group describes the CLI commands for the IAS Zone cluster. Listed below
 * is a description of the cluster:<br><br><i> Attributes and commands for IAS
 * security zone devices.</i>
 * 
 * @{
 */

/** @} */ // end group ias-zone

/** @addtogroup identify Cluster Commands: Identify
 * @ingroup cli
 * This group describes the CLI commands for the Identify cluster. Listed below
 * is a description of the cluster:<br><br><i> Attributes and commands for
 * putting a device into Identification mode (e.g. flashing a light).</i>
 * 
 * @{
 */

/** @brief <b>zcl identify off [endpoint:1] </b>
 *   - <i>Writes the IdentifyTime attribute</i>
 *     - endpoint - INT8U - The endpoint on which to stop identifying
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_IDENTIFY_ZCL_IDENTIFY_OFF

/** @brief <b>zcl identify on [endpoint:1] [time:2] </b>
 *   - <i>Writes the IdentifyTime attribute</i>
 *     - endpoint - INT8U - The endpoint on the device which should begin identifying
 *     - time - INT16U - The number of seconds to spend identifying
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_IDENTIFY_ZCL_IDENTIFY_ON

/** @} */ // end group identify

/** @addtogroup level-control Cluster Commands: Level Control
 * @ingroup cli
 * This group describes the CLI commands for the Level Control cluster. Listed
 * below is a description of the cluster:<br><br><i> Attributes and commands for
 * controlling devices that can be set to a level between fully 'On' and fully
 * 'Off.'</i>
 * 
 * @{
 */

/** @} */ // end group level-control

/** @addtogroup mfglib-cluster Cluster Commands: MFGLIB Cluster
 * @ingroup cli
 * This group describes the CLI commands for the MFGLIB Cluster cluster. Listed
 * below is a description of the cluster:<br><br><i> This cluster provides
 * commands to kick off MFGLIB actions 
	  over the air.</i>
 * 
 * @{
 */

/** @} */ // end group mfglib-cluster

/** @addtogroup on-off Cluster Commands: On/off
 * @ingroup cli
 * This group describes the CLI commands for the On/off cluster. Listed below is
 * a description of the cluster:<br><br><i> Attributes and commands for
 * switching devices between 'On' and 'Off' states.</i>
 * 
 * @{
 */

/** @} */ // end group on-off

/** @addtogroup poll-control Cluster Commands: Poll Control
 * @ingroup cli
 * This group describes the CLI commands for the Poll Control cluster. Listed
 * below is a description of the cluster:<br><br><i> This cluster provides a
 * mechanism for the management of an end device's MAC Data Poll rate.  For the
 * purposes of this cluster, the term "poll" always refers to the sending of a
 * MAC Data Poll from the end device to the end device's parent.</i>
 * 
 * @{
 */

/** @} */ // end group poll-control

/** @addtogroup scenes Cluster Commands: Scenes
 * @ingroup cli
 * This group describes the CLI commands for the Scenes cluster. Listed below is
 * a description of the cluster:<br><br><i> Attributes and commands for scene
 * configuration and manipulation.</i>
 * 
 * @{
 */

/** @} */ // end group scenes

/** @addtogroup simple-metering Cluster Commands: Simple Metering
 * @ingroup cli
 * This group describes the CLI commands for the Simple Metering cluster. Listed
 * below is a description of the cluster:<br><br><i> The Metering Cluster
 * provides a mechanism to retrieve usage information from Electric, Gas, Water,
 * and potentially Thermal metering devices.</i>
 * 
 * @{
 */

/** @} */ // end group simple-metering

/** @addtogroup plugin-address-table Plugin Commands: Address Table
 * @ingroup cli
 * This plugin provides a set of APIs and CLI commands for managing the address
 * table
 * 
 * @{
 */

/** @brief <b>plugin address-table add [entry:8] </b>
 *   - <i>Add an entry to the address table.</i>
 *     - entry - IEEE_ADDRESS - Entry to be added.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_ADDRESS_TABLE_PLUGIN_ADDRESS_TABLE_ADD

/** @brief <b>plugin address-table lookup [entry:8] </b>
 *   - <i>Lookup an entry in the address table.</i>
 *     - entry - IEEE_ADDRESS - Entry to be looked up.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_ADDRESS_TABLE_PLUGIN_ADDRESS_TABLE_LOOKUP

/** @brief <b>plugin address-table print </b>
 *   - <i>Prints the address table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_ADDRESS_TABLE_PLUGIN_ADDRESS_TABLE_PRINT

/** @brief <b>plugin address-table remove [entry:8] </b>
 *   - <i>Remove an entry from the address table.</i>
 *     - entry - IEEE_ADDRESS - Entry to be removed.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_ADDRESS_TABLE_PLUGIN_ADDRESS_TABLE_REMOVE

/** @brief <b>plugin address-table set [index:1] [eui64:8] [nodeId:2] </b>
 *   - <i>Set an entry in the address table according to the arguments specified</i>
 *     - index - INT8U
 *     - eui64 - IEEE_ADDRESS
 *     - nodeId - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_ADDRESS_TABLE_PLUGIN_ADDRESS_TABLE_SET

/** @} */ // end group plugin-address-table

/** @addtogroup plugin-button-joining Plugin Commands: Button Joining
 * @ingroup cli
 * The Button Joining plugin contributes CLI commands to simulate button presses
 * for the purposes of joining networks.
 * 
 * @{
 */

/** @brief <b>plugin button-joining button0 </b>
 *   - <i>Simulate a depression of button 0.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_BUTTON_JOINING_PLUGIN_BUTTON_JOINING_BUTTON0

/** @brief <b>plugin button-joining button1 </b>
 *   - <i>Simulate a depression of button 1.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_BUTTON_JOINING_PLUGIN_BUTTON_JOINING_BUTTON1

/** @} */ // end group plugin-button-joining

/** @addtogroup plugin-command-relay Plugin Commands: Command Relay
 * @ingroup cli
 * The command relay plugin allows the forwarding of commands from one device to
 * another.
 * 
 * @{
 */

/** @brief <b>plugin command-relay add [inDeviceEui:8] [inDeviceEndpoint:1] [inClusterId:2] [outDeviceEui:8] [outDeviceEndpoint:1] [outClusterId:2] </b>
 *   - <i>Retransmit commands from inDevice to outDevice.</i>
 *     - inDeviceEui - IEEE_ADDRESS - Incoming device EUI64.
 *     - inDeviceEndpoint - INT8U - Incoming device endpoint.
 *     - inClusterId - INT16U - Incoming cluster ID.
 *     - outDeviceEui - IEEE_ADDRESS - Outgoing device EUI64.
 *     - outDeviceEndpoint - INT8U - Outgoing device endpoint.
 *     - outClusterId - INT16U - Outgoing cluster ID.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COMMAND_RELAY_PLUGIN_COMMAND_RELAY_ADD

/** @brief <b>plugin command-relay clear </b>
 *   - <i>Clear all relays.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COMMAND_RELAY_PLUGIN_COMMAND_RELAY_CLEAR

/** @brief <b>plugin command-relay load </b>
 *   - <i>Load from disk.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COMMAND_RELAY_PLUGIN_COMMAND_RELAY_LOAD

/** @brief <b>plugin command-relay print </b>
 *   - <i>Print relays.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COMMAND_RELAY_PLUGIN_COMMAND_RELAY_PRINT

/** @brief <b>plugin command-relay remove [inDeviceEui:8] [inDeviceEndpoint:1] [inClusterId:2] [outDeviceEui:8] [outDeviceEndpoint:1] [outClusterId:2] </b>
 *   - <i>Deletes a relay between devices.</i>
 *     - inDeviceEui - IEEE_ADDRESS - Incoming device EUI64.
 *     - inDeviceEndpoint - INT8U - Incoming device endpoint.
 *     - inClusterId - INT16U - Incoming cluster ID.
 *     - outDeviceEui - IEEE_ADDRESS - Outgoing device EUI64.
 *     - outDeviceEndpoint - INT8U - Outgoing device endpoint.
 *     - outClusterId - INT16U - Outgoing cluster ID.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COMMAND_RELAY_PLUGIN_COMMAND_RELAY_REMOVE

/** @brief <b>plugin command-relay save </b>
 *   - <i>Save to disk.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COMMAND_RELAY_PLUGIN_COMMAND_RELAY_SAVE

/** @} */ // end group plugin-command-relay

/** @addtogroup plugin-concentrator Plugin Commands: Concentrator
 * @ingroup cli
 * The Concentrator plugin contributes several CLI commands to the application
 * framework for controlling the sending of MTORRs.
 * 
 * @{
 */

/** @brief <b>plugin concentrator agg </b>
 *   - <i>(Requires Concentrator Support to be enabled on this device.) Schedules a ZigBee PRO Many To One Route Request (MTORR) to be sent out at next opportunity, which will cause aggregation (many-to-one) routes to be created towards this concentrator.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_CONCENTRATOR_PLUGIN_CONCENTRATOR_AGG

/** @brief <b>plugin concentrator print-host-table </b>
 *   - <i>Print the host source route table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_CONCENTRATOR_PLUGIN_CONCENTRATOR_PRINT_HOST_TABLE

/** @brief <b>plugin concentrator print-table </b>
 *   - <i>Print the SOC/NCP source route table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_CONCENTRATOR_PLUGIN_CONCENTRATOR_PRINT_TABLE

/** @brief <b>plugin concentrator set-router-behavior [behavior:1] </b>
 *   - <i>This command allows the user to set the router behavior for this plugin. The argument values come from concentrator-support.h in the enum with members starting with EMBER_AF_PLUGIN_CONCENTRATOR_ROUTER_BEHAVIOR_.</i>
 *     - behavior - INT8U - The value of a EMBER_AF_PLUGIN_CONCENTRATOR_ROUTER_BEHAVIOR_ enum member.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_CONCENTRATOR_PLUGIN_CONCENTRATOR_SET_ROUTER_BEHAVIOR

/** @brief <b>plugin concentrator start </b>
 *   - <i>Starts the periodic broadcast of MTORRs</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_CONCENTRATOR_PLUGIN_CONCENTRATOR_START

/** @brief <b>plugin concentrator status </b>
 *   - <i>Prints current status and configured parameters of the concentrator</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_CONCENTRATOR_PLUGIN_CONCENTRATOR_STATUS

/** @brief <b>plugin concentrator stop </b>
 *   - <i>Stops the periodic broadcast of MTORRs</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_CONCENTRATOR_PLUGIN_CONCENTRATOR_STOP

/** @} */ // end group plugin-concentrator

/** @addtogroup plugin-counters Plugin Commands: Counters
 * @ingroup cli
 * This plugin provides APIs and CLI commands for reading and manipulating
 * counters that record different events in the stack.
 * 
 * @{
 */

/** @brief <b>plugin counter print-counter-type [type:1] </b>
 *   - <i>Print value of this particular counter.</i>
 *     - type - INT8U - The counter type       to print.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COUNTERS_PLUGIN_COUNTER_PRINT_COUNTER_TYPE

/** @brief <b>plugin counters clear </b>
 *   - <i>Clear all counter values.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COUNTERS_PLUGIN_COUNTERS_CLEAR

/** @brief <b>plugin counters print </b>
 *   - <i>Print all counter values and clear them.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COUNTERS_PLUGIN_COUNTERS_PRINT

/** @brief <b>plugin counters print-thresholds </b>
 *   - <i>Prints the thresholds of all the counters.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COUNTERS_PLUGIN_COUNTERS_PRINT_THRESHOLDS

/** @brief <b>plugin counters reset-threshold </b>
 *   - <i>Resets all thresholds values to 0xFFFF.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COUNTERS_PLUGIN_COUNTERS_RESET_THRESHOLD

/** @brief <b>plugin counters send-request </b>
 *   - <i>Sends a request for ota counters</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COUNTERS_PLUGIN_COUNTERS_SEND_REQUEST

/** @brief <b>plugin counters set-threshold [type:1] [threshold:2] </b>
 *   - <i>Set a threshold value for a particular type of counter.</i>
 *     - type - INT8U - type of counter
 *     - threshold - INT16U - Threshold Value
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COUNTERS_PLUGIN_COUNTERS_SET_THRESHOLD

/** @brief <b>plugin counters simple-print </b>
 *   - <i>Print all counter values.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_COUNTERS_PLUGIN_COUNTERS_SIMPLE_PRINT

/** @} */ // end group plugin-counters

/** @addtogroup plugin-device-table Plugin Commands: Device Table
 * @ingroup cli
 * The device table plugin demonstrates tracking devices as they join the
	 
 * gateway's ZigBee network.
 * 
 * @{
 */

/** @brief <b>plugin device-table clear </b>
 *   - <i>Clear the device table</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_CLEAR

/** @brief <b>plugin device-table disc [nodeId:2] </b>
 *   - <i>Force a (re)discovery of the device based on the node ID.</i>
 *     - nodeId - INT16U - Node ID to discover.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_DISC

/** @brief <b>plugin device-table iremove [index:2] </b>
 *   - <i>Remove device from device table.</i>
 *     - index - INT16U - Device table index.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_IREMOVE

/** @brief <b>plugin device-table irepair [index:2] </b>
 *   - <i>Kick off device route repair.</i>
 *     - index - INT16U - Device table index.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_IREPAIR

/** @brief <b>plugin device-table isend [index:2] </b>
 *   - <i>Send to device in device table.</i>
 *     - index - INT16U - Device table index.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_ISEND

/** @brief <b>plugin device-table leave [eui64:8] </b>
 *   - <i>Remove device from device table.</i>
 *     - eui64 - IEEE_ADDRESS - EUI64 of device.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_LEAVE

/** @brief <b>plugin device-table load </b>
 *   - <i>Load the file.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_LOAD

/** @brief <b>plugin device-table print </b>
 *   - <i>Print the device table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_PRINT

/** @brief <b>plugin device-table remove [eui64:8] </b>
 *   - <i>Remove device from device table.</i>
 *     - eui64 - IEEE_ADDRESS - EUI64 of device.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_REMOVE

/** @brief <b>plugin device-table repair [eui64:8] </b>
 *   - <i>Kick off device route repair.</i>
 *     - eui64 - IEEE_ADDRESS - EUI64 of device.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_REPAIR

/** @brief <b>plugin device-table save </b>
 *   - <i>Save the file.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_SAVE

/** @brief <b>plugin device-table send [eui64:8] [endpoint:1] </b>
 *   - <i>Send to device in device table.</i>
 *     - eui64 - IEEE_ADDRESS - EUI64 of device.
 *     - endpoint - INT8U - Endpoint of device.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_DEVICE_TABLE_PLUGIN_DEVICE_TABLE_SEND

/** @} */ // end group plugin-device-table

/** @addtogroup plugin-ezmode-commissioning Plugin Commands: EZ-Mode Commissioning
 * @ingroup cli
 * The EZ-Mode Commissioning plugin contributes several commands to the
 * application framework's CLI.
 * 
 * @{
 */

/** @brief <b>plugin ezmode-commissioning client [endpoint:1] [direction:1] [clusterIds:2] </b>
 *   - <i>Start EZ-Mode client commissioning.</i>
 *     - endpoint - INT8U - The local endpoint.
 *     - direction - INT8U - ::EMBER_AF_EZMODE_COMMISSIONING_SERVER_TO_CLIENT or ::EMBER_AF_EZMODE_COMMISSIONING_CLIENT_TO_SERVER.
 *     - clusterIds - INT16U - A list of cluster ids.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_EZMODE_COMMISSIONING_PLUGIN_EZMODE_COMMISSIONING_CLIENT

/** @brief <b>plugin ezmode-commissioning server [endpoint:1] [identifyTimeS:2] </b>
 *   - <i>Start EZ-Mode server commissioning.</i>
 *     - endpoint - INT8U - The local endpoint.
 *     - identifyTimeS - INT16U - The identify time in seconds.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_EZMODE_COMMISSIONING_PLUGIN_EZMODE_COMMISSIONING_SERVER

/** @} */ // end group plugin-ezmode-commissioning

/** @addtogroup plugin-gateway Plugin Commands: Gateway Support
 * @ingroup cli
 * The gateway support commands provide functionality specific to running a PC
 * host application connected to an Ember chip via EZSP.
 * 
 * @{
 */

/** @brief <b>plugin gateway time-sync-local </b>
 *   - <i>This command will sync the ZCL device's local time attribute with the local PC clock.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GATEWAY_PLUGIN_GATEWAY_TIME_SYNC_LOCAL

/** @} */ // end group plugin-gateway

/** @addtogroup plugin-green-power-client Plugin Commands: Green Power Client
 * @ingroup cli
 * The Green Power Client plugin contributes CLI commands to the application
 * framework to be used for getting, setting, and displaying information
 * relevant to the Green Power Client cluster.
 * 
 * @{
 */

/** @brief <b>plugin green-power-client add-group-sink [sourceID:4] [sinkGroup:2] </b>
 *   - <i>Add a groupcast sink for a given GPD</i>
 *     - sourceID - INT32U - GPD Source ID
 *     - sinkGroup - INT16U - Sink group
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_ADD_GROUP_SINK

/** @brief <b>plugin green-power-client add-sink [sourceID:4] [sinkIeee:8] </b>
 *   - <i>Add a sink for a given GPD</i>
 *     - sourceID - INT32U - GPD Source ID
 *     - sinkIeee - IEEE_ADDRESS - Sink's IEEE address
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_ADD_SINK

/** @brief <b>plugin green-power-client clear-proxy-table </b>
 *   - <i>clear the proxy table</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_CLEAR_PROXY_TABLE

/** @brief <b>plugin green-power-client duplicate-filter-test [endpoint:1] [sourceId:4] [sequenceNumber:1] </b>
 *   - <i>This is used to instrument the current device receiving a message in order to test the duplicate message filtering functionality.</i>
 *     - endpoint - INT8U
 *     - sourceId - INT32U - source Id of the fake incoming message
 *     - sequenceNumber - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_DUPLICATE_FILTER_TEST

/** @brief <b>plugin green-power-client print-proxy-table </b>
 *   - <i>Print the proxy table</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_PRINT_PROXY_TABLE

/** @brief <b>plugin green-power-client rm-gpd [sourceID:4] </b>
 *   - <i>Remove a given GPD from the proxy table</i>
 *     - sourceID - INT32U - GPD Source ID
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_RM_GPD

/** @brief <b>plugin green-power-client rm-sink [sourceID:4] [sinkIeee:8] </b>
 *   - <i>remove a sink for a given GPD.  If that's the last sink, remove the proxy table entry</i>
 *     - sourceID - INT32U - GPD Source ID
 *     - sinkIeee - IEEE_ADDRESS - Sink's IEEE address
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_RM_SINK

/** @brief <b>plugin green-power-client set-key [index:1] [key:16] </b>
 *   - <i>This is used to set the key for a proxy table entry</i>
 *     - index - INT8U
 *     - key - SECURITY_KEY - source Id of the fake incoming message
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_SET_KEY

/** @brief <b>plugin green-power-client set-proxy-entry [index:1] [sourceID:4] [sinkNodeId:2] [options:4] </b>
 *   - <i>Set a proxy table entry</i>
 *     - index - INT8U - index to proxy table
 *     - sourceID - INT32U - GPD Source ID
 *     - sinkNodeId - INT16U - Sink's node address
 *     - options - INT32U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_GREEN_POWER_CLIENT_PLUGIN_GREEN_POWER_CLIENT_SET_PROXY_ENTRY

/** @} */ // end group plugin-green-power-client

/** @addtogroup plugin-ias-zone-client Plugin Commands: IAS Zone Client
 * @ingroup cli
 * This plugin provides a set of CLI commands for managing the servers known to
 * the IAS Zone client.
 * 
 * @{
 */

/** @brief <b>plugin ias-zone-client clear-all </b>
 *   - <i>Clear all known IAS Zone Servers from local device.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_IAS_ZONE_CLIENT_PLUGIN_IAS_ZONE_CLIENT_CLEAR_ALL

/** @brief <b>plugin ias-zone-client print-servers </b>
 *   - <i>Print the known IAS Zone Servers.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_IAS_ZONE_CLIENT_PLUGIN_IAS_ZONE_CLIENT_PRINT_SERVERS

/** @} */ // end group plugin-ias-zone-client

/** @addtogroup plugin-identify Plugin Commands: Identify
 * @ingroup cli
 * The identify plugin contributes a CLI command to the application framework to
 * be used for printing information related to identification.
 * 
 * @{
 */

/** @brief <b>plugin identify print </b>
 *   - <i>Print which endpoints are reporting.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_IDENTIFY_PLUGIN_IDENTIFY_PRINT

/** @} */ // end group plugin-identify

/** @addtogroup plugin-network-creator Plugin Commands: Network Creator
 * @ingroup cli
 * Commands pertaining to network creation with the Network Creator plugin.
 * 
 * @{
 */

/** @brief <b>plugin network-creator form [useCentralizedSecurity:1] [panId:2] [radioTxPower:1] [channel:1] </b>
 *   - <i>Form a network with specified parameters.</i>
 *     - useCentralizedSecurity - BOOLEAN - Whether or not to form a centralized network. If this value is false, the device will attempt to join a distributed network.
 *     - panId - INT16U - PanID of the network to be formed
 *     - radioTxPower - INT8S - Tx power of the network to be formed
 *     - channel - INT8U - channel of the network to be formed
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_PLUGIN_NETWORK_CREATOR_FORM

/** @brief <b>plugin network-creator mask add [mask:1] [channel:4] </b>
 *   - <i>Add a channel to the channel mask of choice.</i>
 *     - mask - INT8U - The mask of choice to which to add the channel. Entering an argument of '1' will choose the primary channel mask. Any other argument will choose the secondary channel mask.
 *     - channel - INT32U - The channel to add to the channel mask.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_PLUGIN_NETWORK_CREATOR_MASK_ADD

/** @brief <b>plugin network-creator mask set [mask:1] [newChannelMask:4] </b>
 *   - <i>Set a channel mask.</i>
 *     - mask - INT8U - The mask of choice to set. Entering an argument of '1' will choose the primary channel mask. Any other argument will choose the secondary channel mask.
 *     - newChannelMask - INT32U - The bit mask to which to set the chosen channel mask.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_PLUGIN_NETWORK_CREATOR_MASK_SET

/** @brief <b>plugin network-creator mask subtract [mask:1] [channel:4] </b>
 *   - <i>Subtract a channel from the channel mask of choice.</i>
 *     - mask - INT8U - The mask of choice from which to subtract the channel. Entering an argument of '1' will choose the primary channel mask. Any other argument will choose the secondary channel mask.
 *     - channel - INT32U - The channel to subtract from the channel mask.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_PLUGIN_NETWORK_CREATOR_MASK_SUBTRACT

/** @brief <b>plugin network-creator start [useCentralizedSecurity:1] </b>
 *   - <i>Starts the network formation process.</i>
 *     - useCentralizedSecurity - BOOLEAN - Whether or not to form a centralized network. If this value is false, the device will attempt to join a distributed network.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_PLUGIN_NETWORK_CREATOR_START

/** @brief <b>plugin network-creator status </b>
 *   - <i>Print the status of the network-creator plugin.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_PLUGIN_NETWORK_CREATOR_STATUS

/** @brief <b>plugin network-creator stop </b>
 *   - <i>Stops the network formation process.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_PLUGIN_NETWORK_CREATOR_STOP

/** @} */ // end group plugin-network-creator

/** @addtogroup plugin-network-creator-security Plugin Commands: Network Creator Security
 * @ingroup cli
 * Commands pertaining to network creation with the Network Creator plugin.
 * 
 * @{
 */

/** @brief <b>plugin network-creator-security clear-joining-link-keys </b>
 *   - <i>Clear all of the joining link keys stored in the stack.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_SECURITY_PLUGIN_NETWORK_CREATOR_SECURITY_CLEAR_JOINING_LINK_KEYS

/** @brief <b>plugin network-creator-security close-network </b>
 *   - <i>Close the network for joining.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_SECURITY_PLUGIN_NETWORK_CREATOR_SECURITY_CLOSE_NETWORK

/** @brief <b>plugin network-creator-security open-network </b>
 *   - <i>Open the network for joining.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_SECURITY_PLUGIN_NETWORK_CREATOR_SECURITY_OPEN_NETWORK

/** @brief <b>plugin network-creator-security open-with-key [eui64:8] [joiningLinkKey:-1] </b>
 *   - <i>Open the network that would only allow the node with specified EUI and link key pair to join.</i>
 *     - eui64 - IEEE_ADDRESS - The EUI64 of the joining device.
 *     - joiningLinkKey - OCTET_STRING - The link key that the joining device will use to enter the network.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_SECURITY_PLUGIN_NETWORK_CREATOR_SECURITY_OPEN_WITH_KEY

/** @brief <b>plugin network-creator-security set-joining-link-key [eui64:8] [joiningLinkKey:-1] </b>
 *   - <i>Set the link key that a specific joining device will use when joining the network. This command can be also used to add install code derived link keys. If all FF's are entered for the EUI64 for the joining device, then this link key will be used for all joining devices without a joining key entry.</i>
 *     - eui64 - IEEE_ADDRESS - The EUI64 of the joining device.
 *     - joiningLinkKey - OCTET_STRING - The link key that the joining device will use to enter the network.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_NETWORK_CREATOR_SECURITY_PLUGIN_NETWORK_CREATOR_SECURITY_SET_JOINING_LINK_KEY

/** @} */ // end group plugin-network-creator-security

/** @addtogroup plugin-ota-server Plugin Commands: OTA Server
 * @ingroup cli
 * The OTA Server plugin provides Over-the-air commands for upgrading firmware
 * and downloading specific files on the server side.
 * 
 * @{
 */

/** @brief <b>plugin ota-server load-file [fileName:-1] </b>
 *   - <i>Load file.</i>
 *     - fileName - OCTET_STRING - The file name.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_LOAD_FILE

/** @brief <b>plugin ota-server notify [destination:2] [endpoint:1] [payloadType:1] [jitter:1] [manuf-id:2] [imageTypeId:2] [version:4] </b>
 *   - <i>Sends an OTA Image Notify message to the specified destination indicating a new version of an image is available for download.</i>
 *     - destination - INT16U - The node ID (can be a broadcast address) to which this OTA Notify message should be sent
 *     - endpoint - INT8U - Target endpoint for the OTA Notify message (only really meaningful for non-broadcast target destination).
 *     - payloadType - INT8U - Used to specify which parameters you want included in the OTA Notify cluster command payload (0 = jitter value only; 1 = jitter and manufacturer id; 2 = jitter, mfr id, and device id; 3 = jitter, mfr id, device id, and firmware version)
 *     - jitter - INT8U - Corresponds to QueryJitter parameter in the OTA Upgrade cluster specification. The parameter indicates whether the client receiving Image Notify Command should send in Query Next Image Request command or not.
 *     - manuf-id - INT16U - Manufacturer ID for the image being advertised (should match the mfr ID in the OTA file's header)
 *     - imageTypeId - INT16U - Image type ID for the image being advertised (should match the image type ID from the OTA file's header)
 *     - version - INT32U - Firmware version of the image being advertised (should match the version from the OTA file's header)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_NOTIFY

/** @brief <b>plugin ota-server policy blockRequest [policyValue:1] </b>
 *   - <i>Sets the policy used by the ota-server Policy Plugin when it receives an image block request.</i>
 *     - policyValue - INT8U - 0: Send block (default), 1: Delay download once for 2 minutes, 2: Always abort download after first block
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_POLICY_BLOCK_REQUEST

/** @brief <b>plugin ota-server policy client-delay-units [clientDelayUnits:1] </b>
 *   - <i>For testing, force the server to treat the Minimum Block Period in a certain unit (see ota-server-policy.h for values).</i>
 *     - clientDelayUnits - INT8U - The unit to treat the minimum block period field.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_POLICY_CLIENT_DELAY_UNITS

/** @brief <b>plugin ota-server policy image-req-min-period [period:2] </b>
 *   - <i></i>
 *     - period - INT16U - The minimum block period in milliseconds.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_POLICY_IMAGE_REQ_MIN_PERIOD

/** @brief <b>plugin ota-server policy page-req-miss [policyValue:1] </b>
 *   - <i></i>
 *     - policyValue - INT8U - 0: Upgrade if server has newer (default), 1: Downgrade if server has older, 2:       Reinstall if server has same, 3: No next version (no next image is available for download)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_POLICY_PAGE_REQ_MISS

/** @brief <b>plugin ota-server policy page-req-sup [policyValue:1] </b>
 *   - <i></i>
 *     - policyValue - INT8U - 0: Upgrade if server has newer (default), 1: Downgrade if server has older, 2:       Reinstall if server has same, 3: No next version (no next image is available for download)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_POLICY_PAGE_REQ_SUP

/** @brief <b>plugin ota-server policy print </b>
 *   - <i>Prints the polices used by the OTA Server Policy Plugin</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_POLICY_PRINT

/** @brief <b>plugin ota-server policy query [policyValue:1] </b>
 *   - <i>Sets the policy used by the OTA Server Policy Plugin when it receives a query request from the client.</i>
 *     - policyValue - INT8U - 0: Upgrade if server has newer (default), 1: Downgrade if server has older, 2:       Reinstall if server has same, 3: No next version (no next image is available for download)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_POLICY_QUERY

/** @brief <b>plugin ota-server policy upgrade [policyValue:1] </b>
 *   - <i>Sets the policy used by the OTA Server Policy Plugin when it receives an upgrade end request</i>
 *     - policyValue - INT8U - 0: Upgrade Now (default), 1: Upgrade in 2       minutes, 2: Ask me later to upgrade, 3: Abort Upgrade (send default response)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_POLICY_UPGRADE

/** @brief <b>plugin ota-server upgrade [nodeId:2] [endpoint:1] [mfrId:2] [imageType:2] [fileVersion:4] </b>
 *   - <i>Instruct a device to upgrade now.</i>
 *     - nodeId - INT16U - Short destination to send message
 *     - endpoint - INT8U - Endpoint destination to send message
 *     - mfrId - INT16U - Manufacturer ID for the image (0xFFFF for wildcard)
 *     - imageType - INT16U - Image type for the image (0xFFFF for wildcard)
 *     - fileVersion - INT32U - File version for the image (0xFFFFFFFF for wildcard)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_SERVER_PLUGIN_OTA_SERVER_UPGRADE

/** @} */ // end group plugin-ota-server

/** @addtogroup plugin-ota-storage-common Plugin Commands: OTA Storage Common
 * @ingroup cli
 * The OTA Storage Common plugin provides Over-the-air commands for upgrading
 * firmware and 
      downloading specific files common to both server and
 * client.
 * 
 * @{
 */

/** @brief <b>plugin ota-storage-common data-print [index:1] [offset:4] </b>
 *   - <i>Print arbitray bytes of the OTA image on disk.</i>
 *     - index - INT8U - The index of the image to print its data.
 *     - offset - INT32U - The offset into the OTA image that will be printed.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_STORAGE_COMMON_PLUGIN_OTA_STORAGE_COMMON_DATA_PRINT

/** @brief <b>plugin ota-storage-common delete [index:1] </b>
 *   - <i>Deletes the image at the specified index.</i>
 *     - index - INT8U - The index at which to begin bootloading the image
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_STORAGE_COMMON_PLUGIN_OTA_STORAGE_COMMON_DELETE

/** @brief <b>plugin ota-storage-common printImages </b>
 *   - <i>Prints the images.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_STORAGE_COMMON_PLUGIN_OTA_STORAGE_COMMON_PRINT_IMAGES

/** @brief <b>plugin ota-storage-common reload </b>
 *   - <i>Reload the storage device.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_STORAGE_COMMON_PLUGIN_OTA_STORAGE_COMMON_RELOAD

/** @brief <b>plugin ota-storage-common storage-info </b>
 *   - <i>Print information about the storage device.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_OTA_STORAGE_COMMON_PLUGIN_OTA_STORAGE_COMMON_STORAGE_INFO

/** @} */ // end group plugin-ota-storage-common

/** @addtogroup plugin-poll-control-client Plugin Commands: Poll Control Client
 * @ingroup cli
 * The poll-control-client plugin contributes CLI commands to the application
 * framework to be used for setting poll control parameters in a local, client
 * context.
 * 
 * @{
 */

/** @brief <b>plugin poll-control-client mode [mode:1] </b>
 *   - <i>Set the fast polling mode.</i>
 *     - mode - BOOLEAN - The fast polling mode.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_POLL_CONTROL_CLIENT_PLUGIN_POLL_CONTROL_CLIENT_MODE

/** @brief <b>plugin poll-control-client print </b>
 *   - <i>Print the fast polling mode and timeout.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_POLL_CONTROL_CLIENT_PLUGIN_POLL_CONTROL_CLIENT_PRINT

/** @brief <b>plugin poll-control-client respond [mode:1] </b>
 *   - <i>Set the response mode.</i>
 *     - mode - BOOLEAN - The response mode.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_POLL_CONTROL_CLIENT_PLUGIN_POLL_CONTROL_CLIENT_RESPOND

/** @brief <b>plugin poll-control-client timeout [timeout:2] </b>
 *   - <i>Set the fast polling timeout.</i>
 *     - timeout - INT16U - The fast polling timeout.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_POLL_CONTROL_CLIENT_PLUGIN_POLL_CONTROL_CLIENT_TIMEOUT

/** @} */ // end group plugin-poll-control-client

/** @addtogroup plugin-reporting Plugin Commands: Reporting
 * @ingroup cli
 * The reporting plugin contributes several CLI commands to the application
 * framework to be used in creating and managing reporting table entries
 * directly on the device.
 * 
 * @{
 */

/** @brief <b>plugin reporting add [endpoint:1] [clusterId:2] [attributeId:2] [mask:1] [minInterval:2] [maxInterval:2] [reportableChange:4] </b>
 *   - <i>Add a new entry to the report table.</i>
 *     - endpoint - INT8U - The local endpoint from which the attribute is reported.
 *     - clusterId - INT16U - The cluster where the attribute is located.
 *     - attributeId - INT16U - The id of the attribute being reported.
 *     - mask - INT8U - 0 for client-side attributes or 1 for server-side attributes.
 *     - minInterval - INT16U - The minimum reporting interval, measured in seconds.
 *     - maxInterval - INT16U - The maximum reporting interval, measured in seconds.
 *     - reportableChange - INT32U - The minimum change to the attribute that will result in a report being sent.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_REPORTING_PLUGIN_REPORTING_ADD

/** @brief <b>plugin reporting clear </b>
 *   - <i>Clear all entries from the report table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_REPORTING_PLUGIN_REPORTING_CLEAR

/** @brief <b>plugin reporting clear-last-report-time </b>
 *   - <i>Clear last report time of attributes.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_REPORTING_PLUGIN_REPORTING_CLEAR_LAST_REPORT_TIME

/** @brief <b>plugin reporting print </b>
 *   - <i>Print the report table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_REPORTING_PLUGIN_REPORTING_PRINT

/** @brief <b>plugin reporting remove [index:1] </b>
 *   - <i>Remove an entry from the report table.</i>
 *     - index - INT8U - The index of the report to be removed.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_REPORTING_PLUGIN_REPORTING_REMOVE

/** @} */ // end group plugin-reporting

/** @addtogroup plugin-simple-metering-client Plugin Commands: Simple Metering Client
 * @ingroup cli
 * The simple-metering-client plugin contributes CLI commands to the application
 * framework to be used in conjunction with the Simple Metering cluster in a
 * client context.
 * 
 * @{
 */

/** @brief <b>plugin simple-metering-client get-sampled-data [server:2] [clientEndpoint:1] [serverEndpoint:1] [sampleId:2] [startTime:4] [sampleType:1] [numberOfSamples:2] </b>
 *   - <i>Send a start sampling command to a metering server.</i>
 *     - server - INT16U - The network address of the server to which the request will be sent.
 *     - clientEndpoint - INT8U - The local endpoint from which the request will be sent.
 *     - serverEndpoint - INT8U - The remote endpoint to which the request will be sent.
 *     - sampleId - INT16U - The sample id as received in a previous startSamplingResponse
 *     - startTime - INT32U - The earliest start time sampling
 *     - sampleType - INT8U - An 8 bit enumeration that identifies the required type of sampled data
 *     - numberOfSamples - INT16U - The total number of samples.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_SIMPLE_METERING_CLIENT_PLUGIN_SIMPLE_METERING_CLIENT_GET_SAMPLED_DATA

/** @brief <b>plugin simple-metering-client local-change-supply [server:2] [clientEndpoint:1] [serverEndpoint:1] [proposedSupplyStatus:1] </b>
 *   - <i>Send a start sampling command to a metering server.</i>
 *     - server - INT16U - The network address of the server to which the request will be sent.
 *     - clientEndpoint - INT8U - The local endpoint from which the request will be sent.
 *     - serverEndpoint - INT8U - The remote endpoint to which the request will be sent.
 *     - proposedSupplyStatus - INT8U - The proposed supply status: either ON(2) or OFF/ARMED(1)
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_SIMPLE_METERING_CLIENT_PLUGIN_SIMPLE_METERING_CLIENT_LOCAL_CHANGE_SUPPLY

/** @brief <b>plugin simple-metering-client sch-snapshot [server:2] [clientEndpoint:1] [serverEndpoint:1] [issuerId:4] [commandIndex:1] [numberofCommands:1] [snapshotScheduleId:1] [snapshotStartDate:4] [snapshotSchedule:4] [snapshotType:1] [snapshotCause:4] </b>
 *   - <i>Schedule a snapshot.</i>
 *     - server - INT16U - The network address of the server to which the request will be sent.
 *     - clientEndpoint - INT8U - The local endpoint from which the request will be sent.
 *     - serverEndpoint - INT8U - The remote endpoint to which the request will be sent.
 *     - issuerId - INT32U - The issuerId.
 *     - commandIndex - INT8U - The commandIndex.
 *     - numberofCommands - INT8U - The total number of commands
 *     - snapshotScheduleId - INT8U - The snapshot schedule Id.
 *     - snapshotStartDate - INT32U - The start time.
 *     - snapshotSchedule - INT32U - The snapshot schedule. 3 bytes
 *     - snapshotType - INT8U - The snapshot Type.
 *     - snapshotCause - INT32U - The snapshot schedule cause.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_SIMPLE_METERING_CLIENT_PLUGIN_SIMPLE_METERING_CLIENT_SCH_SNAPSHOT

/** @brief <b>plugin simple-metering-client start-sampling [server:2] [clientEndpoint:1] [serverEndpoint:1] [issuerId:4] [startTime:4] [sampleType:1] [SampleRequestInterval:2] [maxNumberOfSamples:2] </b>
 *   - <i>Send a start sampling command to a metering server.</i>
 *     - server - INT16U - The network address of the server to which the request will be sent.
 *     - clientEndpoint - INT8U - The local endpoint from which the request will be sent.
 *     - serverEndpoint - INT8U - The remote endpoint to which the request will be sent.
 *     - issuerId - INT32U - The issuerId.
 *     - startTime - INT32U - The time to start sampling
 *     - sampleType - INT8U - An 8 bit enumeration that identifies the type of data being sampled
 *     - SampleRequestInterval - INT16U - An unsigned 16-bit field representing the interval or time in seconds between samples.
 *     - maxNumberOfSamples - INT16U - A 16 bit unsigned integer that represents the number of samples to be taken.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_SIMPLE_METERING_CLIENT_PLUGIN_SIMPLE_METERING_CLIENT_START_SAMPLING

/** @} */ // end group plugin-simple-metering-client

/** @addtogroup plugin-stack-diagnostics Plugin Commands: Stack Diagnostics
 * @ingroup cli
 * These commands give more information about the status of the status of the
 * stack, such as routing tables, neighbor tables, and child tables.
 * 
 * @{
 */

/** @brief <b>plugin stack-diagnostics child-table </b>
 *   - <i>Prints out the entries in the stack's child table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_STACK_DIAGNOSTICS_PLUGIN_STACK_DIAGNOSTICS_CHILD_TABLE

/** @brief <b>plugin stack-diagnostics info </b>
 *   - <i>Prints out general information about the state of the stack.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_STACK_DIAGNOSTICS_PLUGIN_STACK_DIAGNOSTICS_INFO

/** @brief <b>plugin stack-diagnostics neighbor-table </b>
 *   - <i>Prints out the entries in the stack's neighbor table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_STACK_DIAGNOSTICS_PLUGIN_STACK_DIAGNOSTICS_NEIGHBOR_TABLE

/** @brief <b>plugin stack-diagnostics route-table </b>
 *   - <i>Prints out the entries in the stack's route table.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_STACK_DIAGNOSTICS_PLUGIN_STACK_DIAGNOSTICS_ROUTE_TABLE

/** @} */ // end group plugin-stack-diagnostics

/** @addtogroup plugin-test-harness Plugin Commands: Test Harness
 * @ingroup cli
 * The test harness commands are used to test various unusual functionality or
 * behavior of a remote device.
 * 
 * @{
 */

/** @brief <b>plugin test-harness add-child [ShortId:2] [EUI:-1] [nodeType:1] </b>
 *   - <i>Adds a child to the child table.</i>
 *     - ShortId - INT16U - The shortId of the child device.
 *     - EUI - OCTET_STRING - The EUI64 of the child (big endian).
 *     - nodeType - INT8U - The node type of the child device.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_ADD_CHILD

/** @brief <b>plugin test-harness aps-sec-for-cluster off </b>
 *   - <i>Turns off automatic APS security for the previously specified cluster.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_APS_SEC_FOR_CLUSTER_OFF

/** @brief <b>plugin test-harness aps-sec-for-cluster on [clusterId:2] </b>
 *   - <i>Turns on automatic APS security for the specified cluster.</i>
 *     - clusterId - INT16U - The cluster ID to add APS security to automatically.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_APS_SEC_FOR_CLUSTER_ON

/** @brief <b>plugin test-harness attr options [type:1] [timeout:2] </b>
 *   - <i>Set the options for the attributes tests.</i>
 *     - type - INT8U
 *     - timeout - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_ATTR_OPTIONS

/** @brief <b>plugin test-harness attr set-dest [addr:2] [endpoint:1] </b>
 *   - <i>Set the destination for the attributes tests.</i>
 *     - addr - INT16U
 *     - endpoint - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_ATTR_SET_DEST

/** @brief <b>plugin test-harness attr start-test [clusterId:2] [attrStartId:2] [attrEndId:2] [clientToServer:1] </b>
 *   - <i>Start the attributes test.</i>
 *     - clusterId - INT16U
 *     - attrStartId - INT16U
 *     - attrEndId - INT16U
 *     - clientToServer - BOOLEAN
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_ATTR_START_TEST

/** @brief <b>plugin test-harness channel-mask add [channel:1] </b>
 *   - <i>Add a channel to the mask</i>
 *     - channel - INT8U - The 802.15.4 chanel to add.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_CHANNEL_MASK_ADD

/** @brief <b>plugin test-harness channel-mask all </b>
 *   - <i>Sets the channel mask to all channels</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_CHANNEL_MASK_ALL

/** @brief <b>plugin test-harness channel-mask clear </b>
 *   - <i>Clears the channel mask used by network find.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_CHANNEL_MASK_CLEAR

/** @brief <b>plugin test-harness channel-mask remove [channel:1] </b>
 *   - <i>Remove a channel from the mask</i>
 *     - channel - INT8U - The 802.15.4 chanel to remove.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_CHANNEL_MASK_REMOVE

/** @brief <b>plugin test-harness channel-mask reset </b>
 *   - <i>Resets the channel mask back to the app default.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_CHANNEL_MASK_RESET

/** @brief <b>plugin test-harness concentrator start </b>
 *   - <i>Starts the concentrator's periodic broadcasts.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_CONCENTRATOR_START

/** @brief <b>plugin test-harness concentrator stop </b>
 *   - <i>Starts the concentrator's periodic broadcasts.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_CONCENTRATOR_STOP

/** @brief <b>plugin test-harness endpoint cluster-endpoint-index [endpoint:1] [clusterId:2] [mask:1] </b>
 *   - <i>Get cluster endpoint index</i>
 *     - endpoint - INT8U - The local endpoint of the cluster.
 *     - clusterId - INT16U - The cluster whose index is needed.
 *     - mask - INT8U - 0 for client-side attributes or 1 for server-side attributes.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_ENDPOINT_CLUSTER_ENDPOINT_INDEX

/** @brief <b>plugin test-harness endpoint disable [endpoint:1] </b>
 *   - <i>Disables the endpont to receive messages and be discovered</i>
 *     - endpoint - INT8U - The endpoint number.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_ENDPOINT_DISABLE

/** @brief <b>plugin test-harness endpoint enable [endpoint:1] </b>
 *   - <i>Enables the endpont to receive messages and be discovered</i>
 *     - endpoint - INT8U - The endpoint number.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_ENDPOINT_ENABLE

/** @brief <b>plugin test-harness endpoint status </b>
 *   - <i>Disables the endpont to receive messages and be discovered</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_ENDPOINT_STATUS

/** @brief <b>plugin test-harness hash-the-flash </b>
 *   - <i>Runs the AES-CCM algorithm over the contents of the software image to calcalute the image stamp.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_HASH_THE_FLASH

/** @brief <b>plugin test-harness key-establishment adv-aps-fc </b>
 *   - <i>Advances the local device's outgoing APS FC by 4096.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_ADV_APS_FC

/** @brief <b>plugin test-harness key-establishment cert-mangle change-byte [byteIndex:1] [byteValue:1] </b>
 *   - <i>Changes a single byte in the cert</i>
 *     - byteIndex - INT8U - The index of the certificate byte to change
 *     - byteValue - INT8U - The new value of the certificate byte
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_CERT_MANGLE_CHANGE_BYTE

/** @brief <b>plugin test-harness key-establishment cert-mangle corrupt [corruptionIndex:1] </b>
 *   - <i>Corrupts a single byte in the cert</i>
 *     - corruptionIndex - INT8U - The index of the certificate byte to corrupt
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_CERT_MANGLE_CORRUPT

/** @brief <b>plugin test-harness key-establishment cert-mangle issuer [issuer:-1] </b>
 *   - <i>Changes the issuer in the certificate.</i>
 *     - issuer - OCTET_STRING - The EUI64 of the issuer (big endian).
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_CERT_MANGLE_ISSUER

/** @brief <b>plugin test-harness key-establishment cert-mangle length [lengthModifier:1] </b>
 *   - <i>Mangles the length of the certificate</i>
 *     - lengthModifier - INT8S - The positive or negative change in length.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_CERT_MANGLE_LENGTH

/** @brief <b>plugin test-harness key-establishment cert-mangle subject [subject:-1] </b>
 *   - <i>Changes the subject (EUI64) of the cert</i>
 *     - subject - OCTET_STRING - The EUI64 of the subject (big endian).
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_CERT_MANGLE_SUBJECT

/** @brief <b>plugin test-harness key-establishment default-resp </b>
 *   - <i>Sends a default response error message in response to initate KE.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_DEFAULT_RESP

/** @brief <b>plugin test-harness key-establishment delay-cbke [actualDelay:2] [advertisedDelay:2] </b>
 *   - <i>Changes the advertised delays by the local device for CBKE.</i>
 *     - actualDelay - INT16U - Set the actual delay that occurs.
 *     - advertisedDelay - INT16U - Sets the advertised delay sent to the partner of key establishment
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_DELAY_CBKE

/** @brief <b>plugin test-harness key-establishment key-mangle [lengthModifier:1] </b>
 *   - <i>Mangles the length of the empheral key.</i>
 *     - lengthModifier - INT8S - The positive or negative change in length.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_KEY_MANGLE

/** @brief <b>plugin test-harness key-establishment new-key-policy [allowKeyEstablishmentPolicy:1] </b>
 *   - <i>Sets the policy of whether the TC allows new KE requests.</i>
 *     - allowKeyEstablishmentPolicy - INT8U - Allows / disallows new key establishment requests.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_NEW_KEY_POLICY

/** @brief <b>plugin test-harness key-establishment no-resources </b>
 *   - <i>All received KE requests will be responded with 'no resources'.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_NO_RESOURCES

/** @brief <b>plugin test-harness key-establishment normal-mode </b>
 *   - <i>Sets the key establishment mode to normal.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_NORMAL_MODE

/** @brief <b>plugin test-harness key-establishment out-of-sequence [commandId:1] </b>
 *   - <i>All received KE requests will be responded with 'no resources'.</i>
 *     - commandId - INT8U - The out-of-sequence command ID to send.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_OUT_OF_SEQUENCE

/** @brief <b>plugin test-harness key-establishment reset-aps-fc </b>
 *   - <i>Forces the local device to reset its outgoing APS FC.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_RESET_APS_FC

/** @brief <b>plugin test-harness key-establishment set-available-suite [suite:2] </b>
 *   - <i>Selects between the CBKE 163k1 and 283k1 suites.</i>
 *     - suite - INT16U - This field holds the type        of key establishment suite. It can be EMBER_AF_CBKE_KEY_ESTABLISHMENT_SUITE_163K1,        EMBER_AF_CBKE_KEY_ESTABLISHMENT_SUITE_283K1, or        EMBER_AF_INVALID_KEY_ESTABLISHMENT_SUITE
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_SET_AVAILABLE_SUITE

/** @brief <b>plugin test-harness key-establishment suite [suite:2] </b>
 *   - <i>Selects between the CBKE 163k1 and 283k1 suites.</i>
 *     - suite - INT16U - This field holds the type        of key establishment suite. It can be EMBER_AF_CBKE_KEY_ESTABLISHMENT_SUITE_163K1,        EMBER_AF_CBKE_KEY_ESTABLISHMENT_SUITE_283K1, or        EMBER_AF_INVALID_KEY_ESTABLISHMENT_SUITE
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_SUITE

/** @brief <b>plugin test-harness key-establishment timeout </b>
 *   - <i>Artificially creates a timeout by delaying an outgoing message.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_ESTABLISHMENT_TIMEOUT

/** @brief <b>plugin test-harness key-update broadcast </b>
 *   - <i>Changes TC NWK key update mechanism to broadcast.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_UPDATE_BROADCAST

/** @brief <b>plugin test-harness key-update now </b>
 *   - <i>Starts a TC NWK key update now</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_UPDATE_NOW

/** @brief <b>plugin test-harness key-update unicast </b>
 *   - <i>Changes TC NWK key update mechanism to unicast with APS security.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_KEY_UPDATE_UNICAST

/** @brief <b>plugin test-harness ota image-mangle [index:2] </b>
 *   - <i>Mangles the Simple Storage RAM OTA image.</i>
 *     - index - INT16U - The byte index into the OTA image that will be mangled.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_OTA_IMAGE_MANGLE

/** @brief <b>plugin test-harness price send-new-fields [sendNewFields:1] </b>
 *   - <i>Controls whether the new SE 1.1 price fields are included.</i>
 *     - sendNewFields - INT8U - Boolean indicating whether to send new fields.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_PRICE_SEND_NEW_FIELDS

/** @brief <b>plugin test-harness price send-se10-fields [sendNewFields:1] </b>
 *   - <i>Controls whether the new SE 1.1 price fields are included.</i>
 *     - sendNewFields - INT8U - Boolean indicating whether to send new fields.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_PRICE_SEND_SE10_FIELDS

/** @brief <b>plugin test-harness radio off </b>
 *   - <i>Turns off the radio so that no messages are sent.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_RADIO_OFF

/** @brief <b>plugin test-harness radio on </b>
 *   - <i>Turns on the radio if it was previously turned off</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_RADIO_ON

/** @brief <b>plugin test-harness registration off </b>
 *   - <i>Turns off automatic SE registration.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_REGISTRATION_OFF

/** @brief <b>plugin test-harness registration on </b>
 *   - <i>Turns on automatic SE registration.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_REGISTRATION_ON

/** @brief <b>plugin test-harness set-compliance-revision [version:1] </b>
 *   - <i>Setting a compliance revision for a device such that the device can act as pre-R21 or R21+ for testing purposes. The reason for doing this is because the end device may send a node descriptor request and the hub will respond with the node descriptor response which will include the hub's compliance revision. If the compliance revision of the hub is R21+, only then will the TC link key request be made by the end device.</i>
 *     - version - INT8U - The compliance version
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_SET_COMPLIANCE_REVISION

/** @brief <b>plugin test-harness set-radio-power [power:1] </b>
 *   - <i>Sets the radio power.</i>
 *     - power - INT8U - The radio power to set.
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_SET_RADIO_POWER

/** @brief <b>plugin test-harness stack limit-beacons off </b>
 *   - <i>Disables a limit to the max number of outgoing beacons.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_STACK_LIMIT_BEACONS_OFF

/** @brief <b>plugin test-harness stack limit-beacons on </b>
 *   - <i>Enables a limit to the max number of outgoing beacons.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_STACK_LIMIT_BEACONS_ON

/** @brief <b>plugin test-harness status </b>
 *   - <i>Display the current status of the test harness.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_STATUS

/** @brief <b>plugin test-harness tc-keepalive send </b>
 *   - <i>Sends a Trust Center Keepalive.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_TC_KEEPALIVE_SEND

/** @brief <b>plugin test-harness tc-keepalive start </b>
 *   - <i>Starts the TC keepalive state machine.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_TC_KEEPALIVE_START

/** @brief <b>plugin test-harness tc-keepalive stop </b>
 *   - <i>Stops the TC keepalive state machine.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TEST_HARNESS_PLUGIN_TEST_HARNESS_TC_KEEPALIVE_STOP

/** @} */ // end group plugin-test-harness

/** @addtogroup plugin-trust-center-backup Plugin Commands: Trust Center Backup
 * @ingroup cli
 * The Trust Center Backup plugin contributes several CLI commands to the
 * application framework to be used in creating and managing reporting table
 * entries directly on the device.
 * 
 * @{
 */

/** @brief <b>plugin trust-center-backup clear-import </b>
 *   - <i>Clear the import data set.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TRUST_CENTER_BACKUP_PLUGIN_TRUST_CENTER_BACKUP_CLEAR_IMPORT

/** @brief <b>plugin trust-center-backup file-export [path:-1] </b>
 *   - <i>Write the TC backup data to a file.</i>
 *     - path - OCTET_STRING
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TRUST_CENTER_BACKUP_PLUGIN_TRUST_CENTER_BACKUP_FILE_EXPORT

/** @brief <b>plugin trust-center-backup file-import [path:-1] </b>
 *   - <i>Read the TC Backup data from a file and bring the TC back online.</i>
 *     - path - OCTET_STRING
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TRUST_CENTER_BACKUP_PLUGIN_TRUST_CENTER_BACKUP_FILE_IMPORT

/** @brief <b>plugin trust-center-backup import-key [index:1] [partnerEUI64:8] [newKey:-1] </b>
 *   - <i>Set a key in the import data set.</i>
 *     - index - INT8U
 *     - partnerEUI64 - IEEE_ADDRESS
 *     - newKey - OCTET_STRING
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TRUST_CENTER_BACKUP_PLUGIN_TRUST_CENTER_BACKUP_IMPORT_KEY

/** @brief <b>plugin trust-center-backup print-export </b>
 *   - <i>Print the set of export data that a TC must backup.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TRUST_CENTER_BACKUP_PLUGIN_TRUST_CENTER_BACKUP_PRINT_EXPORT

/** @brief <b>plugin trust-center-backup print-import </b>
 *   - <i>Print the import data set.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TRUST_CENTER_BACKUP_PLUGIN_TRUST_CENTER_BACKUP_PRINT_IMPORT

/** @brief <b>plugin trust-center-backup restore </b>
 *   - <i>Use the import data set in a restore operation to bring the TC back online.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TRUST_CENTER_BACKUP_PLUGIN_TRUST_CENTER_BACKUP_RESTORE

/** @brief <b>plugin trust-center-backup set-ext-pan [extendedPanId:8] </b>
 *   - <i>Set the extended PAN ID in the import data set.</i>
 *     - extendedPanId - IEEE_ADDRESS
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_PLUGIN_TRUST_CENTER_BACKUP_PLUGIN_TRUST_CENTER_BACKUP_SET_EXT_PAN

/** @} */ // end group plugin-trust-center-backup

/** @addtogroup attribute Attribute Management
 * @ingroup cli
 * Commands related to reading and writing attributes locally on a device.
 * 
 * @{
 */

/** @} */ // end group attribute

/** @addtogroup build-send-msg Building and Sending Messages
 * @ingroup cli
 * Commands for building and sending messages out onto the network.
 * 
 * @{
 */

/** @} */ // end group build-send-msg

/** @addtogroup endpoint Endpoint Manipulation
 * @ingroup cli
 * Commands related to the manipulation of endpoints.
 * 
 * @{
 */

/** @} */ // end group endpoint

/** @addtogroup general General
 * @ingroup cli
 * General commands that are applicable to the node regardless of clusters or
 * plugins.
 * 
 * @{
 */

/** @} */ // end group general

/** @addtogroup zcl-global Global ZCL
 * @ingroup cli
 * All the ZCL global commands defined in the ZigBee Cluster Library
 * Specification. These command line commands can be used to send messages over
 * the air to, for instance, read and write attributes to devices on the
 * network.
 * 
 * @{
 */

/** @} */ // end group zcl-global

/** @addtogroup info Informational
 * @ingroup cli
 * The Informational command set provides commands for displaying information
 * about the device. These commands include things like printing out the
 * attribute tablerr
 * 
 * @{
 */

/** @} */ // end group info

/** @addtogroup network Network
 * @ingroup cli
 * The Network command set provides commands for interacting with the network.
 * This includes building as well as sending ZigBee commands out on to the
 * network.
 * 
 * @{
 */

/** @} */ // end group network

/** @addtogroup security Security
 * @ingroup cli
 * The Security command set includes all of the commands related to security
 * configuration on the device.
 * 
 * @{
 */

/** @} */ // end group security

/** @addtogroup test Test Harness
 * @ingroup cli
 * All commands related to the testing of a device.
 * 
 * @{
 */

/** @} */ // end group test

/** @addtogroup zdo ZigBee Device Object Commands (ZDO)
 * @ingroup cli
 * Commands related to the management of a ZigBee device including device
 * discovery and commissioning.
 * 
 * @{
 */

/** @} */ // end group zdo

/** @addtogroup basic Cluster Commands: Basic
 * @ingroup cli
 * This group describes the CLI commands for the Basic cluster. Listed below is
 * a description of the cluster:<br><br><i> Attributes for determining basic
 * information about a device, setting user device information such as location,
 * and enabling a device.</i>
 * 
 * @{
 */

/** @brief <b>zcl basic rtfd </b>
 *   - <i>Command that resets all attribute values to factory default.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BASIC_RTFD

/** @brief <b>zcl basic gls [startLocale:-1] [maxLocalesRequested:1] </b>
 *   - <i>This command gets locales supported.</i>
 *     - startLocale - CHAR_STRING
 *     - maxLocalesRequested - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BASIC_GLS

/** @brief <b>zcl basic glsr [discoveryComplete:1] [localeSupported:-1] </b>
 *   - <i>The locales supported response command is sent in response to a get locales supported command, and is used to discover which locales the device supports.</i>
 *     - discoveryComplete - INT8U
 *     - localeSupported - CHAR_STRING
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_BASIC_GLSR

/** @} */ // end group basic

/** @addtogroup color-control Cluster Commands: Color Control
 * @ingroup cli
 * This group describes the CLI commands for the Color Control cluster. Listed
 * below is a description of the cluster:<br><br><i> Attributes and commands for
 * controlling the color properties of a color-capable light.</i>
 * 
 * @{
 */

/** @brief <b>zcl color-control movetohue [hue:1] [direction:1] [transitionTime:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Move to specified hue.</i>
 *     - hue - INT8U
 *     - direction - HueDirection [ENUM8]
 *     - transitionTime - INT16U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 * @sa 
 * EmberAfHueDirection
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVETOHUE

/** @brief <b>zcl color-control movehue [moveMode:1] [rate:1] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Move hue up or down at specified rate.</i>
 *     - moveMode - HueMoveMode [ENUM8]
 *     - rate - INT8U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 * @sa 
 * EmberAfHueMoveMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVEHUE

/** @brief <b>zcl color-control stephue [stepMode:1] [stepSize:1] [transitionTime:1] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Step hue up or down by specified size at specified rate.</i>
 *     - stepMode - HueStepMode [ENUM8]
 *     - stepSize - INT8U
 *     - transitionTime - INT8U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 * @sa 
 * EmberAfHueStepMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_STEPHUE

/** @brief <b>zcl color-control movetosat [saturation:1] [transitionTime:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Move to specified saturation.</i>
 *     - saturation - INT8U
 *     - transitionTime - INT16U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVETOSAT

/** @brief <b>zcl color-control movesat [moveMode:1] [rate:1] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Move saturation up or down at specified rate.</i>
 *     - moveMode - SaturationMoveMode [ENUM8]
 *     - rate - INT8U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 * @sa 
 * EmberAfSaturationMoveMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVESAT

/** @brief <b>zcl color-control stepsat [stepMode:1] [stepSize:1] [transitionTime:1] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Step saturation up or down by specified size at specified rate.</i>
 *     - stepMode - SaturationStepMode [ENUM8]
 *     - stepSize - INT8U
 *     - transitionTime - INT8U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 * @sa 
 * EmberAfSaturationStepMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_STEPSAT

/** @brief <b>zcl color-control movetohueandsat [hue:1] [saturation:1] [transitionTime:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Move to hue and saturation.</i>
 *     - hue - INT8U
 *     - saturation - INT8U
 *     - transitionTime - INT16U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVETOHUEANDSAT

/** @brief <b>zcl color-control movetocolor [colorX:2] [colorY:2] [transitionTime:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Move to specified color.</i>
 *     - colorX - INT16U
 *     - colorY - INT16U
 *     - transitionTime - INT16U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVETOCOLOR

/** @brief <b>zcl color-control movecolor [rateX:2] [rateY:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Moves the color.</i>
 *     - rateX - INT16S
 *     - rateY - INT16S
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVECOLOR

/** @brief <b>zcl color-control stepcolor [stepX:2] [stepY:2] [transitionTime:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Steps the lighting to a specific color.</i>
 *     - stepX - INT16S
 *     - stepY - INT16S
 *     - transitionTime - INT16U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_STEPCOLOR

/** @brief <b>zcl color-control movetocolortemp [colorTemperature:2] [transitionTime:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Move to a specific color temperature.</i>
 *     - colorTemperature - INT16U
 *     - transitionTime - INT16U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVETOCOLORTEMP

/** @brief <b>zcl color-control emovetohue [enhancedHue:2] [direction:1] [transitionTime:2] </b>
 *   - <i>Command description for EnhancedMoveToHue</i>
 *     - enhancedHue - INT16U
 *     - direction - HueDirection [ENUM8]
 *     - transitionTime - INT16U
 * @sa 
 * EmberAfHueDirection
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_EMOVETOHUE

/** @brief <b>zcl color-control emovehue [moveMode:1] [rate:2] </b>
 *   - <i>Command description for EnhancedMoveHue</i>
 *     - moveMode - HueMoveMode [ENUM8]
 *     - rate - INT16U
 * @sa 
 * EmberAfHueMoveMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_EMOVEHUE

/** @brief <b>zcl color-control estephue [stepMode:1] [stepSize:2] [transitionTime:2] </b>
 *   - <i>Command description for EnhancedStepHue</i>
 *     - stepMode - HueStepMode [ENUM8]
 *     - stepSize - INT16U
 *     - transitionTime - INT16U
 * @sa 
 * EmberAfHueStepMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_ESTEPHUE

/** @brief <b>zcl color-control emovetohueandsat [enhancedHue:2] [saturation:1] [transitionTime:2] </b>
 *   - <i>Command description for EnhancedMoveToHueAndSaturation</i>
 *     - enhancedHue - INT16U
 *     - saturation - INT8U
 *     - transitionTime - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_EMOVETOHUEANDSAT

/** @brief <b>zcl color-control loop [updateFlags:1] [action:1] [direction:1] [time:2] [startHue:2] </b>
 *   - <i>Command description for ColorLoopSet</i>
 *     - updateFlags - ColorLoopUpdateFlags [BITMAP8]
 *     - action - ColorLoopAction [ENUM8]
 *     - direction - ColorLoopDirection [ENUM8]
 *     - time - INT16U
 *     - startHue - INT16U
 * @sa 
 * EmberAfColorLoopAction
 * EmberAfColorLoopDirection
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_LOOP

/** @brief <b>zcl color-control stopmovestep [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Command description for StopMoveStep</i>
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_STOPMOVESTEP

/** @brief <b>zcl color-control movecolortemp [moveMode:1] [rate:2] [colorTemperatureMinimum:2] [colorTemperatureMaximum:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Command description for MoveColorTemperature</i>
 *     - moveMode - HueMoveMode [ENUM8]
 *     - rate - INT16U
 *     - colorTemperatureMinimum - INT16U
 *     - colorTemperatureMaximum - INT16U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 * @sa 
 * EmberAfHueMoveMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_MOVECOLORTEMP

/** @brief <b>zcl color-control stepcolortemp [stepMode:1] [stepSize:2] [transitionTime:2] [colorTemperatureMinimum:2] [colorTemperatureMaximum:2] [optionsMask:1] [optionsOverride:1] </b>
 *   - <i>Command description for StepColorTemperature</i>
 *     - stepMode - HueStepMode [ENUM8]
 *     - stepSize - INT16U
 *     - transitionTime - INT16U
 *     - colorTemperatureMinimum - INT16U
 *     - colorTemperatureMaximum - INT16U
 *     - optionsMask - BITMAP8
 *     - optionsOverride - BITMAP8
 * @sa 
 * EmberAfHueStepMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_COLOR_CONTROL_STEPCOLORTEMP

/** @} */ // end group color-control

/** @addtogroup configuration-cluster Cluster Commands: Configuration Cluster
 * @ingroup cli
 * This group describes the CLI commands for the Configuration Cluster cluster.
 * Listed below is a description of the cluster:<br><br><i> This cluster allows
 * for the OTA configuration of firmware
	  parameters.</i>
 * 
 * @{
 */

/** @brief <b>zcl ota-config setToken [token:2] [data:-1] </b>
 *   - <i>Command to write a token value over the air.</i>
 *     - token - INT16U
 *     - data - OCTET_STRING
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_CONFIGURATION_CLUSTER_SET_TOKEN

/** @brief <b>zcl ota-config lock </b>
 *   - <i>Command to lock the token values.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_CONFIGURATION_CLUSTER_LOCK

/** @brief <b>zcl ota-config read [token:2] </b>
 *   - <i>Command to read a token value.</i>
 *     - token - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_CONFIGURATION_CLUSTER_READ

/** @brief <b>zcl ota-config unlock [data:-1] </b>
 *   - <i>Command to unlock tokens with a device-specific password (if allowed).</i>
 *     - data - OCTET_STRING
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_CONFIGURATION_CLUSTER_UNLOCK

/** @} */ // end group configuration-cluster

/** @addtogroup groups Cluster Commands: Groups
 * @ingroup cli
 * This group describes the CLI commands for the Groups cluster. Listed below is
 * a description of the cluster:<br><br><i> Attributes and commands for group
 * configuration and manipulation.</i>
 * 
 * @{
 */

/** @brief <b>zcl groups add [groupId:2] [groupName:-1] </b>
 *   - <i>Command description for AddGroup</i>
 *     - groupId - INT16U
 *     - groupName - CHAR_STRING
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GROUPS_ADD

/** @brief <b>zcl groups view [groupId:2] </b>
 *   - <i>Command description for ViewGroup</i>
 *     - groupId - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GROUPS_VIEW

/** @brief <b>zcl groups get [groupCount:1] [groupList:2] </b>
 *   - <i>Command description for GetGroupMembership</i>
 *     - groupCount - INT8U
 *     - groupList - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GROUPS_GET

/** @brief <b>zcl groups remove [groupId:2] </b>
 *   - <i>Command description for RemoveGroup</i>
 *     - groupId - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GROUPS_REMOVE

/** @brief <b>zcl groups rmall </b>
 *   - <i>Command description for RemoveAllGroups</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GROUPS_RMALL

/** @brief <b>zcl groups add-if-id [groupId:2] [groupName:-1] </b>
 *   - <i>Command description for AddGroupIfIdentifying</i>
 *     - groupId - INT16U
 *     - groupName - CHAR_STRING
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_GROUPS_ADD_IF_ID

/** @} */ // end group groups

/** @addtogroup ias-zone Cluster Commands: IAS Zone
 * @ingroup cli
 * This group describes the CLI commands for the IAS Zone cluster. Listed below
 * is a description of the cluster:<br><br><i> Attributes and commands for IAS
 * security zone devices.</i>
 * 
 * @{
 */

/** @brief <b>zcl ias-zone sc [zoneStatus:2] [extendedStatus:1] [zoneId:1] [delay:2] </b>
 *   - <i>Command description for zoneStatusChangeNotification</i>
 *     - zoneStatus - IasZoneStatus [BITMAP16]
 *     - extendedStatus - BITMAP8
 *     - zoneId - INT8U
 *     - delay - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_I_A_S_ZONE_SC

/** @brief <b>zcl ias-zone enroll [zoneType:2] [manufacturerCode:2] </b>
 *   - <i>Command description for zoneEnrollRequest</i>
 *     - zoneType - IasZoneType [ENUM16]
 *     - manufacturerCode - INT16U
 * @sa 
 * EmberAfIasZoneType
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_I_A_S_ZONE_ENROLL

/** @} */ // end group ias-zone

/** @addtogroup identify Cluster Commands: Identify
 * @ingroup cli
 * This group describes the CLI commands for the Identify cluster. Listed below
 * is a description of the cluster:<br><br><i> Attributes and commands for
 * putting a device into Identification mode (e.g. flashing a light).</i>
 * 
 * @{
 */

/** @brief <b>zcl identify id [identifyTime:2] </b>
 *   - <i>Command description for Identify</i>
 *     - identifyTime - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_IDENTIFY_ID

/** @brief <b>zcl identify query </b>
 *   - <i>Command description for IdentifyQuery</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_IDENTIFY_QUERY

/** @brief <b>zcl identify ez-mode [action:1] </b>
 *   - <i>Invoke EZMode on an Identify Server</i>
 *     - action - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_IDENTIFY_EZ_MODE

/** @brief <b>zcl identify trigger [effectId:1] [effectVariant:1] </b>
 *   - <i>Command description for TriggerEffect</i>
 *     - effectId - IdentifyEffectIdentifier [ENUM8]
 *     - effectVariant - IdentifyEffectVariant [ENUM8]
 * @sa 
 * EmberAfIdentifyEffectIdentifier
 * EmberAfIdentifyEffectVariant
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_IDENTIFY_TRIGGER

/** @} */ // end group identify

/** @addtogroup level-control Cluster Commands: Level Control
 * @ingroup cli
 * This group describes the CLI commands for the Level Control cluster. Listed
 * below is a description of the cluster:<br><br><i> Attributes and commands for
 * controlling devices that can be set to a level between fully 'On' and fully
 * 'Off.'</i>
 * 
 * @{
 */

/** @brief <b>zcl level-control mv-to-level [level:1] [transitionTime:2] [optionMask:1] [optionOverride:1] </b>
 *   - <i>Command description for MoveToLevel</i>
 *     - level - INT8U
 *     - transitionTime - INT16U
 *     - optionMask - BITMAP8
 *     - optionOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_LEVEL_CONTROL_MV_TO_LEVEL

/** @brief <b>zcl level-control move [moveMode:1] [rate:1] [optionMask:1] [optionOverride:1] </b>
 *   - <i>Command description for Move</i>
 *     - moveMode - MoveMode [ENUM8]
 *     - rate - INT8U
 *     - optionMask - BITMAP8
 *     - optionOverride - BITMAP8
 * @sa 
 * EmberAfMoveMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_LEVEL_CONTROL_MOVE

/** @brief <b>zcl level-control step [stepMode:1] [stepSize:1] [transitionTime:2] [optionMask:1] [optionOverride:1] </b>
 *   - <i>Command description for Step</i>
 *     - stepMode - StepMode [ENUM8]
 *     - stepSize - INT8U
 *     - transitionTime - INT16U
 *     - optionMask - BITMAP8
 *     - optionOverride - BITMAP8
 * @sa 
 * EmberAfStepMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_LEVEL_CONTROL_STEP

/** @brief <b>zcl level-control stop [optionMask:1] [optionOverride:1] </b>
 *   - <i>Command description for Stop</i>
 *     - optionMask - BITMAP8
 *     - optionOverride - BITMAP8
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_LEVEL_CONTROL_STOP

/** @brief <b>zcl level-control o-mv-to-level [level:1] [transitionTime:2] </b>
 *   - <i>Command description for MoveToLevelWithOnOff</i>
 *     - level - INT8U
 *     - transitionTime - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_LEVEL_CONTROL_O_MV_TO_LEVEL

/** @brief <b>zcl level-control o-move [moveMode:1] [rate:1] </b>
 *   - <i>Command description for MoveWithOnOff</i>
 *     - moveMode - MoveMode [ENUM8]
 *     - rate - INT8U
 * @sa 
 * EmberAfMoveMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_LEVEL_CONTROL_O_MOVE

/** @brief <b>zcl level-control o-step [stepMode:1] [stepSize:1] [transitionTime:2] </b>
 *   - <i>Command description for StepWithOnOff</i>
 *     - stepMode - StepMode [ENUM8]
 *     - stepSize - INT8U
 *     - transitionTime - INT16U
 * @sa 
 * EmberAfStepMode
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_LEVEL_CONTROL_O_STEP

/** @brief <b>zcl level-control o-stop </b>
 *   - <i>Command description for StopWithOnOff</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_LEVEL_CONTROL_O_STOP

/** @} */ // end group level-control

/** @addtogroup mfglib-cluster Cluster Commands: MFGLIB Cluster
 * @ingroup cli
 * This group describes the CLI commands for the MFGLIB Cluster cluster. Listed
 * below is a description of the cluster:<br><br><i> This cluster provides
 * commands to kick off MFGLIB actions 
	  over the air.</i>
 * 
 * @{
 */

/** @brief <b>zcl mfglib stream [channel:1] [power:1] [time:2] </b>
 *   - <i>Command to put the device into streaming mode.</i>
 *     - channel - INT8U
 *     - power - INT8S
 *     - time - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_M_F_G_L_I_B_CLUSTER_STREAM

/** @brief <b>zcl mfglib tone [channel:1] [power:1] [time:2] </b>
 *   - <i>Command to put the device into tone mode.</i>
 *     - channel - INT8U
 *     - power - INT8S
 *     - time - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_M_F_G_L_I_B_CLUSTER_TONE

/** @brief <b>zcl mfglib rx-mode [channel:1] [power:1] [time:2] </b>
 *   - <i>Command to put the device into RX mode.</i>
 *     - channel - INT8U
 *     - power - INT8S
 *     - time - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_M_F_G_L_I_B_CLUSTER_RX_MODE

/** @} */ // end group mfglib-cluster

/** @addtogroup on-off Cluster Commands: On/off
 * @ingroup cli
 * This group describes the CLI commands for the On/off cluster. Listed below is
 * a description of the cluster:<br><br><i> Attributes and commands for
 * switching devices between 'On' and 'Off' states.</i>
 * 
 * @{
 */

/** @brief <b>zcl on-off off </b>
 *   - <i>Command description for Off</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ON/OFF_OFF

/** @brief <b>zcl on-off on </b>
 *   - <i>Command description for On</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ON/OFF_ON

/** @brief <b>zcl on-off toggle </b>
 *   - <i>Command description for Toggle</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ON/OFF_TOGGLE

/** @brief <b>zcl on-off offeffect [effectId:1] [effectVariant:1] </b>
 *   - <i>Command description for OffWithEffect</i>
 *     - effectId - OnOffEffectIdentifier [ENUM8]
 *     - effectVariant - ENUM8
 * @sa 
 * EmberAfOnOffEffectIdentifier
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ON/OFF_OFFEFFECT

/** @brief <b>zcl on-off onrecall </b>
 *   - <i>Command description for OnWithRecallGlobalScene</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ON/OFF_ONRECALL

/** @brief <b>zcl on-off ontimedoff [onOffControl:1] [onTime:2] [offWaitTime:2] </b>
 *   - <i>Command description for OnWithTimedOff</i>
 *     - onOffControl - OnOffControl [BITMAP8]
 *     - onTime - INT16U
 *     - offWaitTime - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_ON/OFF_ONTIMEDOFF

/** @} */ // end group on-off

/** @addtogroup poll-control Cluster Commands: Poll Control
 * @ingroup cli
 * This group describes the CLI commands for the Poll Control cluster. Listed
 * below is a description of the cluster:<br><br><i> This cluster provides a
 * mechanism for the management of an end device's MAC Data Poll rate.  For the
 * purposes of this cluster, the term "poll" always refers to the sending of a
 * MAC Data Poll from the end device to the end device's parent.</i>
 * 
 * @{
 */

/** @brief <b>zcl poll-control stop </b>
 *   - <i>The Fast Poll Stop command is used to stop the fast poll mode initiated by the Check-in response.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_POLL_CONTROL_STOP

/** @brief <b>zcl poll-control long [newLongPollInterval:4] </b>
 *   - <i>The Set Long Poll Interval command is used to set the read only Long Poll Interval Attribute.</i>
 *     - newLongPollInterval - INT32U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_POLL_CONTROL_LONG

/** @brief <b>zcl poll-control short [newShortPollInterval:2] </b>
 *   - <i>The Set Short Poll Interval command is used to set the read only Short Poll Interval Attribute.</i>
 *     - newShortPollInterval - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_POLL_CONTROL_SHORT

/** @} */ // end group poll-control

/** @addtogroup scenes Cluster Commands: Scenes
 * @ingroup cli
 * This group describes the CLI commands for the Scenes cluster. Listed below is
 * a description of the cluster:<br><br><i> Attributes and commands for scene
 * configuration and manipulation.</i>
 * 
 * @{
 */

/** @brief <b>zcl scenes add [groupId:2] [sceneId:1] [transitionTime:2] [sceneName:-1] [extensionFieldSets:4] </b>
 *   - <i>Add a scene to the scene table. Extension field sets are supported, and are inputed as arrays of the form [[cluster ID] [length] [value0...n] ...]</i>
 *     - groupId - INT16U
 *     - sceneId - INT8U
 *     - transitionTime - INT16U
 *     - sceneName - CHAR_STRING
 *     - extensionFieldSets - struct SceneExtensionFieldSet
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_ADD

/** @brief <b>zcl scenes view [groupId:2] [sceneId:1] </b>
 *   - <i>Command description for ViewScene</i>
 *     - groupId - INT16U
 *     - sceneId - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_VIEW

/** @brief <b>zcl scenes remove [groupId:2] [sceneId:1] </b>
 *   - <i>Command description for RemoveScene</i>
 *     - groupId - INT16U
 *     - sceneId - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_REMOVE

/** @brief <b>zcl scenes rmall [groupId:2] </b>
 *   - <i>Command description for RemoveAllScenes</i>
 *     - groupId - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_RMALL

/** @brief <b>zcl scenes store [groupId:2] [sceneId:1] </b>
 *   - <i>Command description for StoreScene</i>
 *     - groupId - INT16U
 *     - sceneId - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_STORE

/** @brief <b>zcl scenes recall [groupId:2] [sceneId:1] </b>
 *   - <i>Command description for RecallScene</i>
 *     - groupId - INT16U
 *     - sceneId - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_RECALL

/** @brief <b>zcl scenes get [groupId:2] </b>
 *   - <i>Command description for GetSceneMembership</i>
 *     - groupId - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_GET

/** @brief <b>zcl scenes eadd [groupId:2] [sceneId:1] [transitionTime:2] [sceneName:-1] [extensionFieldSets:4] </b>
 *   - <i>Command description for EnhancedAddScene</i>
 *     - groupId - INT16U
 *     - sceneId - INT8U
 *     - transitionTime - INT16U
 *     - sceneName - CHAR_STRING
 *     - extensionFieldSets - struct SceneExtensionFieldSet
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_EADD

/** @brief <b>zcl scenes eview [groupId:2] [sceneId:1] </b>
 *   - <i>Command description for EnhancedViewScene</i>
 *     - groupId - INT16U
 *     - sceneId - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_EVIEW

/** @brief <b>zcl scenes copy [mode:1] [groupIdFrom:2] [sceneIdFrom:1] [groupIdTo:2] [sceneIdTo:1] </b>
 *   - <i>Command description for CopyScene</i>
 *     - mode - ScenesCopyMode [BITMAP8]
 *     - groupIdFrom - INT16U
 *     - sceneIdFrom - INT8U
 *     - groupIdTo - INT16U
 *     - sceneIdTo - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SCENES_COPY

/** @} */ // end group scenes

/** @addtogroup simple-metering Cluster Commands: Simple Metering
 * @ingroup cli
 * This group describes the CLI commands for the Simple Metering cluster. Listed
 * below is a description of the cluster:<br><br><i> The Metering Cluster
 * provides a mechanism to retrieve usage information from Electric, Gas, Water,
 * and potentially Thermal metering devices.</i>
 * 
 * @{
 */

/** @brief <b>zcl metering request-mirror </b>
 *   - <i>This command is used to request the ESI to mirror Metering Device data.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_REQUEST_MIRROR

/** @brief <b>zcl metering remove-mirror </b>
 *   - <i>This command is used to request the ESI to remove its mirror of Metering Device data.</i>
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_REMOVE_MIRROR

/** @brief <b>zcl metering sch-snapshot-resp [issuerEventId:4] [snapshotResponsePayload:2] </b>
 *   - <i>This command is generated in response to a ScheduleSnapshot command, and is sent to confirm whether the requested snapshot schedule has been set up.</i>
 *     - issuerEventId - INT32U
 *     - snapshotResponsePayload - struct SnapshotResponsePayload
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_SCH_SNAPSHOT_RESP

/** @brief <b>zcl metering take-snapshot-resp [snapshotId:4] [snapshotConfirmation:1] </b>
 *   - <i>This command is generated in response to a TakeSnapshot command, and is sent to confirm whether the requested snapshot has been accepted and successfully taken.</i>
 *     - snapshotId - INT32U
 *     - snapshotConfirmation - SnapshotConfirmation [ENUM8]
 * @sa 
 * EmberAfSnapshotConfirmation
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_TAKE_SNAPSHOT_RESP

/** @brief <b>zcl metering pub-ss [snapshotId:4] [snapshotTime:4] [totalSnapshotsFound:1] [commandIndex:1] [totalCommands:1] [snapshotCause:4] [snapshotPayloadType:1] [snapshotPayload:1] </b>
 *   - <i>This command is generated in response to a GetSnapshot command. It is used to return a single snapshot to the client.</i>
 *     - snapshotId - INT32U
 *     - snapshotTime - UTC_TIME
 *     - totalSnapshotsFound - INT8U
 *     - commandIndex - INT8U
 *     - totalCommands - INT8U
 *     - snapshotCause - SnapshotCause [BITMAP32]
 *     - snapshotPayloadType - SnapshotPayloadType [ENUM8]
 *     - snapshotPayload - INT8U
 * @sa 
 * EmberAfSnapshotPayloadType
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_PUB_SS

/** @brief <b>zcl metering cfg-mirror [issuerEventId:4] [reportingInterval:3] [mirrorNotificationReporting:1] [notificationScheme:1] </b>
 *   - <i>ConfigureMirror is sent to the mirror once the mirror has been created. The command deals with the operational configuration of the Mirror.</i>
 *     - issuerEventId - INT32U
 *     - reportingInterval - INT24U
 *     - mirrorNotificationReporting - BOOLEAN
 *     - notificationScheme - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_CFG_MIRROR

/** @brief <b>zcl metering cfg-nft-scheme [issuerEventId:4] [notificationScheme:1] [notificationFlagOrder:4] </b>
 *   - <i>The ConfigureNotificationScheme is sent to the mirror once the mirror has been created. The command deals with the operational configuration of the Mirror and the device that reports to the mirror. No default schemes are allowed to be overwritten.</i>
 *     - issuerEventId - INT32U
 *     - notificationScheme - INT8U
 *     - notificationFlagOrder - BITMAP32
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_CFG_NFT_SCHEME

/** @brief <b>zcl metering cfg-nft-flags [issuerEventId:4] [notificationScheme:1] [notificationFlagAttributeId:2] [clusterId:2] [manufacturerCode:2] [numberOfCommands:1] [commandIds:1] </b>
 *   - <i>The ConfigureNotificationFlags command is used to set the commands relating to the bit value for each NotificationFlags attribute that the scheme is proposing to use.</i>
 *     - issuerEventId - INT32U
 *     - notificationScheme - INT8U
 *     - notificationFlagAttributeId - INT16U
 *     - clusterId - INT16U
 *     - manufacturerCode - INT16U
 *     - numberOfCommands - INT8U
 *     - commandIds - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_CFG_NFT_FLAGS

/** @brief <b>zcl metering get-ntfy-msg [notificationScheme:1] [notificationFlagAttributeId:2] [notificationFlagsN:4] </b>
 *   - <i>The GetNotifiedMessage command is used only when a BOMD is being mirrored. This command provides a method for the BOMD to notify the Mirror message queue that it wants to receive commands that the Mirror has queued. The Notification flags set within the command shall inform the mirror of the commands that the BOMD is requesting.</i>
 *     - notificationScheme - INT8U
 *     - notificationFlagAttributeId - INT16U
 *     - notificationFlagsN - BITMAP32
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_GET_NTFY_MSG

/** @brief <b>zcl metering sup-stat-rsp [providerId:4] [issuerEventId:4] [implementationDateTime:4] [supplyStatus:1] </b>
 *   - <i>This command is transmitted by a Metering Device in response to a ChangeSupply command.</i>
 *     - providerId - INT32U
 *     - issuerEventId - INT32U
 *     - implementationDateTime - UTC_TIME
 *     - supplyStatus - MeteringSupplyStatus [ENUM8]
 * @sa 
 * EmberAfMeteringSupplyStatus
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_SUP_STAT_RSP

/** @brief <b>zcl metering start-samp-rsp [sampleId:2] </b>
 *   - <i>This command is transmitted by a Metering Device in response to a StartSampling command.</i>
 *     - sampleId - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_START_SAMP_RSP

/** @brief <b>zcl metering get-profile [intervalChannel:1] [endTime:4] [numberOfPeriods:1] </b>
 *   - <i>The GetProfile command is generated when a client device wishes to retrieve a list of captured Energy, Gas or water consumption for profiling purposes.</i>
 *     - intervalChannel - AmiIntervalChannel [ENUM8]
 *     - endTime - UTC_TIME
 *     - numberOfPeriods - INT8U
 * @sa 
 * EmberAfAmiIntervalChannel
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_GET_PROFILE

/** @brief <b>zcl metering mirror-removed [endpointId:2] </b>
 *   - <i>The Mirror Removed Command allows the ESI to inform a sleepy Metering Device mirroring support has been removed or halted.</i>
 *     - endpointId - INT16U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_MIRROR_REMOVED

/** @brief <b>zcl metering req-fast-poll-mode [fastPollUpdatePeriod:1] [duration:1] </b>
 *   - <i>The Request Fast Poll Mode command is generated when the metering client wishes to receive near real-time updates of InstantaneousDemand.</i>
 *     - fastPollUpdatePeriod - INT8U
 *     - duration - INT8U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_REQ_FAST_POLL_MODE

/** @brief <b>zcl metering sch-snapshot [issuerEventId:4] [commandIndex:1] [commandCount:1] [snapshotSchedulePayload:13] </b>
 *   - <i>This command is used to set up a schedule of when the device shall create snapshot data.</i>
 *     - issuerEventId - INT32U
 *     - commandIndex - INT8U
 *     - commandCount - INT8U
 *     - snapshotSchedulePayload - struct SnapshotSchedulePayload
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_SCH_SNAPSHOT

/** @brief <b>zcl metering take-snapshot [snapshotCause:4] </b>
 *   - <i>This command is used to instruct the cluster server to take a single snapshot.</i>
 *     - snapshotCause - SnapshotCause [BITMAP32]
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_TAKE_SNAPSHOT

/** @brief <b>zcl metering get-snapshot [earliestStartTime:4] [latestEndTime:4] [snapshotOffset:1] [snapshotCause:4] </b>
 *   - <i>This command is used to request snapshot data from the cluster server.</i>
 *     - earliestStartTime - UTC_TIME
 *     - latestEndTime - UTC_TIME
 *     - snapshotOffset - INT8U
 *     - snapshotCause - SnapshotCause [BITMAP32]
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_GET_SNAPSHOT

/** @brief <b>zcl metering start-sampling [issuerEventId:4] [startSamplingTime:4] [sampleType:1] [sampleRequestInterval:2] [maxNumberOfSamples:2] </b>
 *   - <i>The sampling mechanism allows a set of samples of the specified type of data to be taken, commencing at the stipulated start time. This mechanism may run concurrently with the capturing of profile data, and may refer the same parameters, albeit possibly at a different sampling rate.</i>
 *     - issuerEventId - INT32U
 *     - startSamplingTime - UTC_TIME
 *     - sampleType - SampleType [ENUM8]
 *     - sampleRequestInterval - INT16U
 *     - maxNumberOfSamples - INT16U
 * @sa 
 * EmberAfSampleType
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_START_SAMPLING

/** @brief <b>zcl metering get-sampled-data [sampleId:2] [earliestSampleTime:4] [sampleType:1] [numberOfSamples:2] </b>
 *   - <i>This command is used to request sampled data from the server. Note that it is the responsibility of the client to ensure that it does not request more samples than can be held in a single command payload.</i>
 *     - sampleId - INT16U
 *     - earliestSampleTime - UTC_TIME
 *     - sampleType - SampleType [ENUM8]
 *     - numberOfSamples - INT16U
 * @sa 
 * EmberAfSampleType
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_GET_SAMPLED_DATA

/** @brief <b>zcl metering rst-load-limit-ctr [providerId:4] [issuerEventId:4] </b>
 *   - <i>The ResetLoadLimitCounter command shall cause the LoadLimitCounter attribute to be reset.</i>
 *     - providerId - INT32U
 *     - issuerEventId - INT32U
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_RST_LOAD_LIMIT_CTR

/** @brief <b>zcl metering chg-supply [providerId:4] [issuerEventId:4] [requestDateTime:4] [implementationDateTime:4] [proposedSupplyStatus:1] [supplyControlBits:1] </b>
 *   - <i>This command is sent from the Head-end or ESI to the Metering Device to instruct it to change the status of the valve or load switch, i.e. the supply.</i>
 *     - providerId - INT32U
 *     - issuerEventId - INT32U
 *     - requestDateTime - UTC_TIME
 *     - implementationDateTime - UTC_TIME
 *     - proposedSupplyStatus - MeteringSupplyStatus [ENUM8]
 *     - supplyControlBits - SupplyControlBits [BITMAP8]
 * @sa 
 * EmberAfMeteringSupplyStatus
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_CHG_SUPPLY

/** @brief <b>zcl metering local-chg-supply [proposedSupplyStatus:1] </b>
 *   - <i>This command is a simplified version of the ChangeSupply command, intended to be sent from an IHD to a meter as the consequence of a user action on the IHD. Its purpose is to provide a local disconnection/reconnection button on the IHD in addition to the one on the meter.</i>
 *     - proposedSupplyStatus - ProposedSupplyStatus [ENUM8]
 * @sa 
 * EmberAfProposedSupplyStatus
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_LOCAL_CHG_SUPPLY

/** @brief <b>zcl metering set-supply-status [issuerEventId:4] [supplyTamperState:1] [supplyDepletionState:1] [supplyUncontrolledFlowState:1] [loadLimitSupplyState:1] </b>
 *   - <i>This command is used to specify the required status of the supply following the occurance of certain events on the meter.</i>
 *     - issuerEventId - INT32U
 *     - supplyTamperState - SupplyStatus [ENUM8]
 *     - supplyDepletionState - SupplyStatus [ENUM8]
 *     - supplyUncontrolledFlowState - SupplyStatus [ENUM8]
 *     - loadLimitSupplyState - SupplyStatus [ENUM8]
 * @sa 
 * EmberAfSupplyStatus
 * EmberAfSupplyStatus
 * EmberAfSupplyStatus
 * EmberAfSupplyStatus
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_SET_SUPPLY_STATUS

/** @brief <b>zcl metering set-uncntrl-flow-threshold [providerId:4] [issuerEventId:4] [uncontrolledFlowThreshold:2] [unitOfMeasure:1] [multiplier:2] [divisor:2] [stabilisationPeriod:1] [measurementPeriod:2] </b>
 *   - <i>This command is used to update the 'Uncontrolled Flow Rate' configuration data used by flow meters.</i>
 *     - providerId - INT32U
 *     - issuerEventId - INT32U
 *     - uncontrolledFlowThreshold - INT16U
 *     - unitOfMeasure - AmiUnitOfMeasure [ENUM8]
 *     - multiplier - INT16U
 *     - divisor - INT16U
 *     - stabilisationPeriod - INT8U
 *     - measurementPeriod - INT16U
 * @sa 
 * EmberAfAmiUnitOfMeasure
 */
#define EMBER_AF_DOXYGEN_CLI_COMMAND_SIMPLE_METERING_SET_UNCNTRL_FLOW_THRESHOLD

/** @} */ // end group simple-metering

/** @addtogroup plugin-address-table Plugin Commands: Address Table
 * @ingroup cli
 * This plugin provides a set of APIs and CLI commands for managing the address
 * table
 * 
 * @{
 */

/** @} */ // end group plugin-address-table

/** @addtogroup plugin-button-joining Plugin Commands: Button Joining
 * @ingroup cli
 * The Button Joining plugin contributes CLI commands to simulate button presses
 * for the purposes of joining networks.
 * 
 * @{
 */

/** @} */ // end group plugin-button-joining

/** @addtogroup plugin-command-relay Plugin Commands: Command Relay
 * @ingroup cli
 * The command relay plugin allows the forwarding of commands from one device to
 * another.
 * 
 * @{
 */

/** @} */ // end group plugin-command-relay

/** @addtogroup plugin-concentrator Plugin Commands: Concentrator
 * @ingroup cli
 * The Concentrator plugin contributes several CLI commands to the application
 * framework for controlling the sending of MTORRs.
 * 
 * @{
 */

/** @} */ // end group plugin-concentrator

/** @addtogroup plugin-counters Plugin Commands: Counters
 * @ingroup cli
 * This plugin provides APIs and CLI commands for reading and manipulating
 * counters that record different events in the stack.
 * 
 * @{
 */

/** @} */ // end group plugin-counters

/** @addtogroup plugin-device-table Plugin Commands: Device Table
 * @ingroup cli
 * The device table plugin demonstrates tracking devices as they join the
	 
 * gateway's ZigBee network.
 * 
 * @{
 */

/** @} */ // end group plugin-device-table

/** @addtogroup plugin-ezmode-commissioning Plugin Commands: EZ-Mode Commissioning
 * @ingroup cli
 * The EZ-Mode Commissioning plugin contributes several commands to the
 * application framework's CLI.
 * 
 * @{
 */

/** @} */ // end group plugin-ezmode-commissioning

/** @addtogroup plugin-gateway Plugin Commands: Gateway Support
 * @ingroup cli
 * The gateway support commands provide functionality specific to running a PC
 * host application connected to an Ember chip via EZSP.
 * 
 * @{
 */

/** @} */ // end group plugin-gateway

/** @addtogroup plugin-green-power-client Plugin Commands: Green Power Client
 * @ingroup cli
 * The Green Power Client plugin contributes CLI commands to the application
 * framework to be used for getting, setting, and displaying information
 * relevant to the Green Power Client cluster.
 * 
 * @{
 */

/** @} */ // end group plugin-green-power-client

/** @addtogroup plugin-ias-zone-client Plugin Commands: IAS Zone Client
 * @ingroup cli
 * This plugin provides a set of CLI commands for managing the servers known to
 * the IAS Zone client.
 * 
 * @{
 */

/** @} */ // end group plugin-ias-zone-client

/** @addtogroup plugin-identify Plugin Commands: Identify
 * @ingroup cli
 * The identify plugin contributes a CLI command to the application framework to
 * be used for printing information related to identification.
 * 
 * @{
 */

/** @} */ // end group plugin-identify

/** @addtogroup plugin-network-creator Plugin Commands: Network Creator
 * @ingroup cli
 * Commands pertaining to network creation with the Network Creator plugin.
 * 
 * @{
 */

/** @} */ // end group plugin-network-creator

/** @addtogroup plugin-network-creator-security Plugin Commands: Network Creator Security
 * @ingroup cli
 * Commands pertaining to network creation with the Network Creator plugin.
 * 
 * @{
 */

/** @} */ // end group plugin-network-creator-security

/** @addtogroup plugin-ota-server Plugin Commands: OTA Server
 * @ingroup cli
 * The OTA Server plugin provides Over-the-air commands for upgrading firmware
 * and downloading specific files on the server side.
 * 
 * @{
 */

/** @} */ // end group plugin-ota-server

/** @addtogroup plugin-ota-storage-common Plugin Commands: OTA Storage Common
 * @ingroup cli
 * The OTA Storage Common plugin provides Over-the-air commands for upgrading
 * firmware and 
      downloading specific files common to both server and
 * client.
 * 
 * @{
 */

/** @} */ // end group plugin-ota-storage-common

/** @addtogroup plugin-poll-control-client Plugin Commands: Poll Control Client
 * @ingroup cli
 * The poll-control-client plugin contributes CLI commands to the application
 * framework to be used for setting poll control parameters in a local, client
 * context.
 * 
 * @{
 */

/** @} */ // end group plugin-poll-control-client

/** @addtogroup plugin-reporting Plugin Commands: Reporting
 * @ingroup cli
 * The reporting plugin contributes several CLI commands to the application
 * framework to be used in creating and managing reporting table entries
 * directly on the device.
 * 
 * @{
 */

/** @} */ // end group plugin-reporting

/** @addtogroup plugin-simple-metering-client Plugin Commands: Simple Metering Client
 * @ingroup cli
 * The simple-metering-client plugin contributes CLI commands to the application
 * framework to be used in conjunction with the Simple Metering cluster in a
 * client context.
 * 
 * @{
 */

/** @} */ // end group plugin-simple-metering-client

/** @addtogroup plugin-stack-diagnostics Plugin Commands: Stack Diagnostics
 * @ingroup cli
 * These commands give more information about the status of the status of the
 * stack, such as routing tables, neighbor tables, and child tables.
 * 
 * @{
 */

/** @} */ // end group plugin-stack-diagnostics

/** @addtogroup plugin-test-harness Plugin Commands: Test Harness
 * @ingroup cli
 * The test harness commands are used to test various unusual functionality or
 * behavior of a remote device.
 * 
 * @{
 */

/** @} */ // end group plugin-test-harness

/** @addtogroup plugin-trust-center-backup Plugin Commands: Trust Center Backup
 * @ingroup cli
 * The Trust Center Backup plugin contributes several CLI commands to the
 * application framework to be used in creating and managing reporting table
 * entries directly on the device.
 * 
 * @{
 */

/** @} */ // end group plugin-trust-center-backup


/** @} END addtogroup */
#endif // SILABS_EMBER_AF_CLI
