// *******************************************************************
// * ota-server-policy.h
// *
// * A sample policy file that implements the callbacks for the
// * Zigbee Over-the-air bootload cluster server.
// *
// * Copyright 2010 by Ember Corporation. All rights reserved.              *80*
// *******************************************************************

void emAfOtaServerPolicyPrint(void);

void emAfOtaServerSetQueryPolicy(uint8_t value);
void emAfOtaServerSetBlockRequestPolicy(uint8_t value);
void emAfOtaServerSetUpgradePolicy(uint8_t value);

bool emAfServerPageRequestTickCallback(uint16_t relativeOffset, uint8_t blockSize);
void emAfSetPageRequestMissedBlockModulus(uint16_t modulus);
void emAfOtaServerSetPageRequestPolicy(uint8_t value);
void emAfOtaServerPolicySetMinBlockRequestPeriod(uint16_t minBlockRequestPeriodMS);
uint8_t emberAfOtaServerImageBlockRequestCallback(EmberAfImageBlockRequestCallbackStruct* data);

// Callbacks

#define OTA_SERVER_NO_RATE_LIMITING_FOR_CLIENT          0
#define OTA_SERVER_CLIENT_USES_MILLISECONDS             1
#define OTA_SERVER_CLIENT_USES_SECONDS                  2
#define OTA_SERVER_DISCOVER_CLIENT_DELAY_UNITS          3
#ifdef EMBER_TEST
 #define OTA_SERVER_DO_NOT_OVERRIDE_CLIENT_DELAY_UNITS  0xFF
#endif

uint8_t emberAfPluginOtaServerPolicyGetClientDelayUnits(EmberNodeId clientNodeId,
                                                        EmberEUI64 clientEui64);
