/***************************************************************************//**
 * @file com_vcom.h
 * @brief VCOM configuration override for COM peripherals
 * @version 0.1.0
 *******************************************************************************
 * @section License
 * <b>Copyright 2017 Silicon Laboratories, Inc, www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#if !defined(COM_VCOM_H)
#define COM_VCOM_H

#if BSP_SERIAL_APP_PORT == HAL_SERIAL_PORT_VUART
// do nothing
#elif BSP_SERIAL_APP_PORT == HAL_SERIAL_PORT_USART0
#undef BSP_USART0_CTS_PIN
#undef BSP_USART0_CTS_PORT
#undef BSP_USART0_RTS_PIN
#undef BSP_USART0_RTS_PORT
#undef BSP_USART0_RX_PIN
#undef BSP_USART0_RX_PORT
#undef BSP_USART0_TX_PIN
#undef BSP_USART0_TX_PORT
#define BSP_USART0_CTS_PIN     BSP_SERIAL_APP_CTS_PIN
#define BSP_USART0_CTS_PORT    BSP_SERIAL_APP_CTS_PORT
#define BSP_USART0_RTS_PIN     BSP_SERIAL_APP_RTS_PIN
#define BSP_USART0_RTS_PORT    BSP_SERIAL_APP_RTS_PORT
#define BSP_USART0_RX_PIN      BSP_SERIAL_APP_RX_PIN
#define BSP_USART0_RX_PORT     BSP_SERIAL_APP_RX_PORT
#define BSP_USART0_TX_PIN      BSP_SERIAL_APP_TX_PIN
#define BSP_USART0_TX_PORT     BSP_SERIAL_APP_TX_PORT
#if defined(_USART_ROUTELOC0_MASK)
  #undef BSP_USART0_CTS_LOC
  #undef BSP_USART0_RTS_LOC
  #undef BSP_USART0_RX_LOC
  #undef BSP_USART0_TX_LOC
  #define BSP_USART0_CTS_LOC     BSP_SERIAL_APP_CTS_LOC
  #define BSP_USART0_RTS_LOC     BSP_SERIAL_APP_RTS_LOC
  #define BSP_USART0_RX_LOC      BSP_SERIAL_APP_RX_LOC
  #define BSP_USART0_TX_LOC      BSP_SERIAL_APP_TX_LOC
#else
  #undef BSP_USART0_ROUTE_LOC
  #define BSP_USART0_ROUTE_LOC   BSP_SERIAL_APP_ROUTE_LOC
#endif
#undef HAL_USART0_BAUD_RATE
#undef HAL_USART0_FLOW_CONTROL
#undef HAL_USART0_RX_QUEUE_SIZE
#undef HAL_USART0_RXSTART
#undef HAL_USART0_RXSTOP
#undef HAL_USART0_TX_QUEUE_SIZE
#define HAL_USART0_BAUD_RATE      HAL_SERIAL_APP_BAUD_RATE
#define HAL_USART0_FLOW_CONTROL   HAL_SERIAL_APP_FLOW_CONTROL
#define HAL_USART0_RX_QUEUE_SIZE  HAL_SERIAL_APP_RX_QUEUE_SIZE
#define HAL_USART0_RXSTART        HAL_SERIAL_APP_RXSTART
#define HAL_USART0_RXSTOP         HAL_SERIAL_APP_RXSTOP
#define HAL_USART0_TX_QUEUE_SIZE  HAL_SERIAL_APP_TX_QUEUE_SIZE
#elif BSP_SERIAL_APP_PORT == HAL_SERIAL_PORT_USART1
#undef BSP_USART1_CTS_PIN
#undef BSP_USART1_CTS_PORT
#undef BSP_USART1_RTS_PIN
#undef BSP_USART1_RTS_PORT
#undef BSP_USART1_RX_PIN
#undef BSP_USART1_RX_PORT
#undef BSP_USART1_TX_PIN
#undef BSP_USART1_TX_PORT
#define BSP_USART1_CTS_PIN     BSP_SERIAL_APP_CTS_PIN
#define BSP_USART1_CTS_PORT    BSP_SERIAL_APP_CTS_PORT
#define BSP_USART1_RTS_PIN     BSP_SERIAL_APP_RTS_PIN
#define BSP_USART1_RTS_PORT    BSP_SERIAL_APP_RTS_PORT
#define BSP_USART1_RX_PIN      BSP_SERIAL_APP_RX_PIN
#define BSP_USART1_RX_PORT     BSP_SERIAL_APP_RX_PORT
#define BSP_USART1_TX_PIN      BSP_SERIAL_APP_TX_PIN
#define BSP_USART1_TX_PORT     BSP_SERIAL_APP_TX_PORT
#if defined(_USART_ROUTELOC0_MASK)
  #undef BSP_USART1_CTS_LOC
  #undef BSP_USART1_RTS_LOC
  #undef BSP_USART1_RX_LOC
  #undef BSP_USART1_TX_LOC
  #define BSP_USART1_CTS_LOC     BSP_SERIAL_APP_CTS_LOC
  #define BSP_USART1_RTS_LOC     BSP_SERIAL_APP_RTS_LOC
  #define BSP_USART1_RX_LOC      BSP_SERIAL_APP_RX_LOC
  #define BSP_USART1_TX_LOC      BSP_SERIAL_APP_TX_LOC
#else
  #undef BSP_USART1_ROUTE_LOC
  #define BSP_USART1_ROUTE_LOC   BSP_SERIAL_APP_ROUTE_LOC
#endif
#undef HAL_USART1_BAUD_RATE
#undef HAL_USART1_FLOW_CONTROL
#undef HAL_USART1_RX_QUEUE_SIZE
#undef HAL_USART1_RXSTART
#undef HAL_USART1_RXSTOP
#undef HAL_USART1_TX_QUEUE_SIZE
#define HAL_USART1_BAUD_RATE      HAL_SERIAL_APP_BAUD_RATE
#define HAL_USART1_FLOW_CONTROL   HAL_SERIAL_APP_FLOW_CONTROL
#define HAL_USART1_RX_QUEUE_SIZE  HAL_SERIAL_APP_RX_QUEUE_SIZE
#define HAL_USART1_RXSTART        HAL_SERIAL_APP_RXSTART
#define HAL_USART1_RXSTOP         HAL_SERIAL_APP_RXSTOP
#define HAL_USART1_TX_QUEUE_SIZE  HAL_SERIAL_APP_TX_QUEUE_SIZE
#elif BSP_SERIAL_APP_PORT == HAL_SERIAL_PORT_USART2
#undef BSP_USART2_CTS_PIN
#undef BSP_USART2_CTS_PORT
#undef BSP_USART2_RTS_PIN
#undef BSP_USART2_RTS_PORT
#undef BSP_USART2_RX_PIN
#undef BSP_USART2_RX_PORT
#undef BSP_USART2_TX_PIN
#undef BSP_USART2_TX_PORT
#define BSP_USART2_CTS_PIN     BSP_SERIAL_APP_CTS_PIN
#define BSP_USART2_CTS_PORT    BSP_SERIAL_APP_CTS_PORT
#define BSP_USART2_RTS_PIN     BSP_SERIAL_APP_RTS_PIN
#define BSP_USART2_RTS_PORT    BSP_SERIAL_APP_RTS_PORT
#define BSP_USART2_RX_PIN      BSP_SERIAL_APP_RX_PIN
#define BSP_USART2_RX_PORT     BSP_SERIAL_APP_RX_PORT
#define BSP_USART2_TX_PIN      BSP_SERIAL_APP_TX_PIN
#define BSP_USART2_TX_PORT     BSP_SERIAL_APP_TX_PORT
#if defined(_USART_ROUTELOC0_MASK)
  #undef BSP_USART2_CTS_LOC
  #undef BSP_USART2_RTS_LOC
  #undef BSP_USART2_RX_LOC
  #undef BSP_USART2_TX_LOC
  #define BSP_USART2_CTS_LOC     BSP_SERIAL_APP_CTS_LOC
  #define BSP_USART2_RTS_LOC     BSP_SERIAL_APP_RTS_LOC
  #define BSP_USART2_RX_LOC      BSP_SERIAL_APP_RX_LOC
  #define BSP_USART2_TX_LOC      BSP_SERIAL_APP_TX_LOC
#else
  #undef BSP_USART2_ROUTE_LOC
  #define BSP_USART2_ROUTE_LOC   BSP_SERIAL_APP_ROUTE_LOC
#endif
#undef HAL_USART2_BAUD_RATE
#undef HAL_USART2_FLOW_CONTROL
#undef HAL_USART2_RX_QUEUE_SIZE
#undef HAL_USART2_RXSTART
#undef HAL_USART2_RXSTOP
#undef HAL_USART2_TX_QUEUE_SIZE
#define HAL_USART2_BAUD_RATE      HAL_SERIAL_APP_BAUD_RATE
#define HAL_USART2_FLOW_CONTROL   HAL_SERIAL_APP_FLOW_CONTROL
#define HAL_USART2_RX_QUEUE_SIZE  HAL_SERIAL_APP_RX_QUEUE_SIZE
#define HAL_USART2_RXSTART        HAL_SERIAL_APP_RXSTART
#define HAL_USART2_RXSTOP         HAL_SERIAL_APP_RXSTOP
#define HAL_USART2_TX_QUEUE_SIZE  HAL_SERIAL_APP_TX_QUEUE_SIZE
#elif BSP_SERIAL_APP_PORT == HAL_SERIAL_PORT_USART3
#undef BSP_USART3_CTS_PIN
#undef BSP_USART3_CTS_PORT
#undef BSP_USART3_RTS_PIN
#undef BSP_USART3_RTS_PORT
#undef BSP_USART3_RX_PIN
#undef BSP_USART3_RX_PORT
#undef BSP_USART3_TX_PIN
#undef BSP_USART3_TX_PORT
#define BSP_USART3_CTS_PIN     BSP_SERIAL_APP_CTS_PIN
#define BSP_USART3_CTS_PORT    BSP_SERIAL_APP_CTS_PORT
#define BSP_USART3_RTS_PIN     BSP_SERIAL_APP_RTS_PIN
#define BSP_USART3_RTS_PORT    BSP_SERIAL_APP_RTS_PORT
#define BSP_USART3_RX_PIN      BSP_SERIAL_APP_RX_PIN
#define BSP_USART3_RX_PORT     BSP_SERIAL_APP_RX_PORT
#define BSP_USART3_TX_PIN      BSP_SERIAL_APP_TX_PIN
#define BSP_USART3_TX_PORT     BSP_SERIAL_APP_TX_PORT
#if defined(_USART_ROUTELOC0_MASK)
  #undef BSP_USART3_CTS_LOC
  #undef BSP_USART3_RTS_LOC
  #undef BSP_USART3_RX_LOC
  #undef BSP_USART3_TX_LOC
  #define BSP_USART3_CTS_LOC     BSP_SERIAL_APP_CTS_LOC
  #define BSP_USART3_RTS_LOC     BSP_SERIAL_APP_RTS_LOC
  #define BSP_USART3_RX_LOC      BSP_SERIAL_APP_RX_LOC
  #define BSP_USART3_TX_LOC      BSP_SERIAL_APP_TX_LOC
#else
  #undef BSP_USART3_ROUTE_LOC
  #define BSP_USART3_ROUTE_LOC   BSP_SERIAL_APP_ROUTE_LOC
#endif
#undef HAL_USART3_BAUD_RATE
#undef HAL_USART3_FLOW_CONTROL
#undef HAL_USART3_RX_QUEUE_SIZE
#undef HAL_USART3_RXSTART
#undef HAL_USART3_RXSTOP
#undef HAL_USART3_TX_QUEUE_SIZE
#define HAL_USART3_BAUD_RATE      HAL_SERIAL_APP_BAUD_RATE
#define HAL_USART3_FLOW_CONTROL   HAL_SERIAL_APP_FLOW_CONTROL
#define HAL_USART3_RX_QUEUE_SIZE  HAL_SERIAL_APP_RX_QUEUE_SIZE
#define HAL_USART3_RXSTART        HAL_SERIAL_APP_RXSTART
#define HAL_USART3_RXSTOP         HAL_SERIAL_APP_RXSTOP
#define HAL_USART3_TX_QUEUE_SIZE  HAL_SERIAL_APP_TX_QUEUE_SIZE
#elif BSP_SERIAL_APP_PORT == HAL_SERIAL_PORT_LEUART0
#undef BSP_LEUART0_CTS_PIN
#undef BSP_LEUART0_CTS_PORT
#undef BSP_LEUART0_RTS_PIN
#undef BSP_LEUART0_RTS_PORT
#undef BSP_LEUART0_RX_PIN
#undef BSP_LEUART0_RX_PORT
#undef BSP_LEUART0_TX_PIN
#undef BSP_LEUART0_TX_PORT
#define BSP_LEUART0_CTS_PIN     BSP_SERIAL_APP_CTS_PIN
#define BSP_LEUART0_CTS_PORT    BSP_SERIAL_APP_CTS_PORT
#define BSP_LEUART0_RTS_PIN     BSP_SERIAL_APP_RTS_PIN
#define BSP_LEUART0_RTS_PORT    BSP_SERIAL_APP_RTS_PORT
#define BSP_LEUART0_RX_PIN      BSP_SERIAL_APP_RX_PIN
#define BSP_LEUART0_RX_PORT     BSP_SERIAL_APP_RX_PORT
#define BSP_LEUART0_TX_PIN      BSP_SERIAL_APP_TX_PIN
#define BSP_LEUART0_TX_PORT     BSP_SERIAL_APP_TX_PORT
#ifdef _LEUART_ROUTELOC0_MASK
  #undef BSP_LEUART0_CTS_LOC
  #undef BSP_LEUART0_RTS_LOC
  #undef BSP_LEUART0_RX_LOC
  #undef BSP_LEUART0_TX_LOC
  #define BSP_LEUART0_CTS_LOC     BSP_SERIAL_APP_CTS_LOC
  #define BSP_LEUART0_RTS_LOC     BSP_SERIAL_APP_RTS_LOC
  #define BSP_LEUART0_RX_LOC      BSP_SERIAL_APP_RX_LOC
  #define BSP_LEUART0_TX_LOC      BSP_SERIAL_APP_TX_LOC
#else
  #undef BSP_LEUART0_ROUTE_LOC
  #define BSP_LEUART0_ROUTE_LOC   BSP_SERIAL_APP_ROUTE_LOC
#endif
#undef HAL_LEUART0_BAUD_RATE
#undef HAL_LEUART0_FLOW_CONTROL
#undef HAL_LEUART0_RX_QUEUE_SIZE
#undef HAL_LEUART0_RXSTART
#undef HAL_LEUART0_RXSTOP
#undef HAL_LEUART0_TX_QUEUE_SIZE
#define HAL_LEUART0_BAUD_RATE      HAL_SERIAL_APP_BAUD_RATE
#define HAL_LEUART0_FLOW_CONTROL   HAL_SERIAL_APP_FLOW_CONTROL
#define HAL_LEUART0_RX_QUEUE_SIZE  HAL_SERIAL_APP_RX_QUEUE_SIZE
#define HAL_LEUART0_RXSTART        HAL_SERIAL_APP_RXSTART
#define HAL_LEUART0_RXSTOP         HAL_SERIAL_APP_RXSTOP
#define HAL_LEUART0_TX_QUEUE_SIZE  HAL_SERIAL_APP_TX_QUEUE_SIZE
#elif BSP_SERIAL_APP_PORT == HAL_SERIAL_PORT_LEUART1
#undef BSP_LEUART1_CTS_PIN
#undef BSP_LEUART1_CTS_PORT
#undef BSP_LEUART1_RTS_PIN
#undef BSP_LEUART1_RTS_PORT
#undef BSP_LEUART1_RX_PIN
#undef BSP_LEUART1_RX_PORT
#undef BSP_LEUART1_TX_PIN
#undef BSP_LEUART1_TX_PORT
#define BSP_LEUART1_CTS_PIN     BSP_SERIAL_APP_CTS_PIN
#define BSP_LEUART1_CTS_PORT    BSP_SERIAL_APP_CTS_PORT
#define BSP_LEUART1_RTS_PIN     BSP_SERIAL_APP_RTS_PIN
#define BSP_LEUART1_RTS_PORT    BSP_SERIAL_APP_RTS_PORT
#define BSP_LEUART1_RX_PIN      BSP_SERIAL_APP_RX_PIN
#define BSP_LEUART1_RX_PORT     BSP_SERIAL_APP_RX_PORT
#define BSP_LEUART1_TX_PIN      BSP_SERIAL_APP_TX_PIN
#define BSP_LEUART1_TX_PORT     BSP_SERIAL_APP_TX_PORT
#ifdef _LEUART_ROUTELOC0_MASK
  #undef BSP_LEUART1_CTS_LOC
  #undef BSP_LEUART1_RTS_LOC
  #undef BSP_LEUART1_RX_LOC
  #undef BSP_LEUART1_TX_LOC
  #define BSP_LEUART1_CTS_LOC     BSP_SERIAL_APP_CTS_LOC
  #define BSP_LEUART1_RTS_LOC     BSP_SERIAL_APP_RTS_LOC
  #define BSP_LEUART1_RX_LOC      BSP_SERIAL_APP_RX_LOC
  #define BSP_LEUART1_TX_LOC      BSP_SERIAL_APP_TX_LOC
#else
  #undef BSP_LEUART1_ROUTE_LOC
  #define BSP_LEUART1_ROUTE_LOC   BSP_SERIAL_APP_ROUTE_LOC
#endif
#undef HAL_LEUART1_BAUD_RATE
#undef HAL_LEUART1_FLOW_CONTROL
#undef HAL_LEUART1_RX_QUEUE_SIZE
#undef HAL_LEUART1_RXSTART
#undef HAL_LEUART1_RXSTOP
#undef HAL_LEUART1_TX_QUEUE_SIZE
#define HAL_LEUART1_BAUD_RATE      HAL_SERIAL_APP_BAUD_RATE
#define HAL_LEUART1_FLOW_CONTROL   HAL_SERIAL_APP_FLOW_CONTROL
#define HAL_LEUART1_RX_QUEUE_SIZE  HAL_SERIAL_APP_RX_QUEUE_SIZE
#define HAL_LEUART1_RXSTART        HAL_SERIAL_APP_RXSTART
#define HAL_LEUART1_RXSTOP         HAL_SERIAL_APP_RXSTOP
#define HAL_LEUART1_TX_QUEUE_SIZE  HAL_SERIAL_APP_TX_QUEUE_SIZE
#elif BSP_SERIAL_APP_PORT == HAL_SERIAL_PORT_USB
#error VCOM over USB not supported currently
#else
#error Selected VCOM port not supported
#endif //BSP_SERIAL_APP_PORT

#endif //COM_VCOM_H
