#ifndef __ZB_DEVICE_ID_H
#define __ZB_DEVICE_ID_H
/****************** ******************************************************************
* File Name			: zb_device_id.h
* Author			: yjq
* data				: 2020/09/01
*************************************************************************************/

#define ZIGBEE_DEVICE_ID_STRING_ENABLE

//Generic
#define	DEVICE_ID_HA_ON_OFF_SWITCH						0x0000
#define	DEVICE_ID_HA_LEVEL_SWITCH						0x0001
#define	DEVICE_ID_HA_ON_OFF_OUTPUT						0x0002
#define	DEVICE_ID_HA_LEVEL_OUTPUT						0x0003
#define	DEVICE_ID_HA_SCENE_SELECTOR						0x0004
#define	DEVICE_ID_HA_CONFIGURATION_TOOL					0x0005
#define	DEVICE_ID_HA_REMOTE_CONTROL						0x0006
#define	DEVICE_ID_HA_COMBINED_INTERFACE					0x0007
#define	DEVICE_ID_HA_RANGE_EXTENDER						0x0008
#define	DEVICE_ID_HA_MAINS_POWER_OUTLET					0x0009
#define	DEVICE_ID_HA_DOOR_LOCK							0x000A
#define	DEVICE_ID_HA_DOOR_LOCK_CONTROLER				0x000B
#define	DEVICE_ID_HA_SIMPLE_SENSOR						0x000C
#define	DEVICE_ID_HA_CONSUMPTION_AWARE					0x000D
#define	DEVICE_ID_HA_HOME_GATEWAY						0x0050
#define	DEVICE_ID_HA_SMART_PLUG							0x0051
#define	DEVICE_ID_HA_WHITE_GOODS						0x0052
#define	DEVICE_ID_HA_METER_INTERFACE					0x0053
//Lighting
#define	DEVICE_ID_HA_ON_OFF_LIGHT						0x0100
#define	DEVICE_ID_HA_DIMMABLE_LIGHT						0x0101
#define	DEVICE_ID_HA_COLOR_DIMMABLE_LIGHT				0x0102
#define	DEVICE_ID_HA_ON_OFF_LIGHT_SWITCH				0x0103
#define	DEVICE_ID_HA_DIMMER_SWITCH						0x0104
#define	DEVICE_ID_HA_COLOR_DIMMAER_SWITCH				0x0105
#define	DEVICE_ID_HA_LIGHT_SENSOR						0x0106
#define	DEVICE_ID_HA_OCCUPANCY_SENSOR					0x0107
//Closures
#define	DEVICE_ID_HA_SHADE								0x0200
#define	DEVICE_ID_HA_SHADE_CONTROL						0x0201
#define	DEVICE_ID_HA_WINDOW_COVERING_DEVICE				0x0202
#define	DEVICE_ID_HA_WINDOW_COVERING_CONTROL			0x0203
//HVAC
#define	DEVICE_ID_HA_HEATING_COOLING_UNIT				0x0300
#define	DEVICE_ID_HA_THERMOSTAT							0x0301
#define	DEVICE_ID_HA_TEMPERATURE_SENSOR					0x0302
#define	DEVICE_ID_HA_PUMP								0x0303
#define	DEVICE_ID_HA_PUMP_CONTROL						0x0304
#define	DEVICE_ID_HA_PRESSURE_SENSOR					0x0305
#define	DEVICE_ID_HA_FLOW_SENSOR						0x0306
#define	DEVICE_ID_HA_MINI_SPLIT_AC						0x0307
//IAS
#define	DEVICE_ID_HA_IAS_CIE							0x0400
#define	DEVICE_ID_HA_IAS_ACE							0x0401
#define	DEVICE_ID_HA_IAS_ZONE							0x0402
#define	DEVICE_ID_HA_IAS_WARNING_DEVICE					0x0403

/***********************device id string****************************************/
//{device id string define start
#ifdef ZIGBEE_DEVICE_ID_STRING_ENABLE
//Generic
#define	DEVICE_ID_HA_ON_OFF_SWITCH_STRING				"On/Off Switch"
#define	DEVICE_ID_HA_LEVEL_SWITCH_STRING				"Level Control Switch"
#define	DEVICE_ID_HA_ON_OFF_OUTPUT_STRING				"On/Off Output"
#define	DEVICE_ID_HA_LEVEL_OUTPUT_STRING				"Level Controllable Output"
#define	DEVICE_ID_HA_SCENE_SELECTOR_STRING				"Scene Selector"
#define	DEVICE_ID_HA_CONFIGURATION_TOOL_STRING			"Configuration Tool"
#define	DEVICE_ID_HA_REMOTE_CONTROL_STRING				"Remote Control"
#define	DEVICE_ID_HA_COMBINED_INTERFACE_STRING			"Combined Interface"
#define	DEVICE_ID_HA_RANGE_EXTENDER_STRING				"Range Extender"
#define	DEVICE_ID_HA_MAINS_POWER_OUTLET_STRING			"Mains Power Outlet"
#define	DEVICE_ID_HA_DOOR_LOCK_STRING					"Door Lock"
#define	DEVICE_ID_HA_DOOR_LOCK_CONTROLER_STRING			"Door Lock Controller"
#define	DEVICE_ID_HA_SIMPLE_SENSOR_STRING				"Simple Sensor"
#define	DEVICE_ID_HA_CONSUMPTION_AWARE_STRING			"Consumption Awareness Device"
#define	DEVICE_ID_HA_HOME_GATEWAY_STRING				"Home Gateway"
#define	DEVICE_ID_HA_SMART_PLUG_STRING					"Smart plug"
#define	DEVICE_ID_HA_WHITE_GOODS_STRING					"White Goods"
#define	DEVICE_ID_HA_METER_INTERFACE_STRING				"Meter Interface"
//Lighting
#define	DEVICE_ID_HA_ON_OFF_LIGHT_STRING				"On/Off Light"
#define	DEVICE_ID_HA_DIMMABLE_LIGHT_STRING				"Dimmable Light"
#define	DEVICE_ID_HA_COLOR_DIMMABLE_LIGHT_STRING		"Color Dimmable Light"
#define	DEVICE_ID_HA_ON_OFF_LIGHT_SWITCH_STRING			"On/Off Light Switch"
#define	DEVICE_ID_HA_DIMMER_SWITCH_STRING				"Dimmable Light"
#define	DEVICE_ID_HA_COLOR_DIMMAER_SWITCH_STRING		"Color Dimmable Light"
#define	DEVICE_ID_HA_LIGHT_SENSOR_STRING				"Light Sensor"
#define	DEVICE_ID_HA_OCCUPANCY_SENSOR_STRING			"Occupancy Sensor"
//Closures
#define	DEVICE_ID_HA_SHADE_STRING						"Shade"
#define	DEVICE_ID_HA_SHADE_CONTROL_STRING				"Shade Controller"
#define	DEVICE_ID_HA_WINDOW_COVERING_DEVICE_STRING		"Window Covering Device"
#define	DEVICE_ID_HA_WINDOW_COVERING_CONTROL_STRING		"Window Covering Controller"
//HVAC
#define	DEVICE_ID_HA_HEATING_COOLING_UNIT_STRING		"Heating/Cooling Unit"
#define	DEVICE_ID_HA_THERMOSTAT_STRING					"Thermostat"
#define	DEVICE_ID_HA_TEMPERATURE_SENSOR_STRING			"Temperature Sensor"
#define	DEVICE_ID_HA_PUMP_STRING						"Pump"
#define	DEVICE_ID_HA_PUMP_CONTROL_STRING				"Pump Control"
#define	DEVICE_ID_HA_PRESSURE_SENSOR_STRING				"Pressure Sensor"
#define	DEVICE_ID_HA_FLOW_SENSOR_STRING					"Flow Sensor"
#define	DEVICE_ID_HA_MINI_SPLIT_AC_STRING				"Mini Split AC"
//IAS
#define	DEVICE_ID_HA_IAS_CIE_STRING						"IAS Control and Indicating Equipment"
#define	DEVICE_ID_HA_IAS_ACE_STRING						"IAS Ancillary Control Equipment"
#define	DEVICE_ID_HA_IAS_ZONE_STRING					"IAS Zone"
#define	DEVICE_ID_HA_IAS_WARNING_DEVICE_STRING			"IAS Warning Device"
#endif
//}device id string define end



typedef struct{
	unsigned short deviceId;
	#ifdef ZIGBEE_DEVICE_ID_STRING_ENABLE
	char *deviceIdString;
	#endif
}zb_device_id_s;
	
extern zb_device_id_s zb_device_id[];

#endif
