#ifndef __KK_NCP_MSG_H
#define __KK_NCP_MSG_H

#include "kk_ncp_common.h"

#define MSG_PARSE_ERROR  "Parse error"
#define MSG_INVALID_REQUEST  "Invalid Request"
#define MSG_METHOD_NOT_FOUND  "Method not found"
#define MSG_INVALID_PARAMS  "Invalid params"
#define MSG_INTERNAL_ERROR  "Internal error"



#define KK_THING_OTA_DEVICE_UPGRADE					"/ota/device/upgrade"
#define KK_GET_PROPERTY_MSG_TYPE					"/thing/service/property/get"
#define KK_READ_ATTRIBUTE_METHOD					"thing.service.property.get"
#define KK_DEVICE_TOPO_CHANGE_TYPE					"/thing/topo/change"

#define KK_REPORT_DEVICE_JOINED_TYPE						"/thing/topo/add"
#define KK_REPORT_DEVICE_LEFT_TYPE						    "/thing/topo/delete"
#define KK_REPORT_ATTRIBUTE_TYPE						    "/thing/event/property/post"
#define KK_REPORT_ALARM_TYPE						    	"/thing/event/alarm/post"


#define KK_IPC_VERSION										"1.0"
#define KK_REPORT_DEVICE_JOINED_METHOD						"thing.topo.add"
#define KK_REPORT_DEVICE_LEAVE_METHOD						"thing.topo.delete"
#define KK_REPORT_ATTRIBUTE_METHOD							"thing.event.property.post"
#define KK_READ_ATTRIBUTE_METHOD							"thing.service.property.get"

#define MSG_TOPO_CHANGE_TYPE_STR  "changeType"
#define MSG_TOPO_CHANGE_DEVICES_STR  "devices"

/////////////
#define KK_IPC_VERSION										"1.0"
#define KK_REPORT_DEVICE_BATCH_JOINED_METHOD				"thing.topo.batchAdd"
#define KK_REPORT_DEVICE_JOINED_METHOD						"thing.topo.add"
#define KK_REPORT_DEVICE_LEAVE_METHOD						"thing.topo.delete"
#define KK_REPORT_DEVICE_BATCH_LEAVE_METHOD					"thing.topo.batchDelete"
#define KK_REPORT_ADDWHITELIST_NOTIFY_METHOD				"thing.event.whiteListAddedNotification.post"
#define KK_REPORT_DELWHITELIST_NOTIFY_METHOD				"thing.event.whiteListDeletedNotification.post"



#define KK_REPORT_PROPERTY_MSG_TYPE						"/thing/event/property/post"
#define KK_SET_PROPERTY_REPLY_MSG_TYPE					"/thing/service/property/set_reply"
#define KK_GET_PROPERTY_REPLY_MSG_TYPE					"/thing/service/property/get_reply"



#define KK_GET_PROPERTY_REPLY_METHOD					"thing.service.property.get"






#define KK_REPORT_ALARM_METHOD								"thing.event.alarm.post"
#define KK_REPORT_ATTRIBUTE_METHOD							"thing.event.property.post"



#define KK_REPORT_ATTRIBUTE_TYPE						    "/thing/event/property/post"


#define KK_REPORT_DEVICE_BATCH_JOINED_TYPE					"/thing/topo/batch_add"
#define KK_REPORT_DEVICE_JOINED_TYPE						"/thing/topo/add"
#define KK_REPORT_DEVICE_LEFT_TYPE						    "/thing/topo/delete"
#define KK_REPORT_DEVICE_BATCH_LEFT_TYPE				    "/thing/topo/batch_delete"

#define KK_REPORT_ALARM_TYPE						    	"/thing/event/alarm/post"
#define KK_REPORT_ADDWHITELIST_NOTIFY_TYPE				    "/thing/event/whiteListAddedNotification/post"
#define KK_REPORT_DELWHITELIST_NOTIFY_TYPE				    "/thing/event/whiteListDeletedNotification/post"

void* _msg_event_property_post(char ip[16], int port);
void* _msg_topo_add(void);


int kk_sendData2CCU(char* data, int len);
int kk_tsl_send_msg(cJSON * msgJson);
void kk_tsl_msg_ack(const char * id,const char *ackMsgType,const char *productCode,const char *deviceCode);







#endif

