#ifndef __KK_NCP_COMMON_H
#define __KK_NCP_COMMON_H
#include "app/framework/include/af.h"

#include "./jsonrpc/rpccJSON.h"
#include "./jsonrpc/jsonrpc-c.h"









#define GW2CCU_PROTOCOL "tcp"
#define GW_PRODUCT_CODE "2"

//#define GATEWAY_TYPE_NCP

#ifdef GATEWAY_TYPE_NCP
	#undef GW2CCU_PROTOCOL
	#define GW2CCU_PROTOCOL "nanomsg"
#endif

void _cb(void* data, int len, char* chlmark);

char* kk_get_gw_mac(void);

cJSON* rpc_reportDeviceState(char *state,EmberEUI64 eui64);


#define RPC_APPVERSION_STRING_LENGTH 3 //

#define RPC_ENDPOINT_STRING_LENGTH 4 //0-255 + NULL
#define RPC_EUI64_STRING_LENGTH 19 //"0x" + 16 characters + NULL
#define RPC_NODEID_STRING_LENGTH 7 //"0x" + 4 characters + NULL
#define RPC_CLUSTERID_STRING_LENGTH 7 // "0x" + 4 chars + NULL
#define RPC_ATTRIBUTE_STRING_LENGTH 7 // "0x" + 4 chars + NULL
#define RPC_DATATYPE_STRING_LENGTH 4 //0-255 + NULL
#define RPC_LENGTH_STRING_LENGTH 4 //0-255 + NULL
#define RPC_STATUS_STRING_LENGTH 4 //0-255 + NULL



#define KK_EUI64_STRING_LENGTH 17 //16 characters + NULL




#define KK_GET_U16( x )					(int16u)( (x[1]<<8)+x[0] )
#define	KK_GET_U24( x )					(int32u)( (x[2]<<16)+(x[1]<<8)+x[0] )
#define	KK_GET_U32( x )					(int32u)( (x[3]<<24)+(x[2]<<16)+(x[1]<<8)+x[0] )
#define	KK_GET_U48( x )					(int64u)( ((int64u)(x[4])<<32)+(x[3]<<24)+(x[2]<<16)+(x[1]<<8)+x[0] )













#endif



