#ifndef __KK_UTILS_H__
#define __KK_UTILS_H__
#include "kk_tsl_common.h"
#include "lite-cjson.h"

int kk_utils_copy(_IN_ void *input, _IN_ int input_len, _OU_ void **output, _IN_ int output_len);
int kk_utils_strarr_index(_IN_ char *input, _IN_ int input_len,_OU_ int *partial_input_len, _OU_ int *array_input_len, _OU_ int *array_index);
int kk_utils_copy_direct(_IN_ void *input, _IN_ int input_len, _OU_ void **output, _IN_ int output_len);
int kk_utils_itoa(_IN_ int input, _OU_ char **output);
int kk_utils_memtok(_IN_ char *input, _IN_ int input_len, _IN_ char delimiter, _IN_ int index, _OU_ int *offset);
void *kk_MutexCreate(void);
void kk_MutexLock(void *mutex);
void kk_MutexUnLock(void *mutex);
void kk_MutexDestroy(void *mutex);
int kk_utils_itoa_direct(_IN_ int input, _OU_ char **output);
int kk_utils_ftoa_direct(_IN_ double input, _OU_ char **output);
int kk_utils_json_parse(_IN_ const char *payload, _IN_ int payload_len, _IN_ int type, _OU_ lite_cjson_t *lite);
int kk_utils_json_object_item(_IN_ lite_cjson_t *lite, _IN_ const char *key, _IN_ int key_len, _IN_ int type,
                                _OU_ lite_cjson_t *lite_item);
#endif
