/*******************************************************************************
 * Copyright (c) 2020 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    https://www.eclipse.org/legal/epl-2.0/
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial implementation
 *******************************************************************************/

#if !defined(MQTTTIME_H)
#define MQTTTIME_H


#include <sys/time.h>
#define START_TIME_TYPE struct timeval
#define START_TIME_ZERO {0, 0}
#ifdef _GNU_SOURCE
#undef  _XOPEN_SOURCE
#define _XOPEN_SOURCE 600
#undef  _XOPEN_SOURCE_EXTENDED
#define _XOPEN_SOURCE_EXTENDED 1
#undef  _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE 1
#undef  _BSD_SOURCE
#define _BSD_SOURCE 1
#undef  _SVID_SOURCE
#define _SVID_SOURCE 1
#undef  _ISOC99_SOURCE
#define _ISOC99_SOURCE 1
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE 1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 200112L
#undef  _ATFILE_SOURCE
#define _ATFILE_SOURCE 1
#endif


void MQTTTime_sleep(long milliseconds);
START_TIME_TYPE MQTTTime_start_clock(void);
START_TIME_TYPE MQTTTime_now(void);
long MQTTTime_elapsed(START_TIME_TYPE milliseconds);
long MQTTTime_difftime(START_TIME_TYPE new, START_TIME_TYPE old);

#endif
