
#ifndef __KK_HAL_H__
#define __KK_HAL_H__
#include <stdio.h>
#include <sys/time.h>
#include <time.h>
#include "kk_product.h"
#ifndef _IN_
    #define _IN_
#endif

#ifndef _OU_
    #define _OU_
#endif

uint64_t HAL_UptimeMs(void);
time_t HAL_Uptimes(void);
void HAL_SleepMs(_IN_ uint32_t ms);
uint32_t HAL_Get_IP(char ip_str[NETWORK_ADDR_LEN], const char *ifname);
time_t HAL_GetTime(void);
time_t HAL_GetTime_s(char *outStr);
long long HAL_GetTime_ms();
int HAL_Snprintf(_IN_ char *str, const int len, const char *fmt, ...);
int HAL_Vsnprintf(_IN_ char *str, _IN_ const int len, _IN_ const char *format, va_list ap);
void *HAL_MutexCreate(void);
void HAL_MutexLock(_IN_ void *mutex);
void HAL_MutexUnlock(_IN_ void *mutex);
void HAL_SemaphoreDestroy(_IN_ void *sem);
void *HAL_SemaphoreCreate(void);
int HAL_SemaphoreWait(_IN_ void *sem, _IN_ uint32_t timeout_ms);
void HAL_SemaphorePost(_IN_ void *sem);
int HAL_ThreadCreate(
            _OU_ void **thread_handle,
            _IN_ void *(*work_routine)(void *),
            _IN_ void *arg,
            _OU_ int *stack_used);
void HAL_MutexDestroy(_IN_ void *mutex);
int HAL_GetVersion(_OU_ char *version);
int HAL_Get_mac(char* mac);
int HAL_Get_SN(char sn[SN_ADDR_LEN]);
int HAL_Execel_cmd(char * cmd,char * buf,int buf_len,int* ret_len);

int HAL_SetProduct_Type(_IN_ char *product_type);
int HAL_SetProduct_Code(_IN_ char *product_code);
int HAL_GetProduct_Code(_OU_ char *product_code);
#endif
