#ifndef __KK_LAN_SYNC_H
#define __KK_LAN_SYNC_H

#include "cJSON.h"

#define MAX_AC_GW_AIR_NUM						5
#define MAX_AC_INDOOR_AIR_NUM					16

#define	AIR_AC_INDOOR_ID_SIZE					8
#define	AIR_AC_INDOOR_ROOM_ID_SIZE				24
#define	AIR_AC_INDOOR_NAME_SIZE					32
#define	AIR_AC_INDOOR_ADDR_SIZE					8






typedef struct{
	char *floor_id;
	char *room_id;
	char *room_icon;
	char *room_name;
	char *room_status;
}SYN_ROOM_ITEM;


typedef struct {
	char *ui_area;
	char *ui_name;
	char *delay;
	int nodeid;
	char *operate_type;
	char *operation;
	char *ui_room_id;
}SYN_SCENE_ACTION;

typedef struct{
	char *scene_id;
	char *name;
	char *pannel_id;
	char *room_id;
	char *time;
	char *week;
	char *scenetype;
	SYN_SCENE_ACTION *act;
	int act_num;
}SYN_SCENE_ITEM;





typedef struct{
	int epNum;
	int online;
	int PowerSwitch;
	double Temperature;
	int WindSpeed;
	int WorkMode;
}INDOOR_AIR_STATUS;
typedef struct{
	char deviceCode[PRODUCT_CODE_LEN];
	INDOOR_AIR_STATUS status[MAX_AC_INDOOR_AIR_NUM];
}INDOOR_AIR_DEV;


cJSON *kk_get_raw_sync_data(cJSON *payload);




cJSON *kk_sync_rooms_to_sdk(cJSON *root,cJSON *payload);
cJSON *kk_sync_scence_to_sdk(cJSON *root,cJSON *data);
int kk_sync_devices_to_sdk(cJSON *root,cJSON *data);
int kk_sync_devices_status_to_sdk(cJSON *root);

int kk_create_syncinfo_to_sdk(cJSON *payload,int push);

int kk_send_indoorAir_status(cJSON *info,const char *deviceCode);
cJSON * val_conver_new2old(cJSON *newccuItem,cJSON *oldccuItem,int syn_type);




int indoor_airstatus_table_insert_item(const char *deviceCode,int epNum,int online,int PowerSwitch,double Temperature,int WindSpeed,int WorkMode);
INDOOR_AIR_STATUS *indoor_airstatus_table_find_item(const char *deviceCode,int epNum);
int indoor_airstatus_table_delete_item(const char *deviceCode);







#endif

