#ifndef __KK_LAN_NODE_DB_H_
#define __KK_LAN_NODE_DB_H_

#include "sqlite3.h"

#ifdef CONFIG_A133_PLATFORM
#define KK_LAN_NODE_DB_FILE					"/data/local/kk/db/kk_lan_node.db"
#else
#define KK_LAN_NODE_DB_FILE					"/data/kk/kk_lan_node.db"
#endif

typedef struct {
	void *mutex;
	sqlite3 *pDb;	
} kk_lan_node_db_ctx_t;

enum{
	LAN_DB_IDX = 0,
	LAN_DB_DEVICECODE,
	LAN_DB_CHANNEL,
	LAN_DB_NODE,
};

int kk_lan_db_node_init(void);
int kk_lan_db_node_insert(const char *deviceCode,int channel,int node);
int kk_lan_db_node_get(const char *deviceCode,int channel);
int kk_lan_db_node_get_all(const char *deviceCode,int *nodes);

int kk_lan_db_deviceCode_get(int node,char *deviceCode);
int kk_lan_db_channel_get(int node,int *channel);
int kk_lan_db_get_item_by_node(int node,char *deviceCode,int *channel);

int kk_lan_db_node_delete(const  char *deviceCode);
int kk_check_lan_node_exist(const char* deviceCode,int channel);
int kk_check_lan_node(int nodeId);



#endif

