#ifndef __KK_LAN_NEW_DEV_NOTIFY_H
#define __KK_LAN_NEW_DEV_NOTIFY_H
#include "kk_ccu_msg.h"
#include "kk_lan_sync.h"
#include <stdbool.h>
typedef struct {
	cJSON *new_device_count;
	cJSON *new_devices;

	cJSON *new_hue_lights_count;
	cJSON *new_hue_lights;
	
	cJSON *new_ipc_count;
	cJSON *new_ipcs;

	cJSON *new_konke_count;
	cJSON *new_konke_sockets;

	cJSON *new_konke_lights_count;
	cJSON *new_konke_lights;

	cJSON *new_cnwise_music_controllers_count;
	cJSON *new_cnwise_music_controllers;

	cJSON *new_modbus_devs_count;
	cJSON *new_modbus_devs;

	cJSON *new_modbus_daikin_indoorunits_count;
	cJSON *new_modbus_daikin_indoorunits;

	cJSON *new_konke_humidifiers_count;
	cJSON *new_konke_humidifiers;

	cJSON *new_konke_aircleaners_count;
	cJSON *new_konke_aircleaners;

	cJSON *new_central_ac_gws_count;
	cJSON *new_central_ac_gws;

	cJSON *new_central_ac_indoorunits_count;
	cJSON *new_central_ac_indoorunits;

	cJSON *new_youzhuan_music_controllers_count;
	cJSON *new_youzhuan_music_controllers;
	
}NEW_DEVICE_NOTIFY;


typedef struct{
	char channel[4];
	char mac[32];
	char gwmac[32];
	char operate_type[12];
	char nodeid[8];
}new_dev_item;

typedef struct{
	char *hue_light_id;
	char *hue_gw_id;
	char *hue_light_status;
}HUE_LIGHT_ITEM;

typedef struct{
	char *konke_socket_id;
	char *konke_socket_mac;
	char *konke_socket_online;
	char *konke_socket_status;
}KK_SOCKET_ITEM;


typedef struct{
	char *konke_light_id;
	char *konke_light_mac;
	char *konke_light_online;
	char *konke_light_status;
}KK_LIGHT_ITEM;



typedef struct{
	char *id;
	char *music_controller_mac;
	char *music_controller_type;
	char *music_controller_online;
	char *music_controller_status;
}MC_CTRL_ITEM;

typedef struct{
	char *id;
	char *dev_type;
	char *daikin_gw;
	char *dev_addr;
	char *bind_modbus_gw_node_id;
}MODBUS_DEV_ITEM;



typedef struct{
	char *id;
	char *indooruint_addr;
	char *bind_daikin_gw_devid;
}MODBUS_DAIKIN_INDOORUNIT_ITEM;





typedef struct{
	char *konke_humidifier_id;
	char *konke_humidifier_mac;
	char *konke_humidifier_online;
	char *konke_humidifier_status;
}KK_HUMIDIFIER_ITEM;

typedef struct{
	char *konke_aircleaner_id;
	char *konke_aircleaner_mac;
	char *konke_aircleaner_online;
	char *konke_aircleaner_status;
}KK_AIRCLEANER_ITEM;


typedef struct{
	char *id;
	char *bind_central_ac_gw_node_id;
	char *ac_gw_status;
}CENTRAL_AC_ITEM;

typedef struct{
	bool online;
	bool on;
	char mode[16];
	char speed[16];
	double settingTemperature;
	double roomTemperature;
}CENTRAL_AC_INDOOR_STATUS;

typedef struct{
	char id[AIR_AC_INDOOR_ID_SIZE];
	char indooruint_addr[AIR_AC_INDOOR_ADDR_SIZE];
	char nodeid[AIR_AC_INDOOR_ID_SIZE];
	char dev_name[AIR_AC_INDOOR_NAME_SIZE];
	char room_id[AIR_AC_INDOOR_ROOM_ID_SIZE];
	CENTRAL_AC_INDOOR_STATUS ac_gw_status;
}CENTRAL_AC_INDOOR_ITEM;


typedef struct{
	char *id;
	char *music_controller_mac;
	char *music_controller_type;
	char *music_controller_online;
	char *music_controller_status;
}YOUZHUAN_MC_CTRL_ITEM;


void kk_clear_indoor_data();
void kk_new_device_send();

#endif




