#ifndef _KK_VOICE_PANEL_CFG_H
#define _KK_VOICE_PANEL_CFG_H

#include "cJSON.h"


#define _OUT
#define _IN



typedef struct{
	char nodeId[17];
	char name[32];
	char ch[8];
	char operateType[12];
	char room[24];
	char mac[24];
	char online[6];
	char pid[17];
}VP_ZB_DEV_ITEM;

typedef struct{
	char id[24];
	char name[32];
	char room[24];
	char type[12];
}VP_SCENE_ITEM;

typedef struct{
	char id[24];
	char name[32];
}VP_ROOM_ITEM;


typedef struct{
	char *ac_gw_nodeId;
	char *addr;
	char *nodeId;
	char *name;
	char *operateType;
	char *room;
	int online;
}VP_AC_INDOOR_ITEM;

typedef struct{
	char nodeId[12];
	char mac[24];
	char name[32];
}VP_GW_ITEM;


typedef struct{
	cJSON *controller_buttons_config;
	cJSON *gws;
	cJSON *infrared_codelib_info;
	cJSON *other_devices;
	cJSON *rooms;
	cJSON *scenes;
	cJSON *zigbee_devices;
}VP_CFG_JSON;





int kk_vp_cfg_init(void);

_OUT int kk_vp_syncinfo(_IN cJSON *payload,_IN int ver,_OUT cJSON **root);






















#endif

