#!/bin/sh
nanomsg_File="/app/ccuApps/lib/libnanomsg.so.5"
ev_File="/app/ccuApps/lib/libev.so.4"
sqlite_File="/app/ccuApps/lib/libsqlite3.so.0"

run_Dir="/data/kk"
tsl_Dir="${run_Dir}/tsl"
map_Dir="${run_Dir}/map"
#dev_cfg_Dir="${run_Dir}/dev_config_table"

#cd /sbin/
#insmod /sbin/ssd1306-revision.ko
#/sbin/oled >/dev/null 2>&1 &
#sleep 1

if [ ! -d "$run_Dir" ]; then
	mkdir ${run_Dir}
fi

if [ ! -d "$tsl_Dir" ]; then
	cp -rf /app/ccuApps/tsl ${run_Dir}/
fi
if [ ! -d "$map_Dir" ]; then
	cp -rf /app/ccuApps/map ${run_Dir}/
fi

cd /app/ccuApps/lib
if [ ! -f "$nanomsg_File" ]; then
	ln -sf /app/ccuApps/lib/libnanomsg.so /lib/libnanomsg.so.5
fi
if [ ! -f "$ev_File" ]; then
	ln -sf /app/ccuApps/lib/libev.so /lib/libev.so.4
fi

if [ ! -f "$sqlite_File" ]; then
	ln -sf /app/ccuApps/lib/libsqlite3.so /lib/libsqlite3.so.0
fi


export LD_LIBRARY_PATH=/app/ccuApps/lib

/app/ccuApps/bin/kk_midware &
sleep 3
/app/ccuApps/bin/kk_cloud &
sleep 1
#/home/kk/process_check.sh >/dev/null 2>&1 &
/app/ccuApps/bin/smarthome_z3gw_nx5 -r1 -l3 --device-def=/app/ccuApps/kk_device_def.json --db=/data/kk/kk_z3gw.db --uart=/dev/ttyS1&
sleep 2
/app/ccuApps/bin/kk_lan &
sleep 1
echo "*/1 * * * *   /app/ccuApps/process_check.sh" > /etc/cron.d/ccu || { echo "ERROR:add ccu crontab rule failed."; exit 1;}
ntpd -n -q -d -p stdtime.gov.hk &
exit 0