#ifndef _KK_VOICE_PANEL_HANDLE_H
#define _KK_VOICE_PANEL_HANDLE_H

#include "uart_proto.h"
#include "kk_lan_voice_panel.h"
#include "kk_voice_panel_cfg.h"


#define VP_CONFIG_FILE_MD5			"voice_data.MD5"
#define VP_CONFIG_FILE				"/etc/smarthome/voice_data.json"
#define VP_CONFIG_FILE_TAR_GZ		"voice_data.tar.gz"


#define OPCODE_8009_SNAPSHOOT				0x1000
#define OPCODE_SNAPSHOOT					0x1001
#define OPCODE_SCENE_ID_NOTIFY				0x1003
#define OPCODE_SYSTEM_TIME_SET				0x1009
#define OPCODE_SYSTEM_TIME_GET				0x100A
#define OPCODE_ACTION_NOTIFY				0x100B
#define OPCODE_CONFIG_FILE_UPDATE_NOTIFY	0x100C
#define OPCODE_CONFIG_DATA_REQUEST			0x100D
#define OPCODE_CONFIG_FILE_UPDATE_STOP		0x100E
#define OPCODE_CONFIG_FILE_INFO_GET			0x100F
#define OPCODE_CONFIG_FILE_UPDATE_STATUS	0x1010


#define	EXECUTE_CMD(cmd)		do {\
	printf("\n[%s][%d]------------------execte cmd------------------\n",__FUNCTION__,__LINE__);\
	printf("%s\n",cmd);\
}while(0)

#define VP_SEND_PRINT(format,...)				printf("\n\033[33;32m"format"\033[0m\n",##__VA_ARGS__)
#define VP_RECV_PRINT(format,...)				printf("\n\033[33;34m"format"\033[0m\n",##__VA_ARGS__)


typedef void (*vp_handle_func)(pro_data_t *pro_data);
typedef struct 
{
	uint16_t opcode;
	vp_handle_func func;
}VP_OPCODE_HANDLE;



int vp_scene_id_map_load(void);

void vp_scene_id_map_deinit(void);
int vp_scene_id_item_add(int scene_id);


//主机快照请求
void vp_8009_snapshoot_get(void);
void kk_vp_set_8009_system_time(void);
void kk_vp_config_file_update_start(uint32_t ver);
void kk_vp_config_file_update_stop(uint32_t ver);
void kk_vp_get_config_file_info(void);









void kk_vp_get_8009_snapshoot(void);

void kk_vp_syncinfo_handle(_IN cJSON *payload);
int kk_vp_opcode_handle(_IN pro_data_t *pro_data);







int _vp_get_cfg_file_crc32(void);
int _vp_get_cfg_file_size(void);



#endif


