#include "kk_data_mng.h"
#include "kk_lan_vp_ctrl.h"
#include "cJSON.h"

cJSON *PowerSwitch_msg_build(int ep,int onoff)
{
	char epNum[12] = {0};
	cJSON *params = cJSON_CreateObject();
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);

	memset(epNum,0,sizeof(epNum));
	snprintf(epNum,sizeof(epNum),"%d",ep);
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	cJSON_AddStringToObject(params,"epNum",epNum);
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	cJSON_AddNumberToObject(params,"PowerSwitch",onoff);
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	return params;
}


static int is_light_dev(int pid);
static cJSON *light_dev(int ep,int onoff);
static cJSON *light_dev_handle(int ep,uint8_t *arg);

static int is_curtain_dev(int pid);
static cJSON *curtain_dev_msg_build(int ep,int OperationMode);
static cJSON *curtain_dev_handle(int ep,uint8_t *arg);

static int is_outlet_dev(int pid);
static cJSON *outlet_msg_build(int ep,int onoff);
static cJSON *outlet_dev_handle(int ep,uint8_t *arg);

typedef int (*pid_mth_func)(int pid);
typedef cJSON *(*dev_handle)(int ep,uint8_t *arg);

typedef struct{
	pid_mth_func mth;
	dev_handle handle;
}KK_VP_CTRL;

static KK_VP_CTRL vp_ctrl_table[]={
	{is_light_dev,light_dev_handle},
	{is_curtain_dev,curtain_dev_handle},
	{is_outlet_dev,outlet_dev_handle}
};

static int light_dev_pid[]={
	3023,3024
};

static int curtain_dev_pid[]={
	3067
};

static int outlet_dev_pid[]={
	3020
};
	

static int is_light_dev(int pid)
{
	int i;
	for(i=0;i<sizeof(light_dev_pid)/sizeof(int);i++){
		if(pid==light_dev_pid[i]){
			return 1;
		}
	}
	return 0;
}

static int is_curtain_dev(int pid)
{
	int i;
	for(i=0;i<sizeof(curtain_dev_pid)/sizeof(int);i++){
		if(pid==curtain_dev_pid[i]){
			return 1;
		}
	}
	return 0;
}

static int is_outlet_dev(int pid)
{
	int i;
	for(i=0;i<sizeof(outlet_dev_pid)/sizeof(int);i++){
		if(pid==outlet_dev_pid[i]){
			return 1;
		}
	}
	return 0;
}


static cJSON *light_msg_build(int ep,int onoff)
{
	return PowerSwitch_msg_build(ep,onoff);
}


static cJSON *light_dev_handle(int ep,uint8_t *arg)
{
	uint8_t skill_type = arg[0];
	printf("[%s][%d]skill_type=%d,ep=%d\n",__FUNCTION__,__LINE__,skill_type,ep);
	switch(skill_type){
		case VP_CTRL_OPEN://
			return light_msg_build(ep,1);
		case VP_CTRL_CLOSE:
			return light_msg_build(ep,0);
		default:break;
	}
	return NULL;
}




static cJSON *curtain_dev_msg_build(int ep,int OperationMode)
{
	char epNum[12] = {0};
	cJSON *params = cJSON_CreateObject();
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);

	memset(epNum,0,sizeof(epNum));
	snprintf(epNum,sizeof(epNum),"%d",ep);
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	cJSON_AddStringToObject(params,"epNum",epNum);
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	cJSON_AddNumberToObject(params,"OperationMode",OperationMode);
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	return params;
}

static cJSON *curtain_dev_handle(int ep,uint8_t *arg)
{
	uint8_t skill_type = arg[0];
	printf("[%s][%d]skill_type=%d,ep=%d\n",__FUNCTION__,__LINE__,skill_type,ep);
	switch(skill_type){
		case VP_CTRL_OPEN://
			return curtain_dev_msg_build(ep,1);
		case VP_CTRL_CLOSE:
			return curtain_dev_msg_build(ep,0);
		case VP_CTRL_STOP:
			return curtain_dev_msg_build(ep,2);
		default:break;
	}
	return NULL;
}


static cJSON *outlet_msg_build(int ep,int onoff)
{
	return PowerSwitch_msg_build(ep,onoff);
}


static cJSON *outlet_dev_handle(int ep,uint8_t *arg)
{
	uint8_t skill_type = arg[0];
	printf("[%s][%d]skill_type=%d,ep=%d\n",__FUNCTION__,__LINE__,skill_type,ep);
	switch(skill_type){
		case VP_CTRL_OPEN://
			return outlet_msg_build(ep,1);
		case VP_CTRL_CLOSE:
			return outlet_msg_build(ep,0);
		default:break;
	}
	return NULL;
}


void kk_lan_vp_control(uint8_t num,uint32_t nodeIdAry[],uint8_t *arg)
{
	uint8_t i,j;
	int ep;
	int pid = 0;

	char productCode[32] = {0};
	char deviceCode[32] = {0};

	cJSON *msg = NULL;
	cJSON *params = NULL;
	
	kk_map_dev_node_t *node = NULL;
	KK_VP_CTRL *pVpCtr = vp_ctrl_table;

	for(i=0;i<num;i++){
		memset(deviceCode,0,sizeof(deviceCode));
		memset(productCode,0,sizeof(productCode));
		kk_lan_db_deviceCode_get(nodeIdAry[i],deviceCode);
		kk_lan_db_channel_get(nodeIdAry[i],&ep);

		if(kk_map_dev_search_by_deviceCode(deviceCode,&node) != 0){
			continue ;
		}
		
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		snprintf(productCode,sizeof(productCode),"%s",node->productCode);
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);

		pid = atoi(productCode);
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);

		params = NULL;
		for(j=0;j<sizeof(vp_ctrl_table)/sizeof(KK_VP_CTRL);j++,pVpCtr++){
			if(pVpCtr->mth!=NULL && pVpCtr->handle!=NULL){
				if(pVpCtr->mth(pid)){
					printf("[%s][%d]\n",__FUNCTION__,__LINE__);
					params = pVpCtr->handle(ep,arg);
					break;
				}
			}
		}
		if(params!=NULL){
			printf("[%s][%d]\n",__FUNCTION__,__LINE__);
			msg=property_set(productCode,deviceCode,"*","*",params);
			printf("[%s][%d]\n",__FUNCTION__,__LINE__);
			kk_ipc_send_json(msg);
		}
	}
}






















