#include "kk_log.h"

#include "klist.h"
#include "kk_product.h"
#include "com_api.h"
#include "kk_opcode.h"
#include "kk_lan_ctrl.h"
#include "kk_data_mng.h"
#include "cJSON.h"
#include "kk_ccu_msg.h"
#include "kk_oldccu_msg.h"
#include "kk_newccu_msg.h"




int match_opcode_pos(cJSON *array,const char *opcode,int ch)
{
	int i = 0;
	int pos = -1;
	cJSON *item;
	cJSON *mh;
	cJSON *channel;
	
	int size = cJSON_GetArraySize(array);
	for(;i<size;i++){
		item = cJSON_GetArrayItem(array,i);
		mh = cJSON_GetObjectItem(item,"opcode");
		channel = cJSON_GetObjectItem(item,"channel");
		if((strcmp(mh->valuestring,opcode)==0) &&
			(atoi(channel->valuestring)==ch)){
			pos = i;
			break;
		}
	}
	return pos;
}




cJSON * kk_control_protocol_convert(kk_map_dev_node_t *devNode,int nodeId,cJSON *arg,cJSON *opcode)
{
	cJSON *params = cJSON_CreateObject();
	cJSON *val;

	cJSON *newccuItem;
	cJSON *oldccuItem;

	cJSON *o_dataType;
	cJSON *n_dataType;

	cJSON *n_valueRange;
	cJSON *o_valueRange;

	cJSON *n_identifier;
	cJSON *epNum;

	int pos;
	int channel;
	char ch[33];
	
	

	kk_lan_db_channel_get(nodeId,&channel);
	
	snprintf(ch,33,"%d",channel);

	pos = match_opcode_pos(devNode->oldccu,opcode->valuestring,channel);

	if(pos==-1){
		debug_log(LOG_FOCUS,"not find\n");
		return NULL;
	}
	debug_log(LOG_FOCUS,"1\n");
	newccuItem = cJSON_GetArrayItem(devNode->newccu,pos);
	oldccuItem = cJSON_GetArrayItem(devNode->oldccu,pos);
	debug_log(LOG_FOCUS,"2\n");

	o_dataType = cJSON_GetObjectItem(oldccuItem,"dataType");
	o_valueRange = cJSON_GetObjectItem(oldccuItem,"valueRange");
	debug_log(LOG_FOCUS,"3\n");
	n_dataType = cJSON_GetObjectItem(newccuItem,"dataType");
	n_valueRange = cJSON_GetObjectItem(newccuItem,"valueRange");
	n_identifier =  cJSON_GetObjectItem(newccuItem,"identifier");
	epNum =  cJSON_GetObjectItem(newccuItem,"channel");
	debug_log(LOG_FOCUS,"4\n");

	if(strcmp(o_dataType->valuestring,"map")==0){
		debug_log(LOG_FOCUS,"5\n");
		val = map_type_convert(o_dataType,o_valueRange,arg,n_valueRange);
	}else{
		debug_log(LOG_FOCUS,"6\n");
		val = msg_convert_value(o_dataType,n_dataType,arg);
	}
	debug_log(LOG_FOCUS,"7\n");

	cJSON_AddStringToObject(params,"epNum",epNum->valuestring);
	debug_log(LOG_FOCUS,"8\n");

	if(val->type==cJSON_False){
		cJSON_AddFalseToObject(params,n_identifier->valuestring);
	}else if(val->type==cJSON_True){
		cJSON_AddTrueToObject(params,n_identifier->valuestring);
	}else if(val->type==cJSON_NULL){
		cJSON_AddNullToObject(params,n_identifier->valuestring);
	}else if(val->type==cJSON_Number){
		cJSON_AddNumberToObject(params,n_identifier->valuestring,val->valuedouble);
	}else if(val->type==cJSON_String){
		cJSON_AddStringToObject(params,n_identifier->valuestring,val->valuestring);
	}else if(val->type==cJSON_Array){
		printf("......................\n");
	}
	debug_log(LOG_FOCUS,"9\n");

	return params;
}







int kk_ccu_opcode_handle(cJSON *root)
{
	cJSON *msg;

	cJSON *nodeId;
	cJSON *opcode;
	cJSON *arg;
	cJSON *requester;
	char deviceCode[33]={0};

	kk_map_dev_node_t *dev;
	
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);
	nodeId = cJSON_GetObjectItem(root,NODEID_STR);
	opcode = cJSON_GetObjectItem(root,OPCODE_STR);
	arg = cJSON_GetObjectItem(root,ARG_STR);
	
	requester= cJSON_GetObjectItem(root,REQUEST_STR);
	if(opcode==NULL||opcode->type!=cJSON_String){
		return -1;
	}

	if(nodeId==NULL||opcode==NULL||arg==NULL ){
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		return -1;
	}

	if(requester!=NULL){
		WARNING_PRINT("[requester]%s\n",requester->valuestring);
	}

	kk_lan_db_deviceCode_get(atoi(nodeId->valuestring),deviceCode);


	//execute scene
	if((requester!=NULL) &&(strcmp(requester->valuestring,HJ_PROFILE)==0) &&
		(strcmp(opcode->valuestring,"SWITCH")==0)){

		msg=scene_execute(nodeId->valuestring);

		
		kk_ipc_send_json(msg);
		return 0;

	}

	if(kk_map_dev_search_by_deviceCode(deviceCode, &dev)==0){
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		cJSON *params=kk_control_protocol_convert(dev,atoi(nodeId->valuestring),arg,opcode);
	
		msg=property_set(dev->productCode,dev->deviceCode,"*","*",params);
		kk_ipc_send_json(msg);
	
		
	}else{
		WARNING_PRINT("[%s][%d]\n",__FUNCTION__,__LINE__);
	}

}














char *node_string(int nodeId)
{
	char *node = (char *)malloc(33);
	memset(node,0,33);
	
	snprintf(node,32,"%d",nodeId);
	return node;
}


































