/*
 * 
 */



#ifndef _KK_DM_API_H_
#define _KK_DM_API_H_
#include "iotx_dm.h"

#define CONFIG_DISPATCH_QUEUE_MAXLEN    (50)


typedef struct {
    void *mutex;
    void *cloud_connectivity;
    void *local_connectivity;
    iotx_dm_event_callback event_callback;
} dm_api_ctx_t;

#if defined(DEPRECATED_LINKKIT)
typedef struct {
    void *mutex;
    int devid;
    lite_cjson_item_t *lite;
} dm_api_property_t;
#endif
int iotx_dm_ccu_cloud_check(void);
int iotx_dm_subdev_topo_del(_IN_ int devid);
int kk_dm_subdev_register(_IN_ int devid);
int kk_dm_subdev_unregister(_IN_ int devid);
int kk_dm_subdev_topo_add(_IN_ int devid);
int iotx_dm_subdev_topo_del(_IN_ int devid);
int iotx_dm_ccu_cloud_check(void);
int iotx_dm_dev_online(_IN_ int devid);
int iotx_dm_dev_offline(_IN_ int devid);
int iotx_dm_subdev_login(_IN_ int devid);
int iotx_dm_subdev_logout(_IN_ int devid);
void iotx_dm_dispatch(void);
int iotx_dm_connect(_IN_ iotx_dm_event_callback cb);
int iotx_dm_open(void);
int iotx_dm_subscribe(_IN_ int devid);
void kk_dm_ota_report_version(_IN_ int devid, char *version);
void kk_dm_ota_send(void *data, int len);
int kk_dm_get_property_type(const char* deviceCode,const char *key);
#endif
