#include "yjq_ezsp.h"
#include "./jsonrpc/rpccJSON.h"






static EmberVersion kk_ember_ver;
kk_EZSP_version_s kk_EZSP_ver;

#define EMBER_AF_PRINT_ENABLE
#define EMBER_AF_PRINT_APP 0x0002

void kk_set_ezsp_version_info(uint8_t hostEzspProtocolVer,
										uint8_t ncpEzspProtocolVer,
										uint8_t stackType,
										uint16_t stackVersion,
										EmberVersion *emberVer)
{
	kk_EZSP_ver.hostEzspProtocolVer = hostEzspProtocolVer;
	kk_EZSP_ver.ncpEzspProtocolVer = ncpEzspProtocolVer;
	kk_EZSP_ver.stackType = stackType;
	kk_EZSP_ver.stackVersion = stackVersion;
	if(emberVer!=NULL){
		MEMCOPY(&kk_ember_ver,emberVer,sizeof(EmberVersion));
		kk_EZSP_ver.emberVer = &kk_ember_ver;
	}else{
		MEMSET(&kk_ember_ver,0,sizeof(EmberVersion));
		kk_EZSP_ver.emberVer = NULL;
	}
	kk_EZSP_ver.emberVer = &kk_ember_ver;
}


void kk_print_version(void)
{
	kk_print_error("\r\nkk_print_version!!!!\r\n");

	if(kk_EZSP_ver.emberVer==NULL){

	}else{

	}
	
}

void kk_read_configuration_value(EzspConfigId id,const char* idStr)
{
	uint16_t value;
	EzspStatus status;
	status = ezspGetConfigurationValue(EZSP_CONFIG_BINDING_TABLE_SIZE,&value);
	if(idStr!=NULL){
		emberAfAppPrint("get %s ",idStr);
		if(status == EZSP_SUCCESS){
			emberAfAppPrintln("success,value=0x%04X",value);
		}else{
			emberAfAppPrintln("fail,status=%d",status);
		}
	}
}

void kk_read_ncp_configuration_with_memory_allocation(void)
{
	kk_read_configuration_value(EZSP_CONFIG_BINDING_TABLE_SIZE,"binding table size");

	kk_read_configuration_value(EZSP_CONFIG_KEY_TABLE_SIZE,"key table size");

	kk_read_configuration_value(EZSP_CONFIG_MAX_END_DEVICE_CHILDREN,"max end device children");

	kk_read_configuration_value(EZSP_CONFIG_APS_UNICAST_MESSAGE_COUNT,"aps unicast message count");

	kk_read_configuration_value(EZSP_CONFIG_BROADCAST_TABLE_SIZE,"broadcast table size");

	kk_read_configuration_value(EZSP_CONFIG_NEIGHBOR_TABLE_SIZE,"neighbor table size");
}

void kk_read_ncp_configuration_without_memory_allocation(void)
{
	kk_read_configuration_value(EZSP_CONFIG_END_DEVICE_POLL_TIMEOUT,"end device poll timeout");

	kk_read_configuration_value(EZSP_CONFIG_END_DEVICE_POLL_TIMEOUT_SHIFT,"end device poll timeout shift");
	
	kk_read_configuration_value(EZSP_CONFIG_ZLL_GROUP_ADDRESSES,"zll group addresses");
	
	kk_read_configuration_value(EZSP_CONFIG_ZLL_RSSI_THRESHOLD,"zll rssi threshold");
	
	kk_read_configuration_value(EZSP_CONFIG_TRANSIENT_KEY_TIMEOUT_S,"transient key timeout");
}



extern void kk_print_network_info(void);
extern void test_123(int val);
extern void kk_ota_test111();
extern void kk_ota_test123123123();
extern void aaaBBB();
extern void kk_tsl_msg_ack(const char * id,const char *ackMsgType,const char *productCode,const char *deviceCode);
extern void TEST2(void);




char aaaaaaaaaa[]="{\
			\"info\": {\
					\"msgtype\":		\"/thing/service/property/get\",\
					\"productCode\":	\"3003\",\
					\"deviceCode\":	\"1122334455667788\"\
			\},\
			\"payload\":		{\
					\"msgId\":		\"11\",\
					\"version\":		\"1.0\",\
					\"params\":		{\
							\"identifier\":	[\"PowerSwitch_1\", \"PowerSwitch_2\", \"PowerSwitch_3\"]\
					},\
					\"time\": \"1603359090\",\
					\"method\":		\"thing.service.property.get\"\
			}\
	}";
void TEST2(void)
{
	_cb(aaaaaaaaaa,strlen(aaaaaaaaaa),NULL);


/*
	char *ptr;
	cJSON *root = rpc_cJSON_CreateObject();
	cJSON *info = rpc_cJSON_CreateObject();
	cJSON *payload = rpc_cJSON_CreateObject();
	cJSON *params = rpc_cJSON_CreateObject();
	cJSON *array = rpc_cJSON_CreateArray();

	rpc_cJSON_AddItemToObject(root, "info", info);
	rpc_cJSON_AddItemToObject(root, "payload", payload);
	
	rpc_cJSON_AddStringToObject(info, "msgtype","/thing/service/property/get");
	rpc_cJSON_AddStringToObject(info, "productCode","83");
	rpc_cJSON_AddStringToObject(info, "deviceCode","1023");

	rpc_cJSON_AddStringToObject(payload, "msgId","123");
	rpc_cJSON_AddStringToObject(payload, "version","1.0");
	rpc_cJSON_AddItemToObject(payload, "params", params);

	rpc_cJSON_AddItemToObject(params, "identifier", array);

	
	rpc_cJSON_AddItemToArray(array,rpc_cJSON_CreateString("PowerSwitch_1"));
	rpc_cJSON_AddItemToArray(array,rpc_cJSON_CreateString("PowerSwitch_2"));
	rpc_cJSON_AddItemToArray(array,rpc_cJSON_CreateString("PowerSwitch_3"));

	rpc_cJSON_AddStringToObject(root, "method","thing.service.property.get");

	ptr = rpc_cJSON_Print(root);
	printf("--->%s\n",ptr);
	free(ptr);

	ncp_queue_enqueue(REV_MSG,(void *)root);
	*/
}

extern struct jrpc_server *kk_get_jrpc_server(void);

void aaaBBB()
{
	struct jrpc_server *server = kk_get_jrpc_server();

	char *ptr;
	const char *strings[3]={"PowerSwitch_1","PowerSwitch_2","PowerSwitch_3"};
	cJSON *params = rpc_cJSON_CreateObject();
	cJSON *id = rpc_cJSON_CreateObject();
	cJSON *mac = rpc_cJSON_CreateObject();

	cJSON *array = rpc_cJSON_CreateArray();
	rpc_cJSON_AddItemToArray(array,rpc_cJSON_CreateString("PowerSwitch_1"));
	rpc_cJSON_AddItemToArray(array,rpc_cJSON_CreateString("PowerSwitch_2"));
	rpc_cJSON_AddItemToArray(array,rpc_cJSON_CreateString("PowerSwitch_3"));

	rpc_cJSON_AddItemToObject(params, "identifier", array);
	rpc_cJSON_AddStringToObject(id, "msgId","123");
	rpc_cJSON_AddStringToObject(mac, "mac","1122334455667788");

	ptr = rpc_cJSON_Print(params);
	printf("params--->%s\n",ptr);
	free(ptr);
	ptr = rpc_cJSON_Print(id);
	printf("id--->%s\n",ptr);
	free(ptr);
	ptr = rpc_cJSON_Print(mac);
	mac = cJSON_GetObjectItem(mac, "mac");
	printf("mac--->%s,%s\n",ptr,mac->valuestring);
	free(ptr);
	kk_tsl_get_property_operation(server, params,id,mac);
}




void kk_message_process(char *messageString)
{
	if(messageString==NULL) return ;
	uint8_t len = strlen(messageString);

	emberAfAppPrintln("len=%d,messageString=%s",len,messageString);
	if(MEMCOMPARE(messageString,"AT+TXPOWER=",11)==0&&len==15){
		emberAfAppPrint("set txpower = 10\r\n" );
		setTxPower(10);
	}

	if(MEMCOMPARE(messageString,"AT+GETINFO\r\n",len)==0){
		kk_print_network_info();
	}
	if(MEMCOMPARE(messageString,"AT+MODE\r\n",len)==0){
		static int cnt = 1;
		if(cnt++>11) cnt =1;
		test_123(cnt);
	}	

	if(MEMCOMPARE(messageString,"AT+TEST1\r\n",len)==0){
		TEST2();
	}	
	if(MEMCOMPARE(messageString,"AT+TEST\r\n",len)==0){
		aaaBBB();
		kk_tsl_msg_ack("666","/thing/event/property/post_reply","123","456");

	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//api
/*
void printSourceRouteTable(void)
{
	uint8_t i;
	for (i = 0; i < sourceRouteTableSize; i++) {
		if (sourceRouteTable[i].destination != 0x0000) {
			emberAfCorePrintln("[ind]%x[dest]%2x[closer]%x[older]%x",
								i,
								sourceRouteTable[i].destination,
								sourceRouteTable[i].closerIndex,
								sourceRouteTable[i].olderIndex);
		}
		emberSerialWaitSend(APP_SERIAL);
	}
	emberAfCorePrintln("<print srt>");
	emberSerialWaitSend(APP_SERIAL);
}*/

//设置发射功率
void setTxPower(signed char dBm)
{
	if(emberSetRadioPower(dBm)==EMBER_SUCCESS){
		emberAfCorePrintln("set tx power suc,%d dbm",dBm);
	}else{
		emberAfCorePrintln("out of range,%d dbm",dBm);
	}
}
//clu cmd.clu=0x0000,cmd = 0x01,未知
/*
void zclBasicGlsCMD(void) {
	zclSimpleClientCommand( ZCL_BASIC_CLUSTER_ID,
							ZCL_GET_LOCALES_SUPPORTED_COMMAND_ID);
}

static void zclBasicGlsrCommand(void) {
	zclSimpleServerCommand( ZCL_BASIC_CLUSTER_ID,
							ZCL_GET_LOCALES_SUPPORTED_RESPONSE_COMMAND_ID);
}

static void zclBasicRtfdCommand(void) {
	zclSimpleClientCommand( ZCL_BASIC_CLUSTER_ID,
							ZCL_RESET_TO_FACTORY_DEFAULTS_COMMAND_ID);
}*/
//








