#ifndef __RPC_API_H
#define __RPC_API_H
#include "yjq_ezsp.h"
#include <stdio.h>
#include <pthread.h>




#include "./jsonrpc/jsonrpc-c.h"
#include "./jsonrpc/rpccJSON.h"



extern pthread_mutex_t g_mutex_lock;
extern pthread_mutex_t report_mutex_lock;

typedef cJSON(*rpc_function)(jrpc_context * ctx, cJSON * params, cJSON *id);


void zclBufferSetup(uint8_t frameType, uint16_t clusterId, uint8_t commandId);

#define zcl_clu_client_cmd_buffer_setup(clu, cmd)                                     \
	zclBufferSetup(ZCL_CLUSTER_SPECIFIC_COMMAND | ZCL_FRAME_CONTROL_CLIENT_TO_SERVER, \
					(clu),                                                            \
					(cmd))

#define zcl_clu_server_cmd_buffer_setup(clu, cmd)                                     \
	zclBufferSetup(ZCL_CLUSTER_SPECIFIC_COMMAND | ZCL_FRAME_CONTROL_SERVER_TO_CLIENT, \
					(clu),                                                            \
					(cmd))
					
void set_json_error_type(jrpc_context * ctx_p,int errorCode,char * errorMsg);

void rpcBufferPrint(void);
EmberStatus rpcSendCommand(uint16_t destination,uint8_t srcEndpoint,uint8_t dstEndpoint,bool multicast);

typedef struct{
	uint8_t *buffer;
	uint8_t *len;
	bool AStringType;
}rpc_read_attr_s;


char rpc_convert_char(char ch);
uint8_t rpc_get_u8(char *string);
uint16_t rpc_get_u16(char *string);
bool rpc_get_mac(char *string,uint8_t *mac);


EmberAfStatus ReadAttr(uint16_t node,
								uint8_t endpoint,
								EmberAfClusterId cluster,
								EmberAfAttributeId attribute,
								bool serverAttribute,
								rpc_read_attr_s *dataBuff);

cJSON *rpc_ReadAttr(jrpc_context * ctx, cJSON * params, cJSON *id);


#define RPC_COMMON_FUNCTION_TABLE	\
	{(rpc_function*)rpc_ReadAttr,"ReadAttr"}\


extern uint8_t appZclBuffer[];
extern uint16_t appZclBufferLen;
extern uint16_t mfgSpecificId ;
extern uint8_t disableDefaultResponse ;

extern EmberApsFrame globalApsFrame;



EmberStatus rpc_read_modleId(EmberNodeId nodeId);
EmberStatus rpc_read_ApplicationVersion(EmberNodeId nodeId);




uint8_t rpc_add_device(EmberNodeId nodeId);
uint8_t rpc_read_response_process_callback(EmberNodeId nodeId,
							uint8_t ep,
							EmberAfClusterId cluster,
							EmberAfAttributeId attribute,
							uint8_t dataType,
							uint8_t dataSize,
							uint8_t *data);








void rpc_printfJSON(char* str,cJSON* item);

void rpc_eui64ToString(EmberEUI64 eui, char* euiString);
void rpc_nodeIdToString(EmberNodeId nodeId, char* nodeIdString);
void rpc_clusterIdToString(EmberAfClusterId clusterId, char* clusterIdString);
void rpc_attributeIdToString(EmberAfAttributeId attributeId, char* attributeIdString);

char* rpc_createTwoByteHexString(uint16_t value);


void rpc_cJSON_AddMACToObject(cJSON *item,EmberEUI64 nodeEui64);
void rpc_cJSON_AddNodeToObject(cJSON *item,EmberNodeId nodeId);
void rpc_cJSON_AddEndpointToObject(cJSON *item,uint8_t endpoint);
void rpc_cJSON_AddClusterToObject(cJSON *item,EmberAfClusterId clusterId);
void rpc_cJSON_AddAttributeToObject(cJSON *item,EmberAfAttributeId attributeId);
void rpc_cJSON_AddDataTypeToObject(cJSON *item, uint8_t type);
void rpc_cJSON_AddLengthToObject(cJSON *item, uint8_t length);
void rpc_cJSON_AddDataToObject(cJSON *item,uint8_t *data,uint8_t length);
void rpc_cJSON_AddStatusToObject(cJSON *item, uint8_t status);
void rpc_cJSON_AddAppVersionToObject(cJSON *item,uint8_t ver);


#define RPC_APPVERSION_STRING_LENGTH 3 //

#define RPC_ENDPOINT_STRING_LENGTH 4 //0-255 + NULL
#define RPC_EUI64_STRING_LENGTH 19 //"0x" + 16 characters + NULL
#define RPC_NODEID_STRING_LENGTH 7 //"0x" + 4 characters + NULL
#define RPC_CLUSTERID_STRING_LENGTH 7 // "0x" + 4 chars + NULL
#define RPC_ATTRIBUTE_STRING_LENGTH 7 // "0x" + 4 chars + NULL
#define RPC_DATATYPE_STRING_LENGTH 4 //0-255 + NULL
#define RPC_LENGTH_STRING_LENGTH 4 //0-255 + NULL
#define RPC_STATUS_STRING_LENGTH 4 //0-255 + NULL











#endif

