/*
 * Copyright (C) 2020-2020 ikonke
 */

#ifndef _KK_COM_API_H_
#define _KK_COM_API_H_

#if defined(__cplusplus)
extern "C" {
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "ev.h"
#include "nn.h"
#include "pair.h"
#include "pubsub.h"
#include "pipeline.h"


//=====kk======================
typedef enum {
    IPC_APP2MID = 0,
    IPC_MID2APP,
    IPC_MID2PLAT,
    IPC_PLAT2MID,
    IPC_UNDEF
} ipc_type;
	
#define MSG_TYPE_STR              "msgtype"
#define MSG_PRODUCT_TYPE_STR      "productType"
#define MSG_PRODUCT_CODE_STR      "productCode"
#define MSG_DEVICE_CODE_STR       "deviceCode"
#define MSG_PAYLOAD_STR           "payload"
#define MSG_INFO_STR              "info"
#define MSG_INDENTIFIER_STR       "identifier"
#define MSG_PARAMS_STR            "params"
#define MSG_IOTClOUDSTATE_STR     "IOTCloudState"

typedef void ipc_cb(void* data, int len, char* chalMark);
int kk_ipc_init(ipc_type type, ipc_cb cb, char* chalMark, char* ip);
int kk_ipc_deinit();
int kk_ipc_send(ipc_type type, void* data, int len);
int kk_ipc_send_ex(ipc_type type, void* data, int len, char* chalMark);

#if defined(__cplusplus)
}
#endif
#endif
