#include <stdio.h>
#include "kk_ncp_common.h"
#include "kk_ncp_thread.h"
#include "kk_ncp_rpc.h"
#include "kk_ncp_queue.h"
#include "kk_zigbee_api.h"
#include "com_api.h"
#include "kk_tsl_property_get.h"

static void _msg_deal_from_mid(void)
{
	cJSON *root = NULL;
	char *cJsonStr;
	
	if(ncp_queue_dequeue(REV_MSG,&root)==0){
		
		cJsonStr = rpc_cJSON_Print(root);
		emberAfDebugPrintln("[dequeue-msgRev] cJson:\n%s\n",cJsonStr);
		free(cJsonStr);
		
		kk_jrpc_eval_request(root);
		rpc_cJSON_Delete(root);
	}
}

static void _get_prey_from_dev(void)
{
	int i;
	EmberStatus status;
	get_property_data_s *data;
	
	if(ncp_queue_dequeue(GET_PROPERTY,&data)==0){
		emberAfDebugPrintln("[dequeue-getPrey] data:");
		emberAfDebugPrintln("node = 0x%04X,ep=%d,clu=0x%04X,attr len=%d",
							data->node,data->ep,data->clu,data->len);
		for(int i=0;i<data->len;i++){
			emberAfDebugPrintln("attr[%d]:0x%04X\n",i,data->attr[i]);
		}

		status = zclGReadAttrs(data->node,1,data->ep,false,data->clu,data->len,data->attr,true);
		emberAfDebugPrintln("func call status:0x%02X",status);

		free(data->attr);
		free(data);
	}
}

static void ncp_queue_handle(void)
{
	UTIL_LOG_INFO("\nncp_queue_handle start~~~~~~~~~~~~~~~~~~~~\n");

	while(1){
		_msg_deal_from_mid();
		_get_prey_from_dev();
		usleep(100000);
	}
	
	UTIL_LOG_ERR("\nncp_queue_handle end!!!!!!!!!!!!!!!!!!!\n");
}
void ipc_handle(void)
{
	char* outbuf;
	char* postmsg;
	char* macString;

	UTIL_LOG_INFO("\nipc_handle start~~~~~~~~~~~~~~~~~~~~\n");

#ifdef GATEWAY_TYPE_NCP
	kk_jrpc_init();

	macString = kk_get_gw_mac();
	if (macString == NULL){
		UTIL_LOG_ERR("\n[%s] get mac fail, exit pthread !!!\n",__FUNCTION__);
		return;
	}

	kk_ipc_init(IPC_PLAT2MID, _cb, macString, "127.0.0.1");

	//send add gw to ccu
	outbuf = _msg_topo_add();
	if (outbuf == NULL){
		UTIL_LOG_ERR("\n[%s] topo add msg failed, exit\n",__FUNCTION__);
		return;
	}

	emberAfDebugPrintln("check nanomsg is connect(%d)", kk_ipc_isconnect(IPC_PLAT2MID));
	kk_ipc_send(IPC_PLAT2MID, outbuf, strlen(outbuf) + 1);
	free(outbuf);

	postmsg = _msg_event_property_post("127.0.0.1",0);
	if (postmsg == NULL){
		UTIL_LOG_ERR("\n[%s] property_post msg failed\n",__FUNCTION__);
		return;
	}
	kk_ipc_send(IPC_PLAT2MID, postmsg, strlen(postmsg) + 1);
	free(postmsg);

	//handle procidure
	while(1){
		usleep(20000);
	}
#else

	char deviceCode[33] = {0};
	char ip[16] = {0};
	int port = 0;
	int cnt = 0;

	search_ccu(deviceCode, ip, &port);
	
	kk_jrpc_init();
	
	macString = kk_get_gw_mac();
	if (macString == NULL){
		UTIL_LOG_ERR("\n[%s] get mac fail, exit pthread !!!\n",__FUNCTION__);
		return;
	}

	if(strcmp(GW2CCU_PROTOCOL, "tcp") == 0){
		kk_tcp_client_init(ip, port, _cb);
	}else{
		kk_ipc_init(IPC_PLAT2MID, _cb, macString, ip);
	}

	//send add gw to ccu
	outbuf = _msg_topo_add(); 
	if (outbuf == NULL){
		UTIL_LOG_ERR("\n[%s] topo add msg failed, exit\n",__FUNCTION__);
		return;
	}

	if (strcmp(GW2CCU_PROTOCOL, "tcp") != 0){
		emberAfDebugPrintln("check nanomsg is connect(%d)", kk_ipc_isconnect(IPC_PLAT2MID));
	}
	kk_sendData2CCU(outbuf, strlen(outbuf));
	free(outbuf);

	//handle procidure
	while(1){
		usleep(20000);
		if (++cnt == 2){
			sleep(1);
			char gwIp[17] = {0};
			HAL_Get_IP(gwIp,NULL);
			postmsg = _msg_event_property_post(gwIp,port);
			if (postmsg == NULL){
				UTIL_LOG_ERR("\n[%s] property_post msg failed\n",__FUNCTION__);
				continue;
			}
			kk_sendData2CCU(postmsg, strlen(postmsg));
			free(postmsg);
		}

		if (kk_connect_check()){
			//discover ccu
			search_ccu(deviceCode, ip, &port);
			if(strcmp(GW2CCU_PROTOCOL, "tcp") == 0){
				kk_tcp_client_init(ip, port, _cb);
			}else{
				kk_ipc_deinit(IPC_PLAT2MID);
				kk_ipc_init(IPC_PLAT2MID, _cb, macString/*GW_DEVICE_CODE*/, ip);
			}

			//send add gw to ccu
			outbuf = _msg_topo_add(); 
			if (outbuf == NULL){
				UTIL_LOG_ERR("\n[%s] topo add msg failed, exit\n",__FUNCTION__);
				return;
			}
			kk_sendData2CCU(outbuf, strlen(outbuf));
			free(outbuf);
			cnt = 0;
			kk_reset_retry_num();
		}
	}
#endif
	UTIL_LOG_ERR("\nipc_handle end!!!!!!!!!!!!!!!!!!!\n");
}

void kk_thread_init(void)
{
	pthread_t ipc_tid;
	pthread_t prey_tid;

	pthread_create(&ipc_tid, NULL, ipc_handle, NULL);
	pthread_create(&prey_tid, NULL, ncp_queue_handle, NULL);
}

