#include <stdio.h>
#include "kk_ncp_common.h"
#include "kk_ncp_msg.h"
#include "com_api.h"




void* _msg_event_property_post(char ip[16], int port)
{
	char msgFmt[] = "{\"info\":{\"msgtype\":\"/thing/event/property/post\",\"productCode\":\"%s\",\"deviceCode\":\"%s\"},\
                      \"payload\":{\"msgId\":\"%d\",\"version\":\"1.0\",\"params\":{\"NetChannelState\":%d,\"WhiteListState\":%d,\
                        \"OnlineDetectionState\":%d,\"SN\":\"%s\",\"IPAddress\":\"%s\",\"MACAddress\":\"%s\",\"Port\":%d},\
                        \"time\":1524448722000,\"method\":\"thing.event.property.post\"}\
                     }";

	char* msg = NULL;
	char* macString = kk_get_gw_mac();
	if (macString == NULL){
		emberAfDebugPrintln("[%s] get mac fail\n",__FUNCTION__);
		return NULL;
	}

	msg = malloc(620);
	if (msg == NULL){
		emberAfDebugPrintln("[%s] msg malloc fail\n",__FUNCTION__);
		return NULL;
	}
	
	sprintf(msg, msgFmt, GW_PRODUCT_CODE, macString,
				1, 0, 0, 0, "12345", ip,macString,port);
	return msg;
}

void* _msg_topo_add(void)
{
	char msgFmt[] = "{\"info\":{\"msgtype\":\"/thing/topo/add\",\"productCode\":\"%s\",\"deviceCode\":\"%s\"},\
                        \"payload\":{\"msgId\":\"%d\",\"version\":\"1.0\",\"params\":{\"deviceCode\":\"%s\",\"productCode\":\"%s\",\"mac\":\"%s\"}}}";

	char* msg = NULL;
	char* macString = kk_get_gw_mac();
	if (macString == NULL){
		emberAfDebugPrintln("[%s] get mac fail\n",__FUNCTION__);
		return NULL;
	}	
	msg = malloc(520);
	if (msg == NULL){
		emberAfDebugPrintln("[%s] msg malloc fail\n",__FUNCTION__);
		return NULL;
	}
	
	sprintf(msg, msgFmt, GW_PRODUCT_CODE, macString, 1, macString, GW_PRODUCT_CODE,macString);

	return msg;
}


int kk_sendData2CCU(char* data, int len)
{
	if (strcmp(GW2CCU_PROTOCOL,"tcp") == 0 ){
		kk_tcp_client_send(data, len);
	}else{
		kk_ipc_send(IPC_PLAT2MID, data, len + 1);
	}
}

int kk_tsl_send_msg(cJSON * msgJson)
{
	int return_value = 0;

	char * str_result = rpc_cJSON_Print(msgJson);

	emberAfAppPrintln("send tsl msg:\n%s\n",str_result);

	return_value = kk_sendData2CCU(str_result, strlen(str_result));
	free(str_result);
	
	return return_value;
}

void kk_tsl_msg_ack(const char * id,const char *ackMsgType,const char *productCode,const char *deviceCode)
{
	char *p_msgType;
	cJSON *root = rpc_cJSON_CreateObject();
	cJSON *info = rpc_cJSON_CreateObject();
	cJSON *payload = rpc_cJSON_CreateObject();
	cJSON *data = rpc_cJSON_CreateObject();
	
	rpc_cJSON_AddItemToObject(root,"info",info);
	rpc_cJSON_AddItemToObject(root,"payload",payload);
	int len = strlen(ackMsgType) + "_reply" + 1;
	p_msgType = (char *)malloc(len);
	memset(p_msgType,0,len);
	
	strcpy(p_msgType,ackMsgType);
	strcat(p_msgType,"_reply");
	
	rpc_cJSON_AddStringToObject(info, "msgType", p_msgType);
	rpc_cJSON_AddStringToObject(info, "productCode", productCode);
	rpc_cJSON_AddStringToObject(info, "deviceCode", deviceCode);

	rpc_cJSON_AddStringToObject(payload, "msgId", id);
	rpc_cJSON_AddNullToObject(payload, "code");
	rpc_cJSON_AddItemToObject(payload,"data", data);

	free(p_msgType);
	kk_tsl_send_msg(root);
	rpc_cJSON_Delete(root);
}




















