#ifndef _KK_SUBDEV_DB_H_
#define _KK_SUBDEV_DB_H_
#include "kk_tsl_common.h"

typedef struct {
	char deviceCode[DEVICE_CODE_MAXLEN];
	int SensorType;
} SensorType_t;
int kk_subDb_init(void);
int kk_subDev_insert_db(int devType,char productCode[PRODUCT_CODE_MAXLEN], \
										char deviceCode[DEVICE_CODE_MAXLEN],char fatherMac[DEVICE_MAC_MAXLEN],char mac[DEVICE_MAC_MAXLEN], char version[DEVICE_VERSION_MAXLEN],int heartbeat);

int kk_subDev_delete_byMac(char device_mac[DEVICE_MAC_MAXLEN]);
int kk_subDev_update_auth(int isAuth,const char *deviceCode);
int kk_subDev_update_sceneSupport(int sceneSupport,const char *deviceCode);
int kk_subDev_delete_by_dcode(char deviceCode[DEVICE_CODE_MAXLEN]);
int kk_subDev_update_productType(char *productType,const char *deviceCode);
int kk_subDev_update_auth(int isAuth,const char *deviceCode);
int kk_subDev_send_property_get_from_db(void);
int kk_subDev_send_property_get(const char *fatherDeviceCode);

int kk_subDev_check_scene_support(const char *deviceCode);
int kk_subDev_set_action_by_productType(const char *productType,const char *sceneId,const char *propertyName,const char *propertyValue,const char *type);
int kk_subDev_update_offline(int isOffline,const char *deviceCode);
int kk_subDev_getSensors_reply(SensorType_t*list);
int kk_load_subDevice(void);
enum{
	DB_SUB_IDX = 0,
	DB_SUB_ONLINE,
	DB_SUB_PRODUCTCODE,
	DB_SUB_DEVICECODE,
	DB_SUB_MAC,
	DB_SUB_FATHERDEVICECODE,
	DB_SUB_VERSION,
	DB_SUB_AUTH,
	DB_SUB_DEVTYPE,	
	DB_SUB_HEARTBEAT,	
	DB_SUB_PRODUCTTYPE,
	DB_SUB_SCENESUPPORT
};

#endif
