#ifndef __UART_PROTO_H__
#define __UART_PROTO_H__

#include <syslog.h>

#ifdef __cplusplus
extern "C"
{
#endif

#define GW_LOG(level, fmt, args...)   \
    do                                  \
    {                                   \
        syslog(level, fmt, ##args);     \
        printf("\n["__FILE__":%d] "fmt,__LINE__, ##args);           \
    } while(0)

#define GW_LOG_DBG(fmt, args...)      GW_LOG(LOG_DEBUG, fmt, ##args)
#define GW_LOG_ERR(fmt, args...)      GW_LOG(LOG_ERR, fmt, ##args)


//define protocal field size
#define PRO_SOF_SIZE                    2
#define PRO_CONTORL_FIELD_SIZE          1
#define PRO_LEN_SIZE                    2
#define PRO_CRC_SIZE                    2
#define PRO_SEQ_SIZE                    2

#define PRO_MIN_DATA_SIZE               4 // channel(1) + opcode(2) + args(1)

#define PRO_LINK_PAKCET_SIZE            13
#define PRO_APP_PACKET_MIN_SIZE         13

//define field index
#define PRO_SOF_INDEX                   0
#define PRO_LEN_INDEX                   (PRO_SOF_INDEX + PRO_SOF_SIZE)
#define PRO_CF_INDEX                    (PRO_LEN_INDEX + PRO_LEN_SIZE)
#define PRO_SEQ_INDEX                   (PRO_CF_INDEX + PRO_CONTORL_FIELD_SIZE)
#define PRO_DATA_INDEX                  (PRO_SEQ_INDEX + PRO_SEQ_SIZE)

//define SOF
#define PRO_SOF_1                       0xAA
#define PRO_SOF_2                       0x55

#define DEV_UART_RECV_BUFFER_SIZE 255


#define MAC_ADDR 0x00000

/***************OPCODE*******************/

#define OPCODE_CONNECT_STATUS_QUERY         0x0000  //ͨѶ״̬ѯ
#define OPCODE_BURN_MAC      0x0001
#define OPCODE_READ_MAC         0x0002
#define OPCODE_SET_SN       0x0003
#define OPCODE_GET_SN                0x0004
#define OPCODE_READ_VERSION          0x0005
#define OPCODE_EXIT_SUBBOARD_TEST          0x0006
#define OPCODE_READ_MAC_FROM_FLASH          0x0007
#define OPCODE_SYSTEM_RESTART          0x0008


/*********************************/

typedef enum
{
    E_Proto_OK = 0,
    E_Proto_ERROR,
} teProto_Status;


typedef struct
{
    uint8_t data_len;
    uint8_t data[DEV_UART_RECV_BUFFER_SIZE];
} uart_data_t;


typedef enum
{
    SOP_STATE1 = 0,
    SOP_STATE2,

    LENGTH_STATE1,
    LENGTH_STATE2,

    CONTROL_FIELD_STATE1,
    
    SEQ_STATE1,
    SEQ_STATE2,

    DATA_STATE,

    CRC16_STATE1,
    CRC16_STATE2,
} utp_state_t;

typedef struct
{
    uint8_t ack;
    uint8_t dir;
    uint8_t sof_flag;
    uint8_t mf_flag;
} control_field_t;

typedef struct
{
    uint16_t length;
    control_field_t cf;
    uint16_t seq;
    uint8_t ch;
    uint16_t opcode;
    uint16_t args_len;
    uint8_t arg[256];
} pro_data_t;

int my_system(const char * cmd);

uint32_t make_crc32(uint8_t *msg, uint16_t len);
uint16_t make_crc16(uint8_t *msg, uint16_t len);

uint8_t cf_to_uint8_t(control_field_t *cf);

uint8_t pro_check_uart_frame(uint8_t *data, uint16_t data_len);
void dev_send_uart(uint8_t *data, uint16_t data_len);
int get_proto_frame(uint8_t *data, uint16_t data_len, pro_data_t *pro_data);

void pro_send_link_ack(pro_data_t *pro_data);


uint8_t proto_frame_to_uart(pro_data_t *pro_data, uint8_t *uart_data);

int get_uart_frame(uint8_t * buf,int len);
void uart_frame_handle();

#ifdef __cplusplus
}
#endif

#endif /* __DEV_PROTO_H__ */

