#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include "oled_dp.h"

#define FileTMP "/dev/ssd1306-revision"

/*********************使用说明*******************/
/*
   结构体OLED_INFO?包含了需要显示的模式和内容，
   ?要选择需要的模式和内容填上，然后把整?文??   写到内核文件?解可以了?*/

OLED_INFO _g_oled_info = {0};

uint8_t chn_ch[25][32] =
{
    {0xFF,0x09,0x91,0x61,0x91,0x09,0x91,0x61,0x91,0x09,0xFF,0x00,0x0F,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x08,0x09,0x0F,0x00}, /* 0 ?*/
    {0x98,0xD4,0xB3,0x88,0x48,0xC4,0xAB,0x92,0xAA,0xC6,0x40,0x00,0x04,0x04,0x02,0x02,0x00,0x0F,0x04,0x04,0x04,0x0F,0x00,0x00}, /* 1 ?*/

    {0x00,0xFE,0x92,0x92,0xFE,0x00,0xFE,0x42,0xD2,0x52,0xCE,0x00,0x08,0x07,0x00,0x08,0x0F,0x00,0x0F,0x08,0x05,0x02,0x0D,0x00}, /* 2 ?*/
    {0x20,0xA4,0x92,0x97,0xEA,0x8A,0x8A,0x96,0x92,0x20,0x20,0x00,0x00,0x08,0x04,0x03,0x00,0x00,0x08,0x08,0x07,0x00,0x00,0x00}, /* 3 ?*/

    {0x00,0x02,0xE2,0x02,0x02,0xFE,0x42,0x42,0x42,0x42,0x00,0x00,0x08,0x08,0x0F,0x08,0x08,0x0F,0x08,0x08,0x08,0x08,0x08,0x00}, /* 4 ?*/
    {0x0C,0x04,0x75,0x56,0x54,0xD7,0x54,0x56,0x75,0x04,0x0C,0x00,0x00,0x07,0x01,0x01,0x01,0x0F,0x01,0x01,0x05,0x07,0x00,0x00}, /* 5 ?*/

    {0x00,0xF8,0x88,0x88,0x88,0xFF,0x88,0x88,0x88,0xF8,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x01,0x00,0x00}, /* 6 ?*/
    {0xFC,0x92,0x54,0xFF,0x54,0x92,0x00,0xFE,0x12,0xF2,0x11,0x00,0x07,0x04,0x04,0x07,0x04,0x04,0x08,0x07,0x00,0x0F,0x00,0x00}, /* 7 ?*/
    
    {0x82,0xBA,0xA2,0xB6,0xAA,0xEB,0xAA,0xB6,0xA2,0xBA,0x82,0x00,0x0F,0x00,0x04,0x06,0x05,0x04,0x06,0x0C,0x00,0x08,0x0F,0x00}, /* 8 ?*/
    {0x98,0xD4,0xB3,0x88,0x00,0x48,0x48,0xFF,0x24,0xA5,0x26,0x00,0x04,0x04,0x02,0x02,0x08,0x08,0x04,0x03,0x05,0x08,0x0E,0x00}, /* 9 ?*/

    {0x00,0x1F,0x25,0xE5,0x25,0x25,0x25,0x25,0xE5,0x27,0x30,0x00,0x01,0x09,0x05,0x03,0x01,0x01,0x01,0x01,0x0F,0x01,0x01,0x00}, /* 10 ?*/
    {0x0C,0x04,0x75,0x56,0x54,0xD7,0x54,0x56,0x75,0x04,0x0C,0x00,0x00,0x07,0x01,0x01,0x01,0x0F,0x01,0x01,0x05,0x07,0x00,0x00}, /* 11 ?*/
    
    {0x00,0x88,0x88,0x88,0x89,0xFA,0x88,0x88,0x88,0x88,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x0F,0x08,0x08,0x08,0x08,0x08,0x00}, /* 12 */
    {0x88,0x68,0xFF,0x28,0x40,0xFE,0x02,0x02,0xFE,0x00,0x00,0x00,0x00,0x00,0x0F,0x08,0x04,0x03,0x00,0x00,0x07,0x08,0x0E,0x00}, /* 13 */
    
	{0x20,0x24,0x24,0xA4,0xE4,0x3F,0x34,0x2C,0x24,0xA2,0x20,0x00,0x04,0x02,0x01,0x00,0x07,0x0A,0x0A,0x09,0x09,0x08,0x0E,0x00}, /*"",14*/
	{0x20,0x10,0xFC,0x03,0x00,0x80,0xFF,0x20,0x10,0x08,0x04,0x00,0x00,0x00,0x0F,0x00,0x01,0x00,0x07,0x08,0x08,0x08,0x0E,0x00}, /*"",15*/
	{0x00,0xF8,0x88,0x88,0x88,0xFF,0x88,0x88,0x88,0xF8,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x01,0x00,0x00}, /*"",16*/

	{0xC2,0xAE,0x9A,0xFF,0x9A,0xAE,0xC4,0xAB,0x92,0xAE,0xC2,0x00,0x08,0x08,0x0E,0x08,0x08,0x0F,0x0A,0x0A,0x0A,0x0A,0x08,0x00}, /*"",17*/ /* 13 */
	{0x00,0xC4,0x44,0x54,0x65,0x46,0x44,0x64,0x54,0x44,0x44,0x00,0x08,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, /*"",18*/
	{0x22,0x44,0xFE,0x02,0xFA,0x02,0xFE,0x00,0xFC,0x00,0xFF,0x00,0x04,0x02,0x09,0x04,0x03,0x04,0x09,0x00,0x01,0x08,0x0F,0x00}, /*"",19*/

    {0x00,0x7C,0x55,0x56,0x54,0xFC,0x54,0x56,0x55,0x7C,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x0F,0x01,0x01,0x01,0x01,0x01,0x00},/*"",0*/

    {0x88,0x68,0xFF,0x28,0x40,0xFE,0x12,0xF2,0x12,0x91,0x71,0x00,0x00,0x00,0x0F,0x08,0x04,0x03,0x08,0x05,0x02,0x05,0x08,0x00},/*"",1*/

    {0x80,0x80,0x88,0x88,0x88,0x88,0x88,0xFF,0x88,0x88,0x88,0x88,0x88,0x80,0x80,0x00,0x20,0x20,0x10,0x08,0x04,0x02,0x01,0xFF,0x01,0x02,0x04,0x08,0x10,0x20,0x20,0x00},/*"δ",22*/
    {0xF0,0x00,0xFF,0x20,0x10,0x00,0x88,0x88,0x4F,0x58,0x24,0x54,0x84,0xE4,0x00,0x00,0x80,0x70,0x0F,0x10,0x20,0x82,0x42,0x32,0x0E,0x02,0x02,0x3E,0x42,0x42,0x72,0x00},/*"",23*/
    {0x80,0x80,0x82,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0xFE,0x80,0x80,0x80,0x00,0x40,0x40,0x22,0x24,0x10,0x48,0x80,0x7F,0x04,0x08,0x18,0x24,0x22,0x40,0x40,0x00},/*"¼",24*/

};


void arry_copy(uint8_t *arry_out, uint8_t *arry_in, int len)
{
#if 1
    memcpy(arry_out, arry_in, len);
#else
    int i;
    int arry_len = len;
    for (i = 0; i < arry_len;i ++)
    {
        arry_out[i] = arry_in[i];
    }
#endif
}

void sleep_screen(void)
{
    _g_oled_info.oled_oper_mode = oled_sleep;
    write1306();
}

void wakeup_screen(void)
{
    _g_oled_info.oled_oper_mode = oled_wakeup;
    write1306();
}

void clear_screen(void)
{
    _g_oled_info.oled_oper_mode = oled_clear;
    write1306();
}

void fill_screen(uint8_t fill_data)
{
    _g_oled_info.oled_oper_mode = oled_clear;
    _g_oled_info.fill_char = fill_data;
    write1306();
}

void show_str_set(char *str, uint8_t x, uint8_t y, uint8_t strsize)
{
    _g_oled_info.oled_oper_mode = oled_show_str;

    _g_oled_info.str_info.pos_x = x;
    _g_oled_info.str_info.pos_y = y;

    _g_oled_info.str_info.str_size = strsize;

    strcpy((char *)_g_oled_info.str_info.str, str);

    write1306();
}

void show_chn_set(uint8_t x, uint8_t y, uint8_t num, uint8_t size)
{
    //printf("set oled chn\n");
	_g_oled_info.oled_oper_mode = oled_show_chn;

	_g_oled_info.chn_info.pos_x = x;
	_g_oled_info.chn_info.pos_y = y;

	arry_copy(_g_oled_info.chn_info.chn, chn_ch[num], 32);

	_g_oled_info.chn_info.chn_size = size;

	write1306();
}

void show_bmp_set(uint8_t x, uint8_t y, uint8_t x1, uint8_t y1, uint8_t bmp[], uint16_t bmp_len)
{
    _g_oled_info.oled_oper_mode = oled_show_bmp;

    _g_oled_info.bmp_info.start_x = x;
    _g_oled_info.bmp_info.start_y = y;

    _g_oled_info.bmp_info.end_x = x1;
    _g_oled_info.bmp_info.end_y = y1;

    arry_copy(_g_oled_info.bmp_info.bmp, bmp, bmp_len);

    _g_oled_info.bmp_info.len = bmp_len;

    write1306();
}

void write1306(void)
{
    int fd = -1;            

    if (!(fd = open(FileTMP, O_RDWR)))
    {
        // printf("can't open the file %s\n", FileTMP);
    }

    // fseek(fp, 0, SEEK_END);
    write(fd, &(_g_oled_info), sizeof(_g_oled_info));
    close(fd);
}

