#include "include/curl.h"

size_t kk_write_func(void *ptr, size_t size, size_t nmemb, FILE *stream)
{
    return fwrite(ptr, size, nmemb, stream);
} 
 
int kk_progress_func(char *progress_data,
                     double t, /* dltotal */
                     double d, /* dlnow */
                     double ultotal,
                     double ulnow)
{
    printf("%s %g / %g (%g %%)\n", progress_data, d, t, d*100.0/t);
    return 0;
}
 
int main(int argc, char **argv)
{
    CURL *curl;
    CURLcode res;
    FILE *outfile;
    char *url = argv[1];//"https://pics0.baidu.com/feed/6609c93d70cf3bc7fecc2bfb9d12faa6cc112af6.jpeg?token=517920fbf7c2fef6ff3ab5ff55bbd8d7";
    char *progress_data = "* ";

    if (argc < 3){
        printf("==inpunt params error, Usage:example_curl <url> <fileName> \n");
        return 0;
    }

    curl = curl_easy_init();
    if(curl)
    {
        outfile = fopen(argv[2], "wb");//fopen("test.jpg", "wb");

        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, outfile);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, kk_write_func);
        curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 0);
        curl_easy_setopt(curl, CURLOPT_PROGRESSFUNCTION, kk_progress_func);
        curl_easy_setopt(curl, CURLOPT_PROGRESSDATA, progress_data);

        res = curl_easy_perform(curl);

        fclose(outfile);
        /* always cleanup */
        curl_easy_cleanup(curl);
    }
    return 0;
}

