#ifndef _LOGDEF_H_
#define _LOGDEF_H_
#ifdef __cplusplus
extern "C" {
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <memory.h>
#include <syslog.h>
#include <pthread.h>
#include <unistd.h>
#include <sys/prctl.h>
#include <sys/time.h>
#include <semaphore.h>
#include <errno.h>
#include <assert.h>
#include <net/if.h>       // struct ifreq
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <sys/reboot.h>
#include <sys/time.h>
#include <time.h>
#include <signal.h>
static int g_enable_printf = 1;
#define LOG_STRING(level)          ((level == LOG_EMERG) ? "EMERG   " :                         \
                                    (level == LOG_ALERT) ? "ALERT   " :                         \
                                    (level == LOG_CRIT) ? "CRIT    " :                          \
                                    (level == LOG_ERR) ? "ERR     " :                           \
                                    (level == LOG_WARNING) ? "WARNING " :                       \
                                    (level == LOG_NOTICE) ? "NOTICE  " :                        \
                                    (level == LOG_INFO) ? "INFO    " :                          \
                                    (level == LOG_DEBUG) ? "DEBUG   " : "NONE    ")

#define KK_LOG(level,fmt,args...)   do {\
                time_t t;  																		\
				t = time(NULL);                                                                  \
                struct tm ptm;                                                                         \
                memset(&ptm, 0, sizeof(ptm));                                                          \
                localtime_r(&t, &ptm);                                                                 \
                syslog(level,"%s %4d-%02d-%02d %02d:%02d:%02d  [%s:%d]:" fmt ,LOG_STRING(level),   \
                    ptm.tm_year + 1900, ptm.tm_mon + 1, ptm.tm_mday, ptm.tm_hour,ptm.tm_min, ptm.tm_sec,\
                    __FILE__,__LINE__,##args);\
                if(g_enable_printf == 1){\
                    printf("%s %4d-%02d-%02d %02d:%02d:%02d  [%s:%d]:" fmt ,LOG_STRING(level), \
                        ptm.tm_year + 1900, ptm.tm_mon + 1, ptm.tm_mday, ptm.tm_hour,ptm.tm_min,    \
                        ptm.tm_sec,__FILE__,__LINE__,##args);\
                }}while(0)

#define DEBUG_PRINT(fmt, args...)          KK_LOG(LOG_DEBUG, fmt, ##args)
#define INFO_PRINT(fmt, args...)           KK_LOG(LOG_INFO, fmt, ##args)
#define ERROR_PRINT(fmt, args...)          KK_LOG(LOG_ERR, fmt, ##args)
#define WARNING_PRINT(fmt, args...)        KK_LOG(LOG_WARNING, fmt, ##args)				

#ifdef __cplusplus
}
#endif
#endif


