

#include "kk_log.h"

#include "klist.h"
#include "kk_product.h"
#include "com_api.h"
#include "kk_opcode.h"
#include "kk_lan_ctrl.h"
#include "kk_data_mng.h"

#include "kk_newccu_msg.h"
#include "kk_product.h"



cJSON *property_info_build(const char *msgtype,const char *productCode,const char *deviceCode)
{
	cJSON *info=cJSON_CreateObject();

	cJSON_AddStringToObject(info, "msgtype", msgtype);
	cJSON_AddStringToObject(info, "productCode",productCode);
	cJSON_AddStringToObject(info, "deviceCode",deviceCode);
	
	return info;
}
cJSON *property_payload_build(const char*method,const char *msgId,const char *version,cJSON *params)
{
	cJSON *payload=cJSON_CreateObject();

	cJSON_AddStringToObject(payload, "msgId",msgId);
	cJSON_AddStringToObject(payload, "version",version);
	cJSON_AddItemToObject(payload,PARAMS_STRING,params);
	cJSON_AddStringToObject(payload, "method",method);
	
	return payload;
}



cJSON * property_set(const char *productCode,const char *deviceCode,const char *msgId,const char *version,cJSON *params)
{
	cJSON *root = cJSON_CreateObject();
	cJSON *info = property_info_build("/thing/service/property/set",productCode,deviceCode);
	cJSON *payload = property_payload_build("thing.service.property.set",msgId,version,params);

	cJSON_AddItemToObject(root,INFO_STRING,info);
	cJSON_AddItemToObject(root,PAYLOAD_STRING,payload);

	return root;
}


cJSON * property_report(const char *productCode,const char *deviceCode,const char *msgId,const char *version,cJSON *params)
{
	cJSON *root=cJSON_CreateObject();
	cJSON *info = property_info_build("/thing/event/{tsl.event.identifier}/post",productCode,deviceCode);
	cJSON *payload = property_payload_build("thing.event.{tsl.event.identifier}.post",msgId,version,params);

	cJSON_AddItemToObject(root,INFO_STRING,info);
	cJSON_AddItemToObject(root,PAYLOAD_STRING,payload);

	return root;
}


cJSON *scene_payload_build(const char*method,const char *msgId,cJSON *params)
{
	cJSON *payload=cJSON_CreateObject();

	cJSON_AddStringToObject(payload, "productCode",KK_CCU_PRODUCTID);
	cJSON_AddStringToObject(payload, "deviceCode",KK_CCU_ID);
	cJSON_AddStringToObject(payload, "identity","executeScene");

	cJSON_AddStringToObject(payload, "msgId",msgId);
	cJSON_AddStringToObject(payload, "version",KK_LAN_VERSION);
	
	cJSON_AddStringToObject(payload, "method",method);
	cJSON_AddItemToObject(payload,PARAMS_STRING,params);
	
	return payload;
}



cJSON * scene_execute(const char *sceneId)
{
	char msgId[32] = {0};
	
	cJSON *root=cJSON_CreateObject();
	cJSON *params=cJSON_CreateObject();
	cJSON *info,*payload;

	printf("[execute scene]sceneId=%s\n",sceneId);
	kk_lan_get_msg_id_str(msgId,sizeof(msgId));
	cJSON_AddStringToObject(params,"sceneId",sceneId);

	info = property_info_build("/thing/service/executeScene",KK_CCU_PRODUCTID,KK_CCU_ID);
	payload = scene_payload_build("thing.service.executeScene",msgId,params);

	cJSON_AddItemToObject(root,INFO_STRING,info);
	cJSON_AddItemToObject(root,PAYLOAD_STRING,payload);

	return root;
}


//向midware发送数据
int kk_ipc_send_json(cJSON *root)
{
	char *msg;

	if(root==NULL){
		return -1;
	}
	
	msg=cJSON_Print(root);
	printf("[lan->midware]json:\n%s\n",msg);
	cJSON_Minify(msg);
	kk_ipc_send(IPC_APP2MID, msg, strlen(msg)+1);
	free(msg);
	
	return 0;
}





















