
#ifndef KK_DATA_MNG_H_
#define KK_DATA_MNG_H_
#include "kk_log.h"
#include "cJSON.h"
#include "klist.h"
#include "kk_product.h"
#include "com_api.h"
#include "kk_opcode.h"
typedef struct {
	cJSON *json;
	cJSON *newccu;
	cJSON *oldccu;
	unsigned char online_status;
	int channelNum;
	int syn_type;
	char *syn_opcode;
	char gwDeviceCode[DEVICE_CODE_LEN];
	char productCode[PRODUCT_CODE_LEN];
	char deviceCode[DEVICE_CODE_LEN];
	char opearteType[8];
	
	struct list_head linked_list;
} kk_map_dev_node_t;

typedef struct {
	void *mutex;
	struct list_head dev_list;
} kk_map_dev_ctx;

kk_map_dev_node_t *kk_map_dev_node_add(const char *deviceCode,const char *productCode,const char *gwdeviceCode,const char *onlineStatus);
int kk_create_devicestatus_to_sdk(cJSON *root);
int kk_create_devices_to_sdk(cJSON *root);
int _deviceCode_switchto_mac(char * deviceCode,char *mac);
int mac_switchto_deviceCode(char *mac,char * deviceCode);

kk_map_dev_ctx *_kk_map_dev_ctx(void);
int kk_map_dev_init(void);
#endif