/************************************************************
*版权所有 （C）2020，公司（或个人）名称
*
*文件名称： kk_sync_data.c
*内容摘要： 数据同步处理相关
*其他说明： 
*当前版本：  
*************************************************************/

#include <stdio.h>
#include "kk_tsl_api.h"
#include "kk_sync_data.h"
#include "kk_dm_mng.h"
#include "kk_scene_handle.h"
#include "kk_scene_db.h"
#include "sqlite3.h"
#include "kk_log.h"
#include "cJSON.h"
#include "kk_property_db.h"
#include "kk_tsl_api.h"
#include "kk_area_handle.h"
#include "kk_sub_db.h"
#include "kk_hal.h"
extern sqlite3 *g_kk_pDb;

typedef struct {
    void *mutex;
    sqlite3 *pDb;	
} kk_sync_ctx_t;

static kk_sync_ctx_t s_kk_sync_ctx = {NULL,NULL};
static kk_sync_ctx_t *_kk_sync_get_ctx(void)
{
    return &s_kk_sync_ctx;
}
static void _kk_sync_lock(void)
{
    kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
    if (ctx->mutex) {
        HAL_MutexLock(ctx->mutex);
    }
}

static void _kk_sync_unlock(void)
{
    kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
    if (ctx->mutex) {
        HAL_MutexUnlock(ctx->mutex);
    }
}

/************************************************************
*功能描述：同步数据模块初始化
*输入参数：无
*输出参数：无
*返 回 值：0:成功；其他：失败
*其他说明：
*************************************************************/
int kk_sync_init(void)
{
	//int res = 0;
    kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
    /* Create Mutex */
    ctx->mutex = HAL_MutexCreate();
    if (ctx->mutex == NULL) {
        return FAIL_RETURN;
    }
	ctx->pDb = g_kk_pDb;
	return SUCCESS_RETURN;
}
static int kk_get_rooms_devices(cJSON *roomDevicesArray,char *roomId)
{
	char *sqlCmd = NULL;	
	sqlite3_stmt *stmt;	
	char *deviceCode = NULL;
	cJSON *deviceObj = NULL;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();	
	if(roomDevicesArray == NULL || roomId == NULL){
		return FAIL_RETURN;
	}
	sqlCmd = sqlite3_mprintf("select * from AreaDevInfo where roomId = '%s'",roomId);
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		deviceObj = cJSON_CreateObject();
        deviceCode = (char*)sqlite3_column_text(stmt, DB_DEV_DEVICECODE);
		cJSON_AddStringToObject(deviceObj, KK_SYNC_DEVICECODE_STR, deviceCode);		
	}	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;
}
static int kk_get_rooms_info(cJSON *data)
{
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;	
	char *roomId = NULL;
	char *roomName = NULL;
	//int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();	
	if(data == NULL){
		return FAIL_RETURN;
	}
	cJSON *rooms = cJSON_CreateArray();
	cJSON *roomItem = cJSON_CreateObject();
	cJSON *roomDevicesArray = cJSON_CreateArray();	
	_kk_sync_lock();
	sqlCmd = sqlite3_mprintf("select * from AreaInfo");	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
        roomId = (char*)sqlite3_column_text(stmt, DB_ROOM_ID);
		roomName = (char*)sqlite3_column_text(stmt, DB_ROOM_NAME);
		cJSON_AddStringToObject(roomItem, KK_SYNC_ROOMID_STR, roomId);
		cJSON_AddStringToObject(roomItem, KK_SYNC_NANE_STR, roomName);
		kk_get_rooms_devices(roomDevicesArray,roomId);		
	}
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	_kk_sync_unlock();	
	cJSON_AddItemToObject(roomItem, KK_SYNC_DEVICES_STR, roomDevicesArray);


	cJSON *sceneId = cJSON_CreateObject();
	cJSON_AddStringToObject(sceneId, KK_SYNC_SCENEID_STR, "sceneId");
	cJSON *scenes = cJSON_CreateArray();	
	cJSON_AddItemToArray(scenes, sceneId);
	cJSON_AddItemToObject(roomItem, KK_SYNC_SCENE_STR, scenes);
	cJSON_AddItemToArray(rooms, roomItem);	
	cJSON_AddItemToObject(data, KK_SYNC_ROOMS_STR, rooms);
	return SUCCESS_RETURN;			
}
static int kk_get_properties_info(char *deviceCode,cJSON *obj)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();		
	if(deviceCode == NULL || obj == NULL){
		return FAIL_RETURN;
	}
	cJSON *propertyItem = cJSON_CreateObject();
	sqlCmd = sqlite3_mprintf("select * from PropertiesInfo WHERE deviceCode = '%s' ",deviceCode);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
        propertyStr = (char*)sqlite3_column_text(stmt, DB_IDENTIFITER);
		valueType = sqlite3_column_int(stmt, DB_VALUETYPE);
		valueStr = (char*)sqlite3_column_text(stmt, DB_VALUE);
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		if(valueType == KK_TSL_DATA_TYPE_TEXT){
			cJSON_AddStringToObject(propertyItem, propertyStr, valueStr);
		}else if(valueType == KK_TSL_DATA_TYPE_INT||
            valueType == KK_TSL_DATA_TYPE_ENUM||
            valueType == KK_TSL_DATA_TYPE_BOOL){
			cJSON_AddNumberToObject(propertyItem, propertyStr, atoi(valueStr));
		}
	}	
	cJSON_AddItemToObject(obj, KK_SYNC_PROPERTY_STR, propertyItem);
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;
}

static int kk_get_sub_devices_info(cJSON *gwdevicesItem,char *deviceCode)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	char *subDeviceCode = NULL;	
	char *subProductCode = NULL;
	char *subVersion = NULL;
	char *subIsline = NULL;	
	if(gwdevicesItem == NULL || deviceCode == NULL){
		return FAIL_RETURN;
	}
	cJSON *subDevices = cJSON_CreateArray();
	#if 1
	sqlCmd = sqlite3_mprintf("select * from SubDeviceInfo WHERE fatherDeviceCode = '%s' ",deviceCode);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *subdevicesItem = cJSON_CreateObject();
        subDeviceCode = (char*)sqlite3_column_text(stmt, DB_SUB_DEVICECODE);
        subProductCode = (char*)sqlite3_column_text(stmt, DB_SUB_PRODUCTCODE);	
		subVersion = (char*)sqlite3_column_text(stmt, DB_SUB_VERSION);
        subIsline = (char*)sqlite3_column_text(stmt, DB_SUB_ONLINE);				
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_DEVICECODE_STR, subDeviceCode);	
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_VERSION_STR, subVersion);
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_MAC_STR, subDeviceCode);	
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_NANE_STR, "SUBDEV");	
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_ONLINE_STR, subIsline);	
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_PRODUCTCODE_STR, subProductCode);	
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_SN_STR, "");	
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_STATUS_STR, "启动");
		kk_get_properties_info(subDeviceCode,subdevicesItem);
		cJSON_AddItemToArray(subDevices, subdevicesItem);			
	}	
	#endif
	cJSON_AddItemToObject(gwdevicesItem, KK_SYNC_DEVICES_STR, subDevices);
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;
}
static int kk_get_gw_devices_info(cJSON *gwdevices)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	//cJSON *gwdevicesItem = NULL;
	char *gw_deviceCode = NULL;
	char *gw_productCode = NULL;
	char *gw_version = NULL;	
	char *gw_isline = NULL;		
	//char *valueStr = NULL;
	//int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();	
	if(gwdevices == NULL){
		return FAIL_RETURN;
	}

	_kk_sync_lock();
	sqlCmd = sqlite3_mprintf("select * from SubDeviceInfo WHERE devType = '%d' ",KK_DM_DEVICE_GATEWAY);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *gwdevicesItem = cJSON_CreateObject();
        gw_deviceCode = (char*)sqlite3_column_text(stmt, DB_SUB_DEVICECODE);
        gw_productCode = (char*)sqlite3_column_text(stmt, DB_SUB_PRODUCTCODE);	
		gw_version = (char*)sqlite3_column_text(stmt, DB_SUB_VERSION);
        gw_isline = (char*)sqlite3_column_text(stmt, DB_SUB_ONLINE);	
		printf("gw_deviceCode:%s\n",gw_deviceCode);		
		printf("gw_productCode:%s\n",gw_productCode);		
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_DEVICECODE_STR, gw_deviceCode);	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_VERSION_STR, gw_version);
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_MAC_STR, gw_deviceCode);	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_NANE_STR, "GW");	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_ONLINE_STR, gw_isline);	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_PRODUCTCODE_STR, gw_productCode);	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_SN_STR, "");	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_STATUS_STR, "启动");
		kk_get_properties_info(gw_deviceCode,gwdevicesItem);
		kk_get_sub_devices_info(gwdevicesItem,gw_deviceCode);
		cJSON_AddItemToArray(gwdevices, gwdevicesItem);			
	}	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	_kk_sync_unlock();
	return SUCCESS_RETURN;
}
static int kk_get_devices_info(cJSON *data)
{
	if(data == NULL){
		return FAIL_RETURN;
	}
	cJSON *gwdevices = cJSON_CreateArray();	
	kk_get_gw_devices_info(gwdevices);
	cJSON_AddItemToObject(data, KK_SYNC_DEVICES_STR, gwdevices);	
	return SUCCESS_RETURN;		
}
static int kk_get_scenes_actions_info(cJSON *actionArray )
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;
	char *deviceCode = NULL;
	char *propertyName = NULL;
	char *propertyValue = NULL;	
	char *type = NULL;
	int delay = 0,epNum = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();			
	if(actionArray == NULL){
		return FAIL_RETURN;
	}
	sqlCmd = sqlite3_mprintf("select * from SceneActionInfo");	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *actionItem = cJSON_CreateObject();
        deviceCode = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_DEVICECODE);
        delay = sqlite3_column_int(stmt, DB_SCENEACTION_DELAY);	
		epNum = sqlite3_column_int(stmt, DB_SCENEACTION_EPNUM);
        propertyName = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_PROPERTYNAME);
	    propertyValue = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_PROPERTYVALUE);	
		type = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_TYPE);			
		cJSON_AddStringToObject(actionItem, KK_SYNC_DEVICECODE_STR, deviceCode);	
		cJSON_AddNumberToObject(actionItem, KK_SYNC_SCENE_DELAY_STR, delay);
		cJSON_AddNumberToObject(actionItem, KK_SYNC_SCENE_EPNUM_STR, epNum);	
		cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_PROPERTYNAME_STR, propertyName);	
		cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_TYPE_STR, type);	
		cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_PROPERTYVALUE_STR, propertyValue);	
		cJSON_AddStringToObject(actionItem, KK_SYNC_ROOMID_STR, "");	
		cJSON_AddItemToArray(actionArray, actionItem);			
	}	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;	
}
static int kk_get_scenes_trigger_info(cJSON *triggerArray,char *sceneId)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;
	char *deviceCode = NULL;
	char *propertyName = NULL;
	char *compareType = NULL;	
	char *compareValue = NULL;		
	//char *type = NULL;
	int epNum = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();			
	if(triggerArray == NULL || sceneId == NULL){
		return FAIL_RETURN;
	}
	sqlCmd = sqlite3_mprintf("select * from SceneTriggerInfo where sceneId = %s",sceneId);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *triggerItem = cJSON_CreateObject();
        deviceCode = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_DEVICECODE);
		epNum = sqlite3_column_int(stmt, DB_SCENETRIGGER_EPNUM);
        propertyName = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_PROPERTYNAME);
	    compareType = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_COMPARETYPE);
	    compareValue = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_COMPAREVALUE);	
		//type = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_TYPE);			
		cJSON_AddStringToObject(triggerItem, KK_SYNC_DEVICECODE_STR, (char*)deviceCode);	
		cJSON_AddNumberToObject(triggerItem, KK_SYNC_SCENE_EPNUM_STR, epNum);	
		cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_PROPERTYNAME_STR, (char*)propertyName);	
		cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_COMPARETYPE_STR, (char*)compareType);	
		cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_COMPAREValue_STR, (char*)compareValue);		
		cJSON_AddItemToArray(triggerArray, triggerItem);			
	}	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;	
}
static int kk_get_scenes_condition_info(cJSON *conditionArray,char *sceneId)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;
	int starttime = 0;
	int endtime = 0;	
	int crossDay = 0;		
	int repeat = 0;

	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();			
	if(conditionArray == NULL || sceneId == NULL){
		return FAIL_RETURN;
	}
	sqlCmd = sqlite3_mprintf("select * from SceneConditionInfo where sceneId = %s",sceneId);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *conditionItem = cJSON_CreateObject();
        starttime = sqlite3_column_int(stmt, DB_SCENECONDITION_STARTTIME);
	    endtime = sqlite3_column_int(stmt, DB_SCENECONDITION_ENDTIME);
	    crossDay = sqlite3_column_int(stmt, DB_SCENECONDITION_CROSSDAY);
		repeat = sqlite3_column_int(stmt, DB_SCENECONDITION_REPEATDAY);		
		cJSON_AddNumberToObject(conditionItem, KK_SYNC_SCENE_STARTTIME_STR, starttime);	
		cJSON_AddNumberToObject(conditionItem, KK_SYNC_SCENE_ENDTIME_STR, endtime);	
		cJSON_AddNumberToObject(conditionItem, KK_SYNC_SCENE_CROSSDAY_STR, crossDay);	
		cJSON_AddNumberToObject(conditionItem, KK_SYNC_SCENE_REPEATDAY_STR, repeat);		
		cJSON_AddItemToArray(conditionArray, conditionItem);			
	}	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;	
}
static int kk_get_scenes_info(cJSON *data)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	int enable = 0,type = 0;
	char *name = NULL;
	char *sceneId = NULL;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();		
	if(data == NULL){
		return FAIL_RETURN;
	}
	cJSON *sceneArray = cJSON_CreateArray();	
	sqlCmd = sqlite3_mprintf("select * from SceneInfo");
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *sceneArrayItem = cJSON_CreateObject();
        enable = sqlite3_column_int(stmt, DB_SCENEINFO_ENABLE);
		if(enable == 1){
			cJSON_AddStringToObject(sceneArrayItem, KK_SYNC_SCENE_ENABLE_STR, "启动");	
		}else{
			cJSON_AddStringToObject(sceneArrayItem, KK_SYNC_SCENE_ENABLE_STR, "禁用");	

		}
		type = sqlite3_column_int(stmt, DB_SCENEINFO_SCENETYPE);
		cJSON_AddNumberToObject(sceneArrayItem, KK_SYNC_SCENE_SCENETYPE_STR, type);	
		name = (char*)sqlite3_column_text(stmt, DB_SCENEINFO_NAME);
		cJSON_AddStringToObject(sceneArrayItem, KK_SYNC_NANE_STR, name);	
		sceneId = (char*)sqlite3_column_text(stmt, DB_SCENEINFO_SCENEID);
		cJSON_AddStringToObject(sceneArrayItem, KK_SYNC_SCENEID_STR, sceneId);
		cJSON *actionArray = cJSON_CreateArray();
		kk_get_scenes_actions_info(actionArray);	
		cJSON_AddItemToObject(sceneArrayItem, KK_SYNC_SCENE_ACTIONS_STR, actionArray);	
		cJSON *triggerArray = cJSON_CreateArray();
		kk_get_scenes_trigger_info(triggerArray,sceneId);	
		cJSON_AddItemToObject(sceneArrayItem, KK_SYNC_SCENE_TRIGGER_STR, triggerArray);		
		cJSON *conditionArray = cJSON_CreateArray();
		kk_get_scenes_condition_info(conditionArray,sceneId);	
		cJSON_AddItemToObject(sceneArrayItem, KK_SYNC_SCENE_CONDITION_STR, conditionArray);				
		cJSON_AddItemToArray(sceneArray, sceneArrayItem);			
	}			
	cJSON_AddItemToObject(data, KK_SYNC_SCENE_STR, sceneArray);	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);
	return SUCCESS_RETURN;		
}
static int kk_get_ccu_properties(cJSON *property)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	if(property == NULL){
		return FAIL_RETURN;
	}
	
	_kk_sync_lock();
	sqlCmd = sqlite3_mprintf("select * from PropertiesInfo WHERE devType = '%d' ",KK_DM_DEVICE_CCU);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
        propertyStr = (char*)sqlite3_column_text(stmt, DB_IDENTIFITER);
		valueType = sqlite3_column_int(stmt, DB_VALUETYPE);
		valueStr = (char*)sqlite3_column_text(stmt, DB_VALUE);
		if(valueType == KK_TSL_DATA_TYPE_TEXT){
			cJSON_AddStringToObject(property, propertyStr, valueStr);
		}else if(valueType == KK_TSL_DATA_TYPE_INT||
            valueType == KK_TSL_DATA_TYPE_ENUM||
            valueType == KK_TSL_DATA_TYPE_BOOL){
			cJSON_AddNumberToObject(property, propertyStr, atoi(valueStr));
		}
	}

	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);
	_kk_sync_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述：检查设备是否有重复
*输入参数：deviceCode：设备deviceCode
*输出参数：无
*返 回 值：1:存在；0：不存在
*其他说明：
*************************************************************/
char *kk_sync_get_info()
{
	char *out = NULL;
	char ccu_deviceCode[DEVICE_CODE_MAXLEN] = {0};
	char ccu_productCode[PRODUCT_CODE_MAXLEN] = {0};	
	char version[32] = {0};	
	char cloudstatus_str[16] = {0};	
	cJSON *root=cJSON_CreateObject();
	cJSON_AddStringToObject(root,KK_SYNC_CODE_STR,"0");
	cJSON *data = cJSON_CreateObject();
	cJSON_AddItemToObject(root, KK_SYNC_DATA_STR, data);
	kk_get_rooms_info(data);
	kk_get_devices_info(data);
	kk_get_scenes_info(data);
	HAL_GetDevice_Code(ccu_deviceCode);
	HAL_GetProduct_Code(ccu_productCode);	
	HAL_GetVersion(version);	
	cJSON_AddStringToObject(data, KK_SYNC_DEVICECODE_STR,ccu_deviceCode);
	cJSON_AddStringToObject(data, KK_SYNC_NANE_STR, "newccu");	
	sprintf(cloudstatus_str, "%d", kk_get_cloudstatus());
	cJSON_AddStringToObject(data, KK_SYNC_ONLINE_STR, cloudstatus_str);	
	cJSON_AddStringToObject(data, KK_SYNC_PRODUCTCODE_STR, ccu_productCode);	
	cJSON_AddStringToObject(data, KK_SYNC_VERSION_STR, version);
	cJSON *property = cJSON_CreateObject();

	kk_get_ccu_properties(property);	
	cJSON_AddItemToObject(data, KK_SYNC_PROPERTY_STR, property);
	out=cJSON_Print(root);
	printf("kk_sync_get_info:%s\n",out);
	cJSON_Delete(root); 
	//free(out);	
	return out;
}

