#ifndef __OLED_DP_H__
#define __OLED_DP_H__

/*
* 1. 字表由打包资料中的“取字软件”计算得出;
* 2. 取字方式 -- 共阴、列行式、逆向输出
*/

/***************说明***********/
//显示屏有几种显示模式
//1.字符模式，长度50，分为两种大小6x8和8x16
//2.中文模式，需要的汉字需要通过取模软件取模
//3.图片模式，图片也要经过取模

// 屏幕的几种模式
enum oled_mode
{
    oled_clear=0,                   //清屏
    oled_fill,                      //填充
    oled_show_chn,                  //显示汉字
    oled_show_str,                  //显示字符
    oled_show_bmp,                  //显示图片
    oled_sleep,                     //睡眠，可以省电
    oled_wakeup                     //从睡眠模式唤醒
};

enum oled_str_mode
{
    show_6x8_mode = 1,                //字符模式的两种大小
    show_8x16_mode
};

typedef struct show_str             //字符模式
{
    enum oled_str_mode str_size;    //字符的大小
    uint8_t pos_x;                  //需要显示的位置
    uint8_t pos_y;
    uint8_t str[50];                //字符内容
}str_mode;

typedef struct show_chn     //中文模式
{
    uint8_t pos_x;          //显示的位置
    uint8_t pos_y;
    uint8_t chn[32];        //显示内容
    uint8_t chn_size;       //
}chn_mode;

typedef struct show_bmp     //图片模式
{
    uint8_t start_x;        //开始位置
    uint8_t start_y;
    uint8_t end_x;          //图片结束位置
    uint8_t end_y;
    uint8_t bmp[1024];      //图片内容
    uint16_t len;           //图片内容字节数
} bmp_mode;

typedef struct OLED
{
    enum oled_mode oled_oper_mode;  //选择模式
    str_mode str_info;
    chn_mode chn_info;
    bmp_mode bmp_info;
    uint8_t fill_char;          //填充模式需要填充的字节
} OLED_INFO;

void sleep_screen(void);
void wakeup_screen(void);
void clear_screen(void);
void fill_screen(uint8_t fill_data);
void show_str_set(char *str, uint8_t x, uint8_t y, uint8_t strsize);
void show_bmp_set(uint8_t x, uint8_t y, uint8_t x1, uint8_t y1, uint8_t bmp[], uint16_t bmp_len);
void show_chn_set(uint8_t x, uint8_t y, uint8_t num, uint8_t size);
void write1306(void);

#endif /* __OLED_DP_H__ */
