/*******************************************************************************
 * Copyright (c) 2012, 2020 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *   https://www.eclipse.org/legal/epl-2.0/
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial contribution
 *******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "MQTTAsync.h"
#include "mqtt_api.h"
#include "com_api.h"
#include "kk_product.h"
//#include "kcloud_log.h"

static int mqtt_start(void)
{
	int count = 0;
	MQTTAsync mqttClient;
	int rc = 0;
	mqttClient = KK_MQTT_Connect();
	if(mqttClient == NULL)
	{
		WARNING_PRINT("KK_MQTT_Connect FAIL!!!\n");
	}
	while(1)
	{
		usleep(100000L);
		count++;
		if(count>50)
		{
			count = 0;
			//INFO_PRINT("i am send now\n");
			//KK_MQTT_SendMsg(TOPIC,"hello my world",2);
		}
		//INFO_PRINT(" %s \n",testStr);

	}
	INFO_PRINT("MQTTAsync_destroy\n");
	MQTTAsync_destroy(&mqttClient);
	return rc;

}
int kk_start_ccu_register(void);
extern int kk_info_report_start(void);
int main(int argc, char* argv[])
{
	int rc = 0;
		
	open("kcloud",LOG_PID,LOG_USER);
	/*set the callback to get the device date to cloud*/
	kk_ipc_init(IPC_APP2MID,(ipc_cb*)KK_Data_FromDev,NULL,NULL);
	kk_info_report_start();
again:	
	rc = kk_start_ccu_register();
	if(rc == 0){
		rc = mqtt_start();
	}else{
		goto again;
	}
	return rc;
}

