#ifndef __KK_DM_MSG__
#define __KK_DM_MSG__
#include "kk_tsl_common.h"
#include "cJSON.h"
#include "../tsl_handle/lite-cjson.h"
#include "kk_dm_mng.h"
#include "kk_tsl_api.h"

#define DM_MSG_KEY_ID                   "id"
#define DM_MSG_KEY_VERSION              "version"
#define DM_MSG_KEY_METHOD               "method"
#define DM_MSG_KEY_PARAMS               "params"
#define DM_MSG_KEY_CODE                 "code"
#define DM_MSG_KEY_DATA                 "data"
#define DM_MSG_KEY_MESSAGE              "message"

#define DM_MSG_VERSION                  "1.0"

#define DM_MSG_KEY_PRODUCT_KEY          "productKey"
#define DM_MSG_KEY_DEVICE_NAME          "deviceName"
#define DM_MSG_KEY_DEVICE_SECRET        "deviceSecret"
#define DM_MSG_KEY_TIME                 "time"


#define DM_MSG_SIGN_METHOD_SHA256       "Sha256"
#define DM_MSG_SIGN_METHOD_HMACMD5      "hmacMd5"
#define DM_MSG_SIGN_METHOD_HMACSHA1     "hmacSha1"
#define DM_MSG_SIGN_METHOD_HMACSHA256   "hmacSha256"


typedef struct {
	lite_cjson_t id;
	lite_cjson_t code;
	lite_cjson_t data;
	lite_cjson_t message;
} dm_msg_response_payload_t;


#ifndef DM_READ_ONLY
    #define DM_READ_ONLY
#endif
#define DM_MSG_VERSION                  "1.0"
//const char DM_MSG_INFO[] DM_READ_ONLY;

#define KK_REGISTER_TOPIC_REPLY                   "/thing/sub/register_reply"
#define KK_ADD_TOPIC_REPLY                        "/thing/topo/add_reply"
#define KK_LOGIN_TOPIC_REPLY                      "/thing/combine/login_reply"
#define KK_THING_STATUS_ONLINE                    "/thing/status/online"
#define KK_ONLINE_TOPIC_REPLY                     "/thing/status/online_reply"
#define KK_THING_SERVICE_PROPERTY_SET             "/thing/service/property/set"
#define KK_THING_SERVICE_PROPERTY_GET             "/thing/service/property/get"
#define KK_THING_OTA_DEVICE_UPGRADE	              "/thing/service/upgrade"
#define KK_THING_CLOUDSTATE_MSG                   "/thing/ccu/cloudstate_reply"
#define KK_THING_TOPO_ADD_MSG                     "/thing/topo/add"
#define KK_THING_TOPO_BATCH_ADD_MSG               "/thing/topo/batch_add"
#define KK_THING_PROPERTY_POST                    "property/post"
#define KK_THING_TOPO_DELETE_MSG                  "/thing/topo/delete"
#define KK_THING_TOPO_BATCH_DELETE_MSG            "/thing/topo/batch_delete"
#define KK_THING_TOPO_CHANGE_MSG                  "/thing/topo/change"
#define KK_THING_SERVICE_REBOOT                   "/thing/service/reboot"
#define KK_THING_SERVICE_ADDROOM                  "/thing/service/addRoom"
#define KK_THING_SERVICE_ADDROOM_REPLY            "/thing/service/addRoom_reply"
#define KK_THING_SERVICE_UPDATEROOM               "/thing/service/updateRoom"
#define KK_THING_SERVICE_UPDATEROOM_REPLY         "/thing/service/updateRoom_reply"
#define KK_THING_SERVICE_DELETEROOM               "/thing/service/deleteRoom"
#define KK_THING_SERVICE_DELETEROOM_REPLY         "/thing/service/deleteRoom_reply"
#define KK_THING_SERVICE_ADDDEVICETOROOM          "/thing/service/addDeviceToRoom"
#define KK_THING_SERVICE_ADDDEVICETOROOM_REPLY    "/thing/service/addDeviceToRoom_reply"
#define KK_THING_SERVICE_REMOVEDEVICEFROMROOM     "/thing/service/removeDeviceFromRoom"
#define KK_THING_SERVICE_REMOVEDEVICEFROMROOM_REPLY     "/thing/service/removeDeviceFromRoom_reply"
#define KK_THING_SERVICE_EXECUTEROOM              "/thing/service/executeRoom"
#define KK_THING_SERVICE_SETLOCALTIMER            "/thing/service/setLocalTimer"
#define KK_THING_SERVICE_GETLOCALTIMER            "/thing/service/getLocalTimer"
#define KK_THING_SERVICE_SETCOUNTDOWN             "/thing/service/setCountDown"
#define KK_THING_SERVICE_GETCOUNTDOWN             "/thing/service/getCountDown"
#define KK_THING_SERVICE_GETKEYLIST               "/thing/service/GetKeyList"
#define KK_THING_SERVICE_ADDKEY                   "/thing/service/AddKey"
#define KK_THING_SERVICE_DELETEKEY                "/thing/service/DeleteKey"
#define KK_THING_SERVICE_MODIFYKEY                "/thing/service/ModifyKey"
#define KK_THING_SERVICE_ADDSCENC                 "/thing/service/addScene"
#define KK_THING_SERVICE_ADDSCENC_REPLY           "/thing/service/addScene_reply"
#define KK_THING_SERVICE_DELETESCENC              "/thing/service/deleteScene"
#define KK_THING_SERVICE_DELETESCENC_REPLY        "/thing/service/deleteScene_reply"
#define KK_THING_SERVICE_UPDATESCENC              "/thing/service/updateScene"
#define KK_THING_SERVICE_UPDATESCENC_REPLY        "/thing/service/updateScene_reply"
#define KK_THING_SERVICE_PROPERTY_GET_REPLY       "/thing/service/property/get_reply"
#define KK_THING_SERVICE_EXECUTESCENE             "/thing/service/executeScene"
#define KK_THING_SERVICE_EXECUTESCENE_REPLY       "/thing/service/executeScene_reply"
#define KK_THING_SERVICE_NEGATIVE             	  "/thing/service/negativeProperty"
#define KK_THING_METHOD_DELETESCENC               "thing.service.deleteScene"
#define KK_THING_METHOD_UPDATESCENC               "thing.service.updateScene"
#define KK_THING_METHOD_EXECUTESCENE              "thing.service.executeScene"
#define KK_THING_METHOD_ADDSCENC                  "thing.service.addScene"
#define KK_THING_SERVICE_SYNCINFOPUSH             "/thing/service/syncinfopush"
#define KK_THING_SERVICE_SYNCINFO                 "/thing/service/syncinfo"
#define KK_THING_SERVICE_SYNCDEVICEINFO           "/thing/service/syncDeviceInfo"
#define KK_THING_SERVICE_SYNCDEVICEINFO_REPLY     "/thing/service/syncDeviceInfo_reply"
#define KK_THING_SERVICE_CLOUDSTATUS              "/thing/service/cloudStatus"
#define KK_THING_SERVICE_EXECUTEDNDMODE           "/thing/service/executeDNDMode"
#define KK_THING_SERVICE_SETFLOOR                 "/thing/service/setRoomsToFloors"
#define KK_THING_SERVICE_SETFLOOR_REPLY           "/thing/service/setRoomsToFloors_reply"
#define KK_THING_SERVICE_GETFLOOR                 "/thing/service/getAllFloors"
#define KK_THING_SERVICE_GETFLOOR_REPLY           "/thing/service/getAllFloors_reply"
#define KK_THING_SERVICE_SYNCINFO_REPLY           "/thing/service/syncinfo_reply"
#define KK_THING_SERVICE_SYNCINFOPUSH_REPLY       "/thing/service/syncinfopush_reply"
#define KK_THING_SERVICE_ADDFLOORS                "/thing/service/addFloors"
#define KK_THING_SERVICE_ADDFLOORS_REPLY          "/thing/service/addFloors_reply"
#define KK_THING_EVENT_MESSAGE                    "/thing/event/"
#define KK_THING_SERVICE_GETGUARDSENSORS          "/thing/service/getGuardSensors"
#define KK_THING_EVENT_POST                       "/post"
#define KK_THING_SERVICE_BINDSCENE          	  "/thing/service/bindScene"
#define KK_THING_SERVICE_UNBINDSBUTTTON           "/thing/service/unbindButton"
#define KK_THING_SERVICE_ACTIVEBUTTON             "/thing/service/activeButton"
#define KK_THING_SERVICE_GETCCUVERSION            "/thing/service/getCCUVersion"
#define KK_THING_SERVICE_HISTORYALARM             "/thing/service/historyAlarm"
#define KK_THING_SERVICE_HISTORYALARM_REPLY       "/thing/service/historyAlarm_reply"
#define KK_THING_SERVICE_DEL_HISTORYALARM         "/thing/service/delAlarm"
#define KK_THING_SERVICE_DEL_HISTORYALARM_REPLY   "/thing/service/delAlarm_reply"
#define KK_THING_SERVICE_DELETEFLOORS             "/thing/service/deleteFloors"
#define KK_THING_SERVICE_DELETEFLOORS_REPLY       "/thing/service/deleteFloors_reply"
#define KK_THING_SERVICE_UPDATEFLOORS             "/thing/service/updateFloors"
#define KK_THING_SERVICE_UPDATEFLOORS_REPLY       "/thing/service/updateFloors_reply"

void kk_sendData2app(void *info, void *payload,int isAsync);
int dm_msg_thing_sub_register(_IN_ char productCode[DEVICE_CODE_MAXLEN], _IN_ char deviceCode[DEVICE_CODE_MAXLEN],
                              _OU_ dm_msg_request_t *request);
int dm_msg_thing_sub_unregister(_IN_ char deviceCode[DEVICE_CODE_MAXLEN],_OU_ dm_msg_request_t *request);
int dm_msg_thing_topo_add(_IN_ char productCode[PRODUCT_CODE_MAXLEN],
                        _IN_ char deviceCode[DEVICE_CODE_MAXLEN], _IN_ char mac[DEVICE_MAC_MAXLEN],
                        _OU_ dm_msg_request_t *request);
int dm_msg_ccu_property_post(dm_mgr_dev_node_t *node);
int dm_msg_thing_property_post_by_identify(char *deviceCode,cJSON *params);
int dm_msg_thing_topo_delete(_IN_ char deviceCode[DEVICE_CODE_MAXLEN],_OU_ dm_msg_request_t *request);
 int dm_msg_thing_topo_get(_OU_ dm_msg_request_t *request);
  int dm_msg_thing_list_found(_IN_ char deviceCode[DEVICE_CODE_MAXLEN],
                             _OU_ dm_msg_request_t *request);
 int dm_msg_status_cloud(_IN_ char productCode[PRODUCT_CODE_MAXLEN],
						  _IN_ char deviceCode[DEVICE_CODE_MAXLEN], _OU_ dm_msg_request_t *request);  
 int dm_msg_status_online(_IN_ char productCode[PRODUCT_CODE_MAXLEN],
						  _IN_ char deviceCode[DEVICE_CODE_MAXLEN], _OU_ dm_msg_request_t *request);
int dm_msg_status_offline(_IN_ char productCode[PRODUCT_CODE_MAXLEN],
						_IN_ char deviceCode[DEVICE_CODE_MAXLEN], _OU_ dm_msg_request_t *request);
int dm_msg_combine_login(_IN_ char productCode[PRODUCT_CODE_MAXLEN],
                         _IN_ char deviceCode[DEVICE_CODE_MAXLEN], _OU_ dm_msg_request_t *request);
int dm_msg_combine_logout(_IN_ char deviceCode[DEVICE_CODE_MAXLEN],_OU_ dm_msg_request_t *request);
 int dm_msg_ota_report_version(_IN_ char *version,
                                      _OU_ dm_msg_request_t *request);
int dm_msg_request (_IN_ dm_msg_request_t *request,_IN_ int isAsync);
int dm_msg_response(_IN_ kk_msg_request_payload_t *request, _IN_ kk_msg_response_t *response,
                    _IN_ char *data, _IN_ int data_len, _IN_ void *user_data);

int dm_msg_response_parse(_IN_ char *payload, _IN_ int payload_len, _OU_ dm_msg_response_payload_t *response);
int dm_msg_thing_property_set_reply(char deviceCode[DEVICE_CODE_MAXLEN],char *payload, unsigned int payload_len,
        void *context);
int dm_msg_thing_event_post(const char *deviceCode, const char *identifier,const char *msgId);
int dm_msg_scene_event_post(const char *identifier,kk_tsl_t *dev_shadow,const char *msgId);
int dm_msg_thing_service_post(const char *deviceCode, const char *identifier);
int dm_msg_thing_property_post_all(char *deviceCode);
int dm_msg_ccu_property_post(dm_mgr_dev_node_t *node);
int dm_msg_thing_property_post_by_identify(char *deviceCode,cJSON *params);
int kk_msg_execute_property_set(const char *productCode,const char *deviceCode,const char* params,const char *fatherDeviceCode);
int kk_msg_execute_property_get(dm_mgr_dev_node_t *node);
int kk_msg_parse_productType(char *str,char *productType);     
int kk_msg_execute_scene_set(const char* params,const char *fatherDeviceCode,int isUpdate);
int kk_msg_execute_scene_action(const char* params,const char *fatherDeviceCode);
int kk_msg_execute_scene_delete(const char* params,const char *fatherDeviceCode);   
int dm_msg_thing_syncinfo_reply(void);                                                                                                                                                                                       
int dm_msg_thing_syncinfopush_reply(void);
void kk_split(char *src,const char *separator,char **dest,int *num);
int kk_msg_cloud_status_notify(char *deviceCode,const char *productCode);
int dm_msg_thing_syncdeviceinfo_reply(cJSON *msgId);
//const char DM_URI_SYS_PREFIX[]                        DM_READ_ONLY = "/sys/%s/%s/";


#endif
