#ifndef _KK_LAN_VP_CTRL_H
#define _KK_LAN_VP_CTRL_H


#include "kk_newccu_msg.h"
#include "kk_lan_node_db.h"




#define VP_CTRL_OPEN										0X01
#define VP_CTRL_CLOSE										0X02
#define VP_CTRL_STOP										0X03
#define VP_CTRL_GO_ON										0X04
#define VP_CTRL_QUERY_ONOFF_STATUS							0X05
#define VP_CTRL_QUERY_AIR_QUALITY							0X06
#define VP_CTRL_QUERY_HUMIDITY								0X07
#define VP_CTRL_QUERY_WATER_TMP								0X08
#define VP_CTRL_QUERY_TMP									0X09
#define VP_CTRL_QUERY_WEATHER								0X0A
#define VP_CTRL_PLAY										0X0C
#define VP_CTRL_LEAVE_UP									0X0D
#define VP_CTRL_LEAVE_DOWN									0X0E
#define VP_CTRL_LEAVE_SET									0X0F
#define VP_CTRL_WINDSPEE_UP									0X10
#define VP_CTRL_WINDSPEE_DOWN								0X11
#define VP_CTRL_WINDSPEE_SET								0X12
#define VP_CTRL_OPEN_LITTLE									0X16
#define VP_CTRL_UP											0X17
#define VP_CTRL_DOWN										0X18
#define VP_CTRL_BRIGHTNESS_DOWN								0X19
#define VP_CTRL_BRIGHTNESS_UP								0X1A
#define VP_CTRL_BRIGHTNESS_SET								0X1B
#define VP_CTRL_MODE										0X1C
#define VP_CTRL_PREVIOUS									0X1E
#define VP_CTRL_NEXT										0X1F
#define VP_CTRL_WIND_DIR									0x20
#define VP_CTRL_TMP_UP										0X23
#define VP_CTRL_TMP_DOWN									0x24
#define VP_CTRL_TMP_SET										0x25
#define VP_CTRL_SET_COLOR									0x26
//#define VP_CTRL_SET_COLOR_TMP								0x27
#define VP_CTRL_SET_COLOR_TMP								0x28




//SKILL TYPE(0x12)----------------------------------------->WINDSPEED
#define VP_SKILLTYPE_12_WINDSPEED_LOW						0x01
#define VP_SKILLTYPE_12_WINDSPEED_MID						0x02
#define VP_SKILLTYPE_12_WINDSPEED_HIGH						0x03
#define VP_SKILLTYPE_12_WINDSPEED_AUTO						0x04


//SKILL TYPE(0X1C)----------------------------------------->WORKMODE
#define VP_SKILLTYPE_1C_WORKMODE_AUTO						0x01
#define VP_SKILLTYPE_1C_WORKMODE_MANUAL						0x02
#define VP_SKILLTYPE_1C_WORKMODE_COLD						0x03
#define VP_SKILLTYPE_1C_WORKMODE_HEATING					0x04
#define VP_SKILLTYPE_1C_WORKMODE_ENERGY						0x05
#define VP_SKILLTYPE_1C_WORKMODE_COMFORT					0x06
#define VP_SKILLTYPE_1C_WORKMODE_FAN						0x07
#define VP_SKILLTYPE_1C_WORKMODE_DEHUM						0x08



#define AIR_CONDITIONER_DEV_PID	{\
	3062\
}


//DEVICE PID DEFINE
//3001,3002,3003,3022,3023,3024
#define LIGHT_DEV_PID		{\
	3001,3002,3003,3009,3010,3011,3022,3023,3024,3069,3078,3079,3085,3086,3087,3115\
}
//3005,3006,3007,3008,3009,3010,3011,3026,3027,3067
#define CURTAIN_DEV_PID		{\
	3005,3006,3012,3013,3017,3026,3027,3067,3068,3088,3089\
}
//3019,3020,3037,3038
#define OUTLET_DEV_PID		{\
	3019,3020,3037,3038\
}

#define FRESHAIR_DEV_PID	{\
	3032,3099\
}

#define FANCOILSWITCH_DEV_PID	{\
	3031,3033,3034,3035,3036,3095,3098\
}

#define UNDERFLOOR_HEATING_DEV_PID	{\
	3029,3030,3097\
}


#define DIMMING_LIGHT_DEV_PID	{\
	3018,3028,3091,3092,3093,3094,3102\
}





int kk_lan_vp_control(uint8_t num,uint32_t nodeIdAry[],uint8_t *arg,uint8_t arg_len);









#endif




