/*******************************************************************************
 * Copyright (c) 2012, 2020 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *   https://www.eclipse.org/legal/epl-2.0/
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial contribution
 *******************************************************************************/

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "com_api.h"
#include "kk_product.h"
#include "kk_findccu_handle.h"
#include "kk_login_handle.h"
#include "kk_data_handle.h"

//#include "kk_lan_queue.h"
#include "kk_lan_node_db.h"
#include "kk_lan_voice_panel.h"
#include "kk_data_mng.h"
#include "kk_lan_debug.h"
extern char * _kk_data_create(char *msgtype,const char *productCode,const char *deviceCode,const char *param);


static char s_ccuid[DEVICE_CODE_LEN] = {0};
int kk_lan_get_ccuid(_OU_ char *device_code)
{
	strncpy(device_code, s_ccuid, strlen(s_ccuid));
	printf("kk_lan_get_ccuid:%s\n",s_ccuid);
	return strlen(s_ccuid);
}
static int _setDevice_Code(_IN_ char *device_code,int len)
{
	memset(s_ccuid, 0x0, DEVICE_CODE_LEN);
	printf("_setDevice_Code:%s\n",device_code);
	strncpy(s_ccuid, device_code, len);
	return len;
}
extern int HAL_Execel_cmd(char * cmd,char * buf,int buf_len,int* ret_len);
static void kk_lan_ccuid_init(void)
{
    uint8_t ccuid[DEVICE_CODE_LEN] = {0};
	uint8_t ccuidTmp[DEVICE_CODE_LEN] = {0};
    int ccuid_len = 0;
    HAL_Execel_cmd(GET_CCUID_CMD,(char *)ccuid,sizeof(ccuid),&ccuid_len);
    printf("GET_CCUID_CMD:%s\n",ccuid);
    if(ccuid_len > 0 && ccuid_len <= DEVICE_CODE_LEN){
		sprintf((char *)ccuidTmp,"CCU_%s",ccuid);
        _setDevice_Code((char *)ccuidTmp,strlen((char *)ccuidTmp)-1);
    }else{
        //_setDevice_Code(KK_CCU_ID,strlen(KK_CCU_ID));
    }
}

int prg_run_singleton(const char *prg)
{
	int fd;
	int ret;
	char pid_file[256] = {0};
	char pid_data[32] = {0};
	struct flock fl;
	
	if(prg==NULL){
		return -1;
	}
	
	memset(pid_file,0,sizeof(pid_file));
	snprintf(pid_file, sizeof(pid_file), "/var/run/%s.pid",prg);

	fd = open(pid_file, O_CREAT|O_WRONLY|O_TRUNC, 0644);
	if(fd<0){
		return -1;
	}
	
	fl.l_type = F_WRLCK;
	fl.l_start = 0;
	fl.l_whence = SEEK_SET;
	fl.l_len = 0;
	ret = fcntl(fd,F_SETLK,&fl);
	
	if(ret < 0){
		return -1;
	}
	
	memset(pid_data,0,sizeof(pid_data));
	snprintf(pid_data, sizeof(pid_data), "%d",getpid());
	
	return write(fd,pid_data,strlen(pid_data));
}


#define SYNC_INFO_FLAG				0x01
#define SYNC_INFO_PUSH_FLAG 		0x02
static int g_sync_flag;

void kk_sync_info(void)
{
	if(g_sync_flag&SYNC_INFO_FLAG){
		debug_log(LOG_CRIT_LEVEL,"[SYNC INFO] delay.\n");
	}
	g_sync_flag|=SYNC_INFO_FLAG;
}
void kk_sync_info_push(void)
{
	if(g_sync_flag&SYNC_INFO_PUSH_FLAG){
		debug_log(LOG_CRIT_LEVEL,"[SYNC INFO PUSH] delay.\n");
	}
	g_sync_flag|=SYNC_INFO_PUSH_FLAG;
}


void handler(int signum)
{
	debug_log(LOG_CRIT_LEVEL,"[sig]---------------------->signum=%d\n",signum);
	if(signum!=17 &&signum!=SIGALRM){
		exit(-1);
	}
}

void kk_sync_timer_start(void)
{
	struct itimerval timer;
	timer.it_value.tv_sec = 30;
	timer.it_value.tv_usec = 0;
	timer.it_interval.tv_sec = 0;
	timer.it_interval.tv_usec = 0;
	if(setitimer(ITIMER_REAL, &timer, NULL)<0){
		debug_log(LOG_ALERT_LEVEL,"err.\n");
	};
}


int kk_sync_timer_is_running(void)
{
	struct itimerval timer;
	getitimer(ITIMER_REAL,&timer);
	if(timer.it_value.tv_sec!=0||timer.it_value.tv_usec!=0){
		return 1;
	}
	return 0;
}







int main(int argc, char* argv[])
{
	int ret = 0;

	struct sigaction sa;
	
	/* setup alarm signal handler */

	for(int i=1;i<32;i++){
		signal(i, handler);
	}


	//signal(SIGPIPE, SIG_IGN);



	

	openlog("kk_lan",LOG_CONS|LOG_PID,LOG_USER);



	//if(prg_run_singleton(argv[0])<0){
		//debug_log(LOG_CRITICAL_LEVEL,"[%s]run singleton fail!\n",argv[0]);
		//return -1;
	//}

	kk_lan_ccuid_init();

	/*set the callback to get the device date to cloud*/
	kk_ipc_init(IPC_APP2MID,(ipc_cb*)KK_Data_FromMid,NULL,NULL);
	kk_findccu_handle_init();
	kk_map_dev_init();
	kk_login_init();

	
	kk_voice_panel_init(argc,argv);

	//lan_queue_init();
	kk_lan_db_node_init();
	//kk_handle_sync_info();


	while(1){

		if(kk_sync_timer_is_running()==0&&g_sync_flag!=0){
			char *send_data = NULL;

			if(g_sync_flag&SYNC_INFO_FLAG){
				debug_log(LOG_INFO_LEVEL,"[SYNC INFO].\n");
				
				send_data = _kk_data_create(SYNC_MSG_TYPE,"*","*","*");
				g_sync_flag&=~SYNC_INFO_FLAG;
			}else if(g_sync_flag&SYNC_INFO_PUSH_FLAG){
				debug_log(LOG_INFO_LEVEL,"[SYNC INFO PUSH].\n");
				
				send_data  = _kk_data_create(SYNCPUSH_MSG_TYPE,"*","*","*");
				kk_handle_sync_push_info();
				g_sync_flag&=~SYNC_INFO_PUSH_FLAG;
			}else{
				g_sync_flag = 0;
				debug_log(LOG_ALERT_LEVEL,"err\n");
			}

			if(send_data != NULL){
				kk_ipc_send(IPC_APP2MID, send_data, strlen(send_data)+1);
				kk_sync_timer_start();
				free(send_data);
			}

		}
		
		usleep(50);
	}
	return 0;
}

