#include "RPC_API.h"
#include "rpc_onoff.h"




cJSON *rpc_zclOnOff_On(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
	}
	if(item_node==NULL ||
		item_ep==NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);

	status = zclOnOff_On(node,ep);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclOnOff_Off(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
	}
	if(item_node==NULL ||
		item_ep==NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);

	status = zclOnOff_Off(node,ep);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclOnOff_Toggle(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
	}
	if(item_node==NULL ||
		item_ep==NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);

	status = zclOnOff_Toggle(node,ep);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclOnOff_OffWithEffect(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_id;
	cJSON *item_var;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_id = cJSON_GetObjectItem(params, "identifier");
		item_var = cJSON_GetObjectItem(params, "variant");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_id ==NULL ||
		item_var == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String||
		item_id->type!=cJSON_String||
		item_var->type!=cJSON_String){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("identifier=%s\n",item_id->valuestring);
	kk_print_debug("variant=%s\n",item_var->valuestring);

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t identifier = rpc_get_u8(item_id->valuestring);
	uint8_t var = rpc_get_u8(item_var->valuestring);

	status = zclOnOff_OffWithEffect(node,ep,identifier,var);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclOnOff_OnWithRecallGlobalScene(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
	}
	if(item_node==NULL ||
		item_ep==NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);

	status = zclOnOff_OnWithRecallGlobalScene(node,ep);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclOnOff_OnWithTimedOff(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_control;
	cJSON *item_OnTime;
	cJSON *item_OffWaitTime;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_control = cJSON_GetObjectItem(params, "control");
		item_OnTime = cJSON_GetObjectItem(params, "OnTime");
		item_OffWaitTime = cJSON_GetObjectItem(params, "OffWaitTime");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_control ==NULL ||
		item_OnTime == NULL||
		item_OffWaitTime== NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String||
		item_control->type!=cJSON_String||
		item_OnTime->type!=cJSON_String||
		item_OffWaitTime->type!=cJSON_String){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("control=%s\n",item_control->valuestring);
	kk_print_debug("OnTime=%s\n",item_OnTime->valuestring);
	kk_print_debug("OffWaitTime=%s\n",item_OffWaitTime->valuestring);

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t control = rpc_get_u8(item_control->valuestring);
	uint16_t OnTime = rpc_get_u16(item_OnTime->valuestring);
	uint16_t OffWaitTime = rpc_get_u16(item_OffWaitTime->valuestring);

	status = zclOnOff_OnWithTimedOff(node,ep,control,OnTime,OffWaitTime);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}





















