#include "kk_tsl_property_report.h"
#include "kk_tsl_zigbee_map.h"
#include "kk_device_manager.h"

const char *kk_tsl_rpt_status_string[] = {
	"Success",
	"Error",
	"Invaild Value",
	"Invaild Len",
	"Invaild Type"
};
//todo: fix it
static int kk_tsl_report(EmberEUI64 mac,uint8_t EP,int status,uint16_t clusterId,uint16_t attributeId)
{
	cJSON* root;
	int index;
	char *Identify;
	sub_dev_node_t *node = NULL;
	kk_device_table_s *dev;
	kk_dev_config_map *dev_info = NULL;
	kk_dev_config_item *item = NULL;	
	char macString[RPC_EUI64_STRING_LENGTH];
	rpc_eui64ToString(mac,macString);

	root = rpc_cJSON_CreateObject();
	
	dev = kk_device_find_by_mac(mac);	
	if(dev == NULL){
		return tsl_rpt_err;
	}
	printf("[%s][%d]dev->productCode:%s\n",__FUNCTION__,__LINE__,dev->productCode);
	dev_info = kk_device_config_find(dev->productCode);
	if(dev_info == NULL){
		return tsl_rpt_err;
	}	

	item = &dev_info->item;
	while(item!=NULL){
		if(EP == item->endpoint &&
			clusterId == item->cluster&&
			attributeId == item->attribute){
			Identify = item->identity;

			break;
		}
		item = item->next;
	}

	rpc_cJSON_AddNumberToObject(root, Identify,status);
	kk_msg_report_property(root,mac);
	return tsl_rpt_success;
}



void kk_tsl_report_attribute(EmberEUI64 eui64,
									uint8_t EP,
									EmberAfClusterId clusterId,
									EmberAfAttributeId attributeId,
									uint8_t dataType,
									uint8_t len,
									uint8_t *data)
{
	int i,j,num,status;
	char macString[19] = {0};	
	sub_dev_node_t *node = NULL;
	int res = 0;

	UTIL_LOG_INFO("\n********************kk tsl report attribute********************\n");
	emberAfDebugPrint("mac:");
	emberAfDebugPrintln(",ep:%d,clu:0x%04X,attr:0x%04X,dataType=0x%02x,len=%d,data:",
						EP,clusterId,attributeId,dataType,len);
	emberAfDebugPrintBuffer(data,len,true);

	num = kk_get_tsl_num();
	for(i=0;i<num;i++){
		if( g_tsl_zigbee_map[i].clusterId == clusterId &&
			g_tsl_zigbee_map[i].attributeId == attributeId &&
			g_tsl_zigbee_map[i].zigbee_report!=NULL){
			status = g_tsl_zigbee_map[i].zigbee_report(eui64,EP,clusterId,attributeId,dataType,len,data);
			emberAfDebugPrintln("report status:%s",kk_tsl_rpt_status_string[status]);
			return ;
		}
	}
	rpc_eui64ToString(eui64,macString);
	res = kk_sub_tsl_get_device_by_mac(macString,&node);
	if(res != tsl_rpt_success){
		emberAfAppPrintln("[kk_tsl_report_attribute] error~~~~~~~~~\n");
		return;
	}
	
	num = kk_get_tsl_glb_num();
	for(i=0;i<num;i++){
		if( g_tsl_zigbee_map_glb[i].map.clusterId == clusterId &&
			g_tsl_zigbee_map_glb[i].map.attributeId == attributeId &&
			strncmp(node->productCode,g_tsl_zigbee_map_glb[i].ProductCode,strlen(node->productCode)) == 0 &&
			g_tsl_zigbee_map_glb[i].map.zigbee_report!=NULL){
			status = g_tsl_zigbee_map_glb[i].map.zigbee_report(eui64,EP,clusterId,attributeId,dataType,len,data);
			emberAfDebugPrintln("--report status:%s",kk_tsl_rpt_status_string[status]);
			return ;
		}
	}	
}


int kk_tsl_report_global_onoff(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t OnOff;
	emberAfAppPrintln("[tsl report:Gloabl] OnOff~~~~~~~~~");
	if(dataType == ZCL_BOOLEAN_ATTRIBUTE_TYPE){
		if(len==1){
			OnOff = data[0];
			if(OnOff==0 || OnOff==1){
				kk_tsl_report(eui64,EP,OnOff,clusterId,attributeId);
				return tsl_rpt_success;
			}
			return tsl_rpt_invaild_val;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_windowCovering_mode(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t mode;
	emberAfAppPrintln("[tsl report:Window Covering] Mode~~~~~~~~~");

	if(dataType == ZCL_BITMAP8_ATTRIBUTE_TYPE){
		if(len==1){
			if(data[0]&BIT(1)){
				mode = WC_calibration_mode;
			}else if(data[0]&BIT(0)){
				mode = WC_reversed_dir;
			}else{
				mode = WC_normal_dir;
			}

			kk_tsl_report(eui64,EP,mode,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}
int kk_tsl_report_windowCovering_position(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t position;
	emberAfAppPrintln("[tsl report:Window Covering] Position~~~~~~~~~");

	if(dataType == ZCL_INT8U_ATTRIBUTE_TYPE){
		if(len==1){
			position = data[0];
			kk_tsl_report(eui64,EP,position,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}


	

int kk_tsl_report_metering_summationDelivered(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint64_t summation;
	emberAfAppPrintln("[tsl report:meter(Smart Energy)] Summation Delivered~~~~~~~~~");

	if(dataType == ZCL_INT48U_ATTRIBUTE_TYPE){
		if(len==6){
			summation = KK_GET_U48(data);
			kk_tsl_report(eui64,EP,summation,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_ias_zoneStatus(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint64_t Status;
	emberAfAppPrintln("[tsl report:IAS] Zone Status~~~~~~~~~");

	if(dataType == ZCL_BITMAP16_ATTRIBUTE_TYPE){
		if(len==2){
			Status = KK_GET_U16(data);
			kk_tsl_report(eui64,EP,Status,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}



int kk_tsl_report_global_Level(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t level;
	emberAfAppPrintln("[tsl report:Gloabl] Level~~~~~~~~~");
	if(dataType == ZCL_INT8U_ATTRIBUTE_TYPE){
		if(len==1){
			level = data[0];
			kk_tsl_report(eui64,EP,level,clusterId,attributeId);
			return tsl_rpt_success;
			
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}


int kk_tsl_report_temperature_measure(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	int16_t Value;
	emberAfAppPrintln("[tsl report:temperature measurement] Measure Value~~~~~~~~~");
	if(dataType == ZCL_INT16S_ATTRIBUTE_TYPE){
		if(len==1){
			Value = KK_GET_U16(data);
			kk_tsl_report(eui64,EP,Value,clusterId,attributeId);
			return tsl_rpt_success;
			
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_illuminance_measure(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint16_t Value;
	emberAfAppPrintln("[tsl report:illuminance measurement] Measure Value~~~~~~~~~");
	if(dataType == ZCL_INT16U_ATTRIBUTE_TYPE){
		if(len==1){
			Value = KK_GET_U16(data);
			kk_tsl_report(eui64,EP,Value,clusterId,attributeId);
			return tsl_rpt_success;
			
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_local_temperature(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	int16_t Value;
	emberAfAppPrintln("[tsl report:local temperature] Value~~~~~~~~~");
	if(dataType == ZCL_INT16S_ATTRIBUTE_TYPE){
		if(len==1){
			Value = KK_GET_U16(data);
			kk_tsl_report(eui64,EP,Value,clusterId,attributeId);
			return tsl_rpt_success;
			
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_OccupiedHeatingSetpoint(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	int16_t Value;
	emberAfAppPrintln("[tsl report:Occupied Heating Setpoint] Value~~~~~~~~~");
	if(dataType == ZCL_INT16S_ATTRIBUTE_TYPE){
		if(len==1){
			Value = KK_GET_U16(data);
			kk_tsl_report(eui64,EP,Value,clusterId,attributeId);
			return tsl_rpt_success;
			
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_Concentration(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	int32_t Value;
	emberAfAppPrintln("[tsl report:Formaldehyde] Value~~~~~~~~~");
	if(dataType == ZCL_FLOAT_SINGLE_ATTRIBUTE_TYPE){
		if(len==1){
			Value = KK_GET_U32(data);
			kk_tsl_report(eui64,EP,Value,clusterId,attributeId);
			return tsl_rpt_success;
			
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}




int kk_tsl_report_Formaldehyde(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	emberAfAppPrintln("[tsl report:Formaldehyde] Value~~~~~~~~~");

	return kk_tsl_report_Concentration(eui64,EP,clusterId,attributeId,dataType,len,data);
}
int kk_tsl_report_PM2_5(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	emberAfAppPrintln("[tsl report:PM2.5] Value~~~~~~~~~");

	return kk_tsl_report_Concentration(eui64,EP,clusterId,attributeId,dataType,len,data);
}
int kk_tsl_report_CO2(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	emberAfAppPrintln("[tsl report:CO2] Value~~~~~~~~~");

	return kk_tsl_report_Concentration(eui64,EP,clusterId,attributeId,dataType,len,data);
}







